/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionsSchemasRegistry;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeCustomizationRegistry;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class XSDEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.xsd.ui";
    public static final String EDITOR_ID = "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor";
    public static final String CONST_XSD_DEFAULT_PREFIX_TEXT = "org.eclipse.wst.xmlschema.xsdDefaultPrefixText";
    public static final String CONST_PREFERED_BUILT_IN_TYPES = "org.eclipse.wst.xmlschema.preferedBuiltInTypes";
    public static final String CUSTOM_LIST_SEPARATOR = "\n";
    public static final String EXTENSIONS_SCHEMAS_EXTENSIONID = "org.eclipse.wst.xsd.ui.extensionCategories";
    private static final String DEPRECATED_EXTENSIONS_SCHEMAS_EXTENSIONID = "org.eclipse.wst.xsd.ui.ExtensionsSchemasDescription";
    public static final String DEFAULT_TARGET_NAMESPACE = "http://www.example.org";
    public static final String XSD_CONTENT_TYPE_ID = "org.eclipse.wst.xsd.core.xsdsource";
    private static XSDEditorPlugin plugin;
    private ResourceBundle resourceBundle;
    private ExtensionsSchemasRegistry registry;
    private NodeCustomizationRegistry nodeCustomizationRegistry;
    private XSDEditorConfiguration xsdEditorConfiguration = null;
    public static final String CONST_USE_SIMPLE_EDIT_MODE = "org.eclipse.wst.xsd.ui.useSimpleEditMode";
    public static final String CONST_SHOW_INHERITED_CONTENT = "org.eclipse.wst.xsd.ui.showInheritedContent";
    public static final String CONST_XSD_LANGUAGE_QUALIFY = "org.eclipse.wst.xmlschema.xsdQualify";
    public static final String CONST_DEFAULT_TARGET_NAMESPACE = "org.eclipse.wst.xmlschema.defaultTargetnamespaceText";
    public static final String CONST_SHOW_EXTERNALS = "org.eclipse.wst.xsd.ui.showExternals";
    public static String DEFAULT_PAGE;
    public static String DESIGN_PAGE;
    public static String SOURCE_PAGE;
    private static final String PRODUCT_CUSTOMIZATION_PROVIDER_PLUGIN_ID = "org.eclipse.wst.xsd.ui.productCustomizationProviderPluginId";
    private static final String PRODUCT_CUSTOMIZATION_PROVIDER_CLASS_NAME = "org.eclipse.wst.xsd.ui.productCustomizationProviderClassName";
    private static ProductCustomizationProvider productCustomizationProvider;
    private static boolean productCustomizationProviderInitialized;

    static {
        DEFAULT_PAGE = "org.eclipse.wst.xsd.ui.internal.defaultPage";
        DESIGN_PAGE = "org.eclipse.wst.xsd.ui.internal.designPage";
        SOURCE_PAGE = "org.eclipse.wst.xsd.ui.internal.sourcePage";
        productCustomizationProviderInitialized = false;
    }

    public XSDEditorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static XSDEditorPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = XSDEditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getResourceString(String key, Object o) {
        return XSDEditorPlugin.getResourceString(key, new Object[]{o});
    }

    public static String getResourceString(String key, Object[] objects) {
        return MessageFormat.format(XSDEditorPlugin.getResourceString(key), objects);
    }

    public static String getResourceString(String key, Object o1, Object o2) {
        return XSDEditorPlugin.getResourceString(key, new Object[]{o1, o2});
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static ImageDescriptor getImageDescriptor(String name, boolean getBaseURL) {
        try {
            URL installURL = XSDEditorPlugin.getDefault().getBundle().getEntry("/");
            String imageString = getBaseURL ? "icons/" + name : name;
            URL imageURL = new URL(installURL, imageString);
            return ImageDescriptor.createFromURL((URL)imageURL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Image getIcon(String name) {
        try {
            ImageRegistry imageRegistry = this.getImageRegistry();
            if (imageRegistry.get(name) != null) {
                return imageRegistry.get(name);
            }
            URL installURL = XSDEditorPlugin.getDefault().getBundle().getEntry("/");
            String imageString = "icons/" + name;
            URL imageURL = new URL(installURL, imageString);
            imageRegistry.put(name, ImageDescriptor.createFromURL((URL)imageURL));
            return imageRegistry.get(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static XSDEditorPlugin getPlugin() {
        return plugin;
    }

    public static String getXSDString(String key) {
        return XSDEditorPlugin.getResourceString(key);
    }

    public String getString(String key, Object s1) {
        return MessageFormat.format(Platform.getResourceBundle((Bundle)this.getBundle()).getString(key), s1);
    }

    public static Image getXSDImage(String iconName) {
        return XSDEditorPlugin.getDefault().getImage(iconName);
    }

    public Image getImage(String iconName) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        if (imageRegistry.get(iconName) != null) {
            return imageRegistry.get(iconName);
        }
        imageRegistry.put(iconName, ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)iconName));
        return imageRegistry.get(iconName);
    }

    public URL getBaseURL() {
        return this.getDescriptor().getInstallURL();
    }

    public Image getIconImage(String object) {
        try {
            return ExtendedImageRegistry.getInstance().getImage((Object)new URL(this.getBaseURL() + "icons/" + object + ".gif"));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean getShowInheritedContent() {
        return this.getPreferenceStore().getBoolean(CONST_SHOW_INHERITED_CONTENT);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(CONST_SHOW_INHERITED_CONTENT, false);
        store.setDefault(CONST_XSD_DEFAULT_PREFIX_TEXT, "xsd");
        store.setDefault(CONST_XSD_LANGUAGE_QUALIFY, false);
        store.setDefault(DEFAULT_PAGE, DESIGN_PAGE);
        store.setDefault(CONST_DEFAULT_TARGET_NAMESPACE, DEFAULT_TARGET_NAMESPACE);
        store.setDefault(CONST_SHOW_EXTERNALS, false);
        store.setDefault(CONST_PREFERED_BUILT_IN_TYPES, "boolean\ndate\ndateTime\ndouble\nfloat\nhexBinary\nint\nstring\ntime\n");
    }

    public ExtensionsSchemasRegistry getExtensionsSchemasRegistry() {
        if (this.registry == null) {
            this.registry = new ExtensionsSchemasRegistry(EXTENSIONS_SCHEMAS_EXTENSIONID);
            this.registry.__internalSetDeprecatedExtensionId(DEPRECATED_EXTENSIONS_SCHEMAS_EXTENSIONID);
            this.registry.setPrefStore(XSDEditorPlugin.getPlugin().getPreferenceStore());
        }
        return this.registry;
    }

    public XSDEditorConfiguration getXSDEditorConfiguration() {
        if (this.xsdEditorConfiguration == null) {
            this.xsdEditorConfiguration = new XSDEditorConfiguration();
        }
        return this.xsdEditorConfiguration;
    }

    public String getXMLSchemaPrefix() {
        return this.getPreferenceStore().getString(CONST_XSD_DEFAULT_PREFIX_TEXT);
    }

    public boolean getShowExternals() {
        return this.getPreferenceStore().getBoolean(CONST_SHOW_EXTERNALS);
    }

    public void setShowExternals(boolean doShow) {
        this.getPreferenceStore().setValue(CONST_SHOW_EXTERNALS, doShow);
    }

    public String getXMLSchemaTargetNamespace() {
        String targetNamespace = this.getPreferenceStore().getString(CONST_DEFAULT_TARGET_NAMESPACE);
        if (!targetNamespace.endsWith("/")) {
            targetNamespace = String.valueOf(targetNamespace) + "/";
        }
        return targetNamespace;
    }

    public boolean isQualifyXMLSchemaLanguage() {
        return this.getPreferenceStore().getBoolean(CONST_XSD_LANGUAGE_QUALIFY);
    }

    public static Shell getShell() {
        return XSDEditorPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void setSourcePageAsDefault() {
        this.getPreferenceStore().setValue(DEFAULT_PAGE, SOURCE_PAGE);
    }

    public void setDesignPageAsDefault() {
        this.getPreferenceStore().setValue(DEFAULT_PAGE, DESIGN_PAGE);
    }

    public String getDefaultPage() {
        return this.getPreferenceStore().getString(DEFAULT_PAGE);
    }

    public NodeCustomizationRegistry getNodeCustomizationRegistry() {
        if (this.nodeCustomizationRegistry == null) {
            this.nodeCustomizationRegistry = new NodeCustomizationRegistry("foo");
        }
        return this.nodeCustomizationRegistry;
    }

    public ProductCustomizationProvider getProductCustomizationProvider() {
        if (!productCustomizationProviderInitialized) {
            productCustomizationProviderInitialized = true;
            String pluginName = this.getPreferenceStore().getString(PRODUCT_CUSTOMIZATION_PROVIDER_PLUGIN_ID);
            String className = this.getPreferenceStore().getString(PRODUCT_CUSTOMIZATION_PROVIDER_CLASS_NAME);
            if (pluginName != null && pluginName.length() > 0 && className != null && className.length() > 0) {
                try {
                    Bundle bundle = Platform.getBundle((String)pluginName);
                    Class clazz = bundle.loadClass(className);
                    productCustomizationProvider = (ProductCustomizationProvider)clazz.newInstance();
                }
                catch (Exception exception) {}
            }
        }
        return productCustomizationProvider;
    }
}

