/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.core.resource.java.IdAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaIdMapping
extends AbstractJavaAttributeMapping<IdAnnotation>
implements JavaIdMapping {
    protected final JavaColumn column = this.createJavaColumn();
    protected JavaGeneratedValue generatedValue;
    protected TemporalType temporal;
    protected JavaTableGenerator tableGenerator;
    protected JavaSequenceGenerator sequenceGenerator;

    public GenericJavaIdMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaColumn createJavaColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.initializeFromResource(resourcePersistentAttribute);
        this.column.initializeFromResource(this.getColumnResource());
        this.temporal = this.temporal(this.getTemporalResource());
        this.initializeTableGenerator(resourcePersistentAttribute);
        this.initializeSequenceGenerator(resourcePersistentAttribute);
        this.initializeGeneratedValue(resourcePersistentAttribute);
        this.updatePersistenceUnitGenerators();
    }

    protected void initializeTableGenerator(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        TableGeneratorAnnotation tableGeneratorResource = this.tableGenerator(resourcePersistentAttribute);
        if (tableGeneratorResource != null) {
            this.tableGenerator = this.getJpaFactory().buildJavaTableGenerator(this);
            this.tableGenerator.initializeFromResource(tableGeneratorResource);
        }
    }

    protected void initializeSequenceGenerator(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.sequenceGenerator(resourcePersistentAttribute);
        if (sequenceGeneratorResource != null) {
            this.sequenceGenerator = this.getJpaFactory().buildJavaSequenceGenerator(this);
            this.sequenceGenerator.initializeFromResource(sequenceGeneratorResource);
        }
    }

    protected void initializeGeneratedValue(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        GeneratedValueAnnotation generatedValueResource = this.generatedValue(resourcePersistentAttribute);
        if (generatedValueResource != null) {
            this.generatedValue = this.getJpaFactory().buildJavaGeneratedValue(this);
            this.generatedValue.initializeFromResource(generatedValueResource);
        }
    }

    protected TemporalAnnotation getTemporalResource() {
        return (TemporalAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Temporal");
    }

    @Override
    public ColumnAnnotation getColumnResource() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Id";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.GeneratedValue", "javax.persistence.Temporal", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getTableName();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.getTemporalResource().setValue(TemporalType.toJavaResourceModel(newTemporal));
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    protected void setTemporal_(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    @Override
    public JavaGeneratedValue addGeneratedValue() {
        if (this.getGeneratedValue() != null) {
            throw new IllegalStateException("gemeratedValue already exists");
        }
        this.generatedValue = this.getJpaFactory().buildJavaGeneratedValue(this);
        GeneratedValueAnnotation generatedValueResource = (GeneratedValueAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.GeneratedValue");
        this.generatedValue.initializeFromResource(generatedValueResource);
        this.firePropertyChanged("generatedValueProperty", null, this.generatedValue);
        return this.generatedValue;
    }

    @Override
    public void removeGeneratedValue() {
        if (this.getGeneratedValue() == null) {
            throw new IllegalStateException("gemeratedValue does not exist, cannot be removed");
        }
        JavaGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = null;
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.GeneratedValue");
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, null);
    }

    @Override
    public JavaGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    protected void setGeneratedValue(JavaGeneratedValue newGeneratedValue) {
        JavaGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = newGeneratedValue;
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, newGeneratedValue);
    }

    @Override
    public JavaTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        this.tableGenerator = this.getJpaFactory().buildJavaTableGenerator(this);
        TableGeneratorAnnotation tableGeneratorResource = (TableGeneratorAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.TableGenerator");
        this.tableGenerator.initializeFromResource(tableGeneratorResource);
        this.firePropertyChanged("tableGeneratorProperty", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.TableGenerator");
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, null);
    }

    @Override
    public JavaTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(JavaTableGenerator newTableGenerator) {
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, newTableGenerator);
    }

    @Override
    public JavaSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        this.sequenceGenerator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        SequenceGeneratorAnnotation sequenceGeneratorResource = (SequenceGeneratorAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.SequenceGenerator");
        this.sequenceGenerator.initializeFromResource(sequenceGeneratorResource);
        this.firePropertyChanged("sequenceGeneratorProperty", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.SequenceGenerator");
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, null);
    }

    @Override
    public JavaSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(JavaSequenceGenerator newSequenceGenerator) {
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, newSequenceGenerator);
    }

    protected Iterator<JavaGenerator> generators() {
        return new CompositeIterator(new Iterator[]{this.getSequenceGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getSequenceGenerator()), this.getTableGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getTableGenerator())});
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.update(resourcePersistentAttribute);
        this.column.update(this.getColumnResource());
        this.setTemporal_(this.temporal(this.getTemporalResource()));
        this.updateTableGenerator(resourcePersistentAttribute);
        this.updateSequenceGenerator(resourcePersistentAttribute);
        this.updateGeneratedValue(resourcePersistentAttribute);
        this.updatePersistenceUnitGenerators();
    }

    protected TemporalType temporal(TemporalAnnotation temporal) {
        return TemporalType.fromJavaResourceModel(temporal.getValue());
    }

    protected void updateTableGenerator(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        TableGeneratorAnnotation tableGeneratorResource = this.tableGenerator(resourcePersistentAttribute);
        if (tableGeneratorResource == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.getJpaFactory().buildJavaTableGenerator(this));
            this.getTableGenerator().initializeFromResource(tableGeneratorResource);
        } else {
            this.getTableGenerator().update(tableGeneratorResource);
        }
    }

    protected void updateSequenceGenerator(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.sequenceGenerator(resourcePersistentAttribute);
        if (sequenceGeneratorResource == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.getJpaFactory().buildJavaSequenceGenerator(this));
            this.getSequenceGenerator().initializeFromResource(sequenceGeneratorResource);
        } else {
            this.getSequenceGenerator().update(sequenceGeneratorResource);
        }
    }

    protected void updateGeneratedValue(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        GeneratedValueAnnotation generatedValueResource = this.generatedValue(resourcePersistentAttribute);
        if (generatedValueResource == null) {
            if (this.getGeneratedValue() != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.getGeneratedValue() == null) {
            this.setGeneratedValue(this.getJpaFactory().buildJavaGeneratedValue(this));
            this.getGeneratedValue().initializeFromResource(generatedValueResource);
        } else {
            this.getGeneratedValue().update(generatedValueResource);
        }
    }

    protected TableGeneratorAnnotation tableGenerator(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        return (TableGeneratorAnnotation)resourcePersistentAttribute.getAnnotation("javax.persistence.TableGenerator");
    }

    protected SequenceGeneratorAnnotation sequenceGenerator(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        return (SequenceGeneratorAnnotation)resourcePersistentAttribute.getAnnotation("javax.persistence.SequenceGenerator");
    }

    protected GeneratedValueAnnotation generatedValue(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        return (GeneratedValueAnnotation)resourcePersistentAttribute.getAnnotation("javax.persistence.GeneratedValue");
    }

    protected void updatePersistenceUnitGenerators() {
        if (this.getTableGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getTableGenerator());
        }
        if (this.getSequenceGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getSequenceGenerator());
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getColumn().getName();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public boolean isIdMapping() {
        return true;
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        this.addColumnMessages(messages, astRoot);
        this.addGeneratedValueMessages(messages, astRoot);
        this.addGeneratorMessages(messages, astRoot);
    }

    protected void addColumnMessages(List<IMessage> messages, CompilationUnit astRoot) {
        boolean doContinue;
        JavaColumn column = this.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && column.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.getTableTextRange(astRoot)));
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.getNameTextRange(astRoot)));
        }
    }

    protected void addGeneratedValueMessages(List<IMessage> messages, CompilationUnit astRoot) {
        JavaGeneratedValue generatedValue = this.getGeneratedValue();
        if (generatedValue == null) {
            return;
        }
        String generatorName = generatedValue.getGenerator();
        if (generatorName == null) {
            return;
        }
        for (Generator nextMasterGenerator : CollectionTools.iterable(this.getPersistenceUnit().allGenerators())) {
            if (!generatorName.equals(nextMasterGenerator.getName())) continue;
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME", new String[]{generatorName}, this, generatedValue.getGeneratorTextRange(astRoot)));
    }

    protected void addGeneratorMessages(List<IMessage> messages, CompilationUnit astRoot) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allGenerators());
        Iterator<JavaGenerator> stream = this.generators();
        while (stream.hasNext()) {
            JavaGenerator current = stream.next();
            masterList.remove(current);
            for (Generator each : masterList) {
                if (each.overrides(current) || each.getName() == null || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange(astRoot)));
            }
            masterList.add(current);
        }
    }
}

