/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaOneToOneMapping
extends AbstractJavaSingleRelationshipMapping<OneToOneAnnotation>
implements JavaOneToOneMapping {
    protected String mappedBy;
    protected final List<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns = new ArrayList<JavaPrimaryKeyJoinColumn>();

    public GenericJavaOneToOneMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns", "javax.persistence.JoinColumn", "javax.persistence.JoinColumns", "javax.persistence.JoinTable"});
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OneToOne";
    }

    @Override
    public String getKey() {
        return "oneToOne";
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return new CloneListIterator(this.primaryKeyJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.primaryKeyJoinColumns.size();
    }

    @Override
    public JavaPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createJoinColumnOwner());
        this.primaryKeyJoinColumns.add(index, pkJoinColumn);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)this.getResourcePersistentAttribute().addAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.initializeFromResource(pkJoinColumnResource);
        this.fireItemAdded("primaryKeyJoinColumnsList", index, pkJoinColumn);
        return pkJoinColumn;
    }

    protected void addPrimaryKeyJoinColumn(int index, JavaPrimaryKeyJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    @Override
    public void removePrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removePrimaryKeyJoinColumn(this.primaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn removedPkJoinColumn = this.primaryKeyJoinColumns.remove(index);
        this.getResourcePersistentAttribute().removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.fireItemRemoved("primaryKeyJoinColumnsList", index, removedPkJoinColumn);
    }

    protected void removePrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    @Override
    public void movePrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.primaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourcePersistentAttribute().move(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumns");
        this.fireItemMoved("primaryKeyJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public boolean containsPrimaryKeyJoinColumns() {
        return !this.primaryKeyJoinColumns.isEmpty();
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        ((OneToOneAnnotation)this.getMappingResource()).setMappedBy(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    protected void setMappedBy_(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    @Override
    public boolean mappedByIsValid(AttributeMapping mappedByMapping) {
        String mappedByKey = mappedByMapping.getKey();
        return mappedByKey == "oneToOne";
    }

    @Override
    protected void setOptionalOnResourceModel(Boolean newOptional) {
        ((OneToOneAnnotation)this.getMappingResource()).setOptional(newOptional);
    }

    public TextRange getMappedByTextRange(CompilationUnit astRoot) {
        return ((OneToOneAnnotation)this.getMappingResource()).getMappedByTextRange(astRoot);
    }

    public boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return ((OneToOneAnnotation)this.getMappingResource()).mappedByTouches(pos, astRoot);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mappedByTouches(pos, astRoot)) {
            return this.quotedCandidateMappedByAttributeNames(filter);
        }
        return null;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return true;
    }

    @Override
    protected void initialize(OneToOneAnnotation oneToOneResource) {
        super.initialize(oneToOneResource);
        this.mappedBy = oneToOneResource.getMappedBy();
    }

    @Override
    protected Boolean specifiedOptional(OneToOneAnnotation oneToOneResource) {
        return oneToOneResource.getOptional();
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.initializeFromResource(resourcePersistentAttribute);
        this.initializePrimaryKeyJoinColumns(resourcePersistentAttribute);
    }

    protected void initializePrimaryKeyJoinColumns(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        ListIterator annotations = resourcePersistentAttribute.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (annotations.hasNext()) {
            this.primaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)annotations.next()));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnResource) {
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createJoinColumnOwner());
        pkJoinColumn.initializeFromResource(primaryKeyJoinColumnResource);
        return pkJoinColumn;
    }

    @Override
    protected void update(OneToOneAnnotation oneToOneResource) {
        super.update(oneToOneResource);
        this.setMappedBy_(oneToOneResource.getMappedBy());
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.update(resourcePersistentAttribute);
        this.updatePrimaryKeyJoinColumns(resourcePersistentAttribute);
    }

    protected void updatePrimaryKeyJoinColumns(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        ListIterator<JavaPrimaryKeyJoinColumn> pkJoinColumns = this.primaryKeyJoinColumns();
        ListIterator resourcePkJoinColumns = resourcePersistentAttribute.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (pkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn pkJoinColumn = pkJoinColumns.next();
            if (resourcePkJoinColumns.hasNext()) {
                pkJoinColumn.update((PrimaryKeyJoinColumnAnnotation)resourcePkJoinColumns.next());
                continue;
            }
            this.removePrimaryKeyJoinColumn_(pkJoinColumn);
        }
        while (resourcePkJoinColumns.hasNext()) {
            this.addPrimaryKeyJoinColumn(this.specifiedJoinColumnsSize(), this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)resourcePkJoinColumns.next()));
        }
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        if (this.getMappedBy() != null) {
            this.addMappedByMessages(messages, astRoot);
        }
    }

    @Override
    protected boolean addJoinColumnMessages() {
        if (this.containsPrimaryKeyJoinColumns() && !this.containsSpecifiedJoinColumns()) {
            return false;
        }
        return super.addJoinColumnMessages();
    }

    protected void addMappedByMessages(List<IMessage> messages, CompilationUnit astRoot) {
        NonOwningMapping mappedByMapping;
        String mappedBy = this.getMappedBy();
        Entity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        if (!this.mappedByIsValid(attribute.getMapping())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        try {
            mappedByMapping = (NonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange(astRoot)));
        }
    }
}

