/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBaseTable;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraintImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTable
extends AbstractOrmJpaContextNode
implements UniqueConstraint.Owner {
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected final List<OrmUniqueConstraint> uniqueConstraints = new ArrayList<OrmUniqueConstraint>();

    protected AbstractOrmTable(OrmJpaContextNode parent) {
        super(parent);
    }

    @Override
    public OrmJpaContextNode getParent() {
        return (OrmJpaContextNode)super.getParent();
    }

    public void initializeFrom(Table oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
    }

    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    public String getSpecifiedName() {
        return this.specifiedName;
    }

    protected abstract XmlBaseTable getTableResource();

    protected abstract void removeTableResource();

    protected abstract void addTableResource();

    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (oldSpecifiedName != newSpecifiedName) {
            if (this.getTableResource() != null) {
                this.getTableResource().setName(newSpecifiedName);
                if (this.getTableResource().isAllFeaturesUnset()) {
                    this.removeTableResource();
                }
            } else if (newSpecifiedName != null) {
                this.addTableResource();
                this.getTableResource().setName(newSpecifiedName);
            }
        }
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultNameProperty", oldDefaultName, newDefaultName);
    }

    public String getCatalog() {
        return this.getSpecifiedCatalog() == null ? this.getDefaultCatalog() : this.getSpecifiedCatalog();
    }

    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    public void setSpecifiedCatalog(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        if (oldSpecifiedCatalog != newSpecifiedCatalog) {
            if (this.getTableResource() != null) {
                this.getTableResource().setCatalog(newSpecifiedCatalog);
                if (this.getTableResource().isAllFeaturesUnset()) {
                    this.removeTableResource();
                }
            } else if (newSpecifiedCatalog != null) {
                this.addTableResource();
                this.getTableResource().setCatalog(newSpecifiedCatalog);
            }
        }
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    protected void setSpecifiedCatalog_(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalogProperty", oldDefaultCatalog, newDefaultCatalog);
    }

    public String getSchema() {
        return this.getSpecifiedSchema() == null ? this.getDefaultSchema() : this.getSpecifiedSchema();
    }

    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    public void setSpecifiedSchema(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        if (oldSpecifiedSchema != newSpecifiedSchema) {
            if (this.getTableResource() != null) {
                this.getTableResource().setSchema(newSpecifiedSchema);
                if (this.getTableResource().isAllFeaturesUnset()) {
                    this.removeTableResource();
                }
            } else if (newSpecifiedSchema != null) {
                this.addTableResource();
                this.getTableResource().setSchema(newSpecifiedSchema);
            }
        }
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    protected void setSpecifiedSchema_(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.firePropertyChanged("defaultSchemaProperty", oldDefaultSchema, newDefaultSchema);
    }

    public ListIterator<OrmUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    public OrmUniqueConstraint addUniqueConstraint(int index) {
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        OrmUniqueConstraint uniqueConstraint = this.buildUniqueConstraint(uniqueConstraintResource);
        this.uniqueConstraints.add(index, uniqueConstraint);
        if (this.getTableResource() == null) {
            this.addTableResource();
        }
        this.getTableResource().getUniqueConstraints().add(index, (Object)uniqueConstraintResource);
        this.fireItemAdded("uniqueConstraintsList", index, uniqueConstraint);
        return uniqueConstraint;
    }

    protected void addUniqueConstraint(int index, OrmUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    public void removeUniqueConstraint(int index) {
        OrmUniqueConstraint removedUniqueConstraint = this.uniqueConstraints.remove(index);
        this.getTableResource().getUniqueConstraints().remove(index);
        this.fireItemRemoved("uniqueConstraintsList", index, removedUniqueConstraint);
    }

    protected void removeUniqueConstraint_(OrmUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        this.getTableResource().getUniqueConstraints().move(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraintsList", targetIndex, sourceIndex);
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        org.eclipse.jpt.db.Table dbTable = this.getDbTable();
        if (dbTable != null) {
            return dbTable.columnNames();
        }
        return EmptyIterator.instance();
    }

    public org.eclipse.jpt.db.Table getDbTable() {
        Schema schema = this.getDbSchema();
        return schema == null ? null : schema.tableNamed(this.getName());
    }

    public Schema getDbSchema() {
        return this.getConnectionProfile().getDatabase().schemaNamed(this.getSchema());
    }

    public boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    protected void initialize(XmlBaseTable table) {
        this.specifiedName = this.specifiedName(table);
        this.specifiedSchema = this.specifiedSchema(table);
        this.specifiedCatalog = this.specifiedCatalog(table);
        this.defaultName = this.defaultName();
        this.defaultSchema = this.defaultSchema();
        this.defaultCatalog = this.defaultCatalog();
        this.initializeUniqueContraints(table);
    }

    protected void initializeUniqueContraints(XmlBaseTable table) {
        if (table == null) {
            return;
        }
        for (XmlUniqueConstraint uniqueConstraint : table.getUniqueConstraints()) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(uniqueConstraint));
        }
    }

    protected void update(XmlBaseTable table) {
        this.setSpecifiedName_(this.specifiedName(table));
        this.setSpecifiedSchema_(this.specifiedSchema(table));
        this.setSpecifiedCatalog_(this.specifiedCatalog(table));
        this.setDefaultName(this.defaultName());
        this.setDefaultSchema(this.defaultSchema());
        this.setDefaultCatalog(this.defaultCatalog());
        this.updateUniqueConstraints(table);
    }

    protected String specifiedName(XmlBaseTable table) {
        return table == null ? null : table.getName();
    }

    protected String specifiedSchema(XmlBaseTable table) {
        return table == null ? null : table.getSchema();
    }

    protected String specifiedCatalog(XmlBaseTable table) {
        return table == null ? null : table.getCatalog();
    }

    protected abstract String defaultName();

    protected abstract String defaultSchema();

    protected abstract String defaultCatalog();

    protected void updateUniqueConstraints(XmlBaseTable table) {
        ListIterator<OrmUniqueConstraint> uniqueConstraints = this.uniqueConstraints();
        ListIterator resourceUniqueConstraints = table == null ? EmptyListIterator.instance() : new CloneListIterator(table.getUniqueConstraints());
        while (uniqueConstraints.hasNext()) {
            OrmUniqueConstraint uniqueConstraint = uniqueConstraints.next();
            if (resourceUniqueConstraints.hasNext()) {
                uniqueConstraint.update((XmlUniqueConstraint)resourceUniqueConstraints.next());
                continue;
            }
            this.removeUniqueConstraint_(uniqueConstraint);
        }
        while (resourceUniqueConstraints.hasNext()) {
            this.addUniqueConstraint(this.uniqueConstraintsSize(), this.buildUniqueConstraint((XmlUniqueConstraint)resourceUniqueConstraints.next()));
        }
    }

    protected OrmUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint xmlUniqueConstraint) {
        return this.getJpaFactory().buildOrmUniqueConstraint(this, this, xmlUniqueConstraint);
    }

    public String qualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    protected TextRange getNameTextRange() {
        TextRange textRange;
        if (this.getTableResource() != null && (textRange = this.getTableResource().getNameTextRange()) != null) {
            return textRange;
        }
        return this.getParent().getValidationTextRange();
    }

    protected TextRange getCatalogTextRange() {
        TextRange textRange;
        if (this.getTableResource() != null && (textRange = this.getTableResource().getCatalogTextRange()) != null) {
            return textRange;
        }
        return this.getParent().getValidationTextRange();
    }

    protected TextRange getSchemaTextRange() {
        TextRange textRange;
        if (this.getTableResource() != null && (textRange = this.getTableResource().getSchemaTextRange()) != null) {
            return textRange;
        }
        return this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange;
        if (this.getTableResource() != null && (textRange = this.getTableResource().getValidationTextRange()) != null) {
            return textRange;
        }
        return this.getParent().getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.qualifiedName());
    }

    @Override
    public String displayString() {
        return this.qualifiedName();
    }
}

