/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.XmlOneToOneImpl;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmOneToOneMapping
extends AbstractOrmSingleRelationshipMapping<XmlOneToOne>
implements OrmOneToOneMapping {
    protected String mappedBy;
    protected final List<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();

    public GenericOrmOneToOneMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmOneToOneMapping(this);
    }

    @Override
    public void initializeFromXmlNonOwningMapping(NonOwningMapping oldMapping) {
        super.initializeFromXmlNonOwningMapping(oldMapping);
        this.setMappedBy(oldMapping.getMappedBy());
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return new CloneListIterator(this.primaryKeyJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.primaryKeyJoinColumns.size();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn pkJoinColumn = this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, new AbstractOrmSingleRelationshipMapping.JoinColumnOwner());
        XmlPrimaryKeyJoinColumnImpl xmlPkJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumnImpl();
        this.primaryKeyJoinColumns.add(index, pkJoinColumn);
        ((XmlOneToOne)this.getAttributeMapping()).getPrimaryKeyJoinColumns().add(index, (Object)xmlPkJoinColumn);
        pkJoinColumn.initialize(xmlPkJoinColumn);
        this.fireItemAdded("primaryKeyJoinColumnsList", index, pkJoinColumn);
        return pkJoinColumn;
    }

    protected void addPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    @Override
    public void removePrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removePrimaryKeyJoinColumn(this.primaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPkJoinColumn = this.primaryKeyJoinColumns.remove(index);
        ((XmlOneToOne)this.getAttributeMapping()).getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("primaryKeyJoinColumnsList", index, removedPkJoinColumn);
    }

    protected void removePrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    @Override
    public void movePrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.primaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlOneToOne)this.getAttributeMapping()).getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("primaryKeyJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public boolean containsPrimaryKeyJoinColumns() {
        return !this.primaryKeyJoinColumns.isEmpty();
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        ((XmlOneToOne)this.getAttributeMapping()).setMappedBy(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    protected void setMappedBy_(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    @Override
    public boolean mappedByIsValid(AttributeMapping mappedByMapping) {
        String mappedByKey = mappedByMapping.getKey();
        return mappedByKey == "oneToOne";
    }

    public TextRange getMappedByTextRange() {
        TextRange mappedByTextRange = ((XmlOneToOne)this.getAttributeMapping()).getMappedByTextRange();
        return mappedByTextRange != null ? mappedByTextRange : this.getValidationTextRange();
    }

    @Override
    public int getXmlSequence() {
        return 6;
    }

    @Override
    public String getKey() {
        return "oneToOne";
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return true;
    }

    @Override
    public XmlOneToOne addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlOneToOneImpl oneToOne = OrmFactory.eINSTANCE.createXmlOneToOneImpl();
        this.getPersistentAttribute().initialize(oneToOne);
        typeMapping.getAttributes().getOneToOnes().add((Object)oneToOne);
        return oneToOne;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getOneToOnes().remove(this.getAttributeMapping());
        if (typeMapping.getAttributes().isAllFeaturesUnset()) {
            typeMapping.setAttributes(null);
        }
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.getMappedBy() != null) {
            this.addMappedByMessages(messages);
        }
    }

    @Override
    protected boolean addJoinColumnMessages() {
        if (this.containsPrimaryKeyJoinColumns() && !this.containsSpecifiedJoinColumns()) {
            return false;
        }
        return super.addJoinColumnMessages();
    }

    protected void addMappedByMessages(List<IMessage> messages) {
        NonOwningMapping mappedByMapping;
        String mappedBy = this.getMappedBy();
        Entity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange()));
            return;
        }
        if (!this.mappedByIsValid(attribute.getMapping())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange()));
            return;
        }
        try {
            mappedByMapping = (NonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange()));
        }
    }

    @Override
    public void initialize(XmlOneToOne oneToOne) {
        super.initialize(oneToOne);
        this.mappedBy = oneToOne.getMappedBy();
        this.initializePrimaryKeyJoinColumns(oneToOne);
    }

    protected void initializePrimaryKeyJoinColumns(XmlOneToOne oneToOne) {
        if (oneToOne == null) {
            return;
        }
        for (XmlPrimaryKeyJoinColumn pkJoinColumn : oneToOne.getPrimaryKeyJoinColumns()) {
            this.primaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(pkJoinColumn));
        }
    }

    protected OrmPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn xmlPkJoinColumn) {
        OrmPrimaryKeyJoinColumn ormPkJoinColumn = this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, new AbstractOrmSingleRelationshipMapping.JoinColumnOwner());
        ormPkJoinColumn.initialize(xmlPkJoinColumn);
        return ormPkJoinColumn;
    }

    @Override
    public void update(XmlOneToOne oneToOne) {
        super.update(oneToOne);
        this.setMappedBy_(oneToOne.getMappedBy());
        this.updatePrimaryKeyJoinColumns(oneToOne);
    }

    protected void updatePrimaryKeyJoinColumns(XmlOneToOne oneToOne) {
        ListIterator<OrmPrimaryKeyJoinColumn> pkJoinColumns = this.primaryKeyJoinColumns();
        ListIterator resourcePkJoinColumns = EmptyListIterator.instance();
        if (oneToOne != null) {
            resourcePkJoinColumns = new CloneListIterator(oneToOne.getPrimaryKeyJoinColumns());
        }
        while (pkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn pkJoinColumn = pkJoinColumns.next();
            if (resourcePkJoinColumns.hasNext()) {
                pkJoinColumn.update((XmlPrimaryKeyJoinColumn)resourcePkJoinColumns.next());
                continue;
            }
            this.removePrimaryKeyJoinColumn_(pkJoinColumn);
        }
        while (resourcePkJoinColumns.hasNext()) {
            this.addPrimaryKeyJoinColumn(this.primaryKeyJoinColumnsSize(), this.buildPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)resourcePkJoinColumns.next()));
        }
    }
}

