/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmBaseJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmSecondaryTable
extends AbstractOrmTable
implements OrmSecondaryTable {
    protected XmlSecondaryTable secondaryTable;
    protected final List<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
    protected OrmPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;

    public GenericOrmSecondaryTable(OrmEntity parent, XmlSecondaryTable xmlSecondaryTable) {
        super(parent);
        this.initialize(xmlSecondaryTable);
    }

    @Override
    public void initializeFrom(SecondaryTable oldSecondaryTable) {
        super.initializeFrom(oldSecondaryTable);
        for (PrimaryKeyJoinColumn oldPkJoinColumn : CollectionTools.iterable((Iterator)oldSecondaryTable.specifiedPrimaryKeyJoinColumns())) {
            OrmPrimaryKeyJoinColumn newPkJoinColumn = this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnsSize());
            newPkJoinColumn.initializeFrom(oldPkJoinColumn);
        }
    }

    @Override
    public OrmEntity getParent() {
        return (OrmEntity)super.getParent();
    }

    public OrmEntity getOrmEntity() {
        return this.getParent();
    }

    @Override
    public OrmPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn newPkJoinColumn) {
        OrmPrimaryKeyJoinColumn oldPkJoinColumn = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = newPkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldPkJoinColumn, newPkJoinColumn);
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumns() : this.defaultPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumnsSize() : this.defaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    protected ListIterator<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultPrimaryKeyJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn oldDefaultPkJoinColumn = this.getDefaultPrimaryKeyJoinColumn();
        if (oldDefaultPkJoinColumn != null) {
            this.defaultPrimaryKeyJoinColumn = null;
        }
        XmlPrimaryKeyJoinColumnImpl xmlPrimaryKeyJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumnImpl();
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn = this.createPrimaryKeyJoinColumn(xmlPrimaryKeyJoinColumn);
        this.specifiedPrimaryKeyJoinColumns.add(index, primaryKeyJoinColumn);
        this.secondaryTable.getPrimaryKeyJoinColumns().add(index, (Object)xmlPrimaryKeyJoinColumn);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumnsList", index, primaryKeyJoinColumn);
        if (oldDefaultPkJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldDefaultPkJoinColumn, null);
        }
        return primaryKeyJoinColumn;
    }

    protected OrmBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.defaultPrimaryKeyJoinColumn = this.createPrimaryKeyJoinColumn(null);
        }
        this.secondaryTable.getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumnsList", index, removedPrimaryKeyJoinColumn);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", null, this.defaultPrimaryKeyJoinColumn);
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedPrimaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.secondaryTable.getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedPrimaryKeyJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public boolean isVirtual() {
        return this.getOrmEntity().containsVirtualSecondaryTable(this);
    }

    @Override
    protected void addTableResource() {
    }

    @Override
    protected void removeTableResource() {
    }

    @Override
    protected XmlSecondaryTable getTableResource() {
        return this.secondaryTable;
    }

    protected void initialize(XmlSecondaryTable secondaryTable) {
        this.secondaryTable = secondaryTable;
        super.initialize(secondaryTable);
        this.initializeSpecifiedPrimaryKeyJoinColumns(secondaryTable);
        this.initializeDefaultPrimaryKeyJoinColumn();
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns(XmlSecondaryTable secondaryTable) {
        for (XmlPrimaryKeyJoinColumn primaryKeyJoinColumn : secondaryTable.getPrimaryKeyJoinColumns()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.createPrimaryKeyJoinColumn(primaryKeyJoinColumn));
        }
    }

    protected boolean shouldBuildDefaultPrimaryKeyJoinColumn() {
        return !this.containsSpecifiedPrimaryKeyJoinColumns();
    }

    protected void initializeDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            return;
        }
        this.defaultPrimaryKeyJoinColumn = this.createPrimaryKeyJoinColumn(null);
    }

    @Override
    public void update(XmlSecondaryTable secondaryTable) {
        this.secondaryTable = secondaryTable;
        super.update(secondaryTable);
        this.updateSpecifiedPrimaryKeyJoinColumns(secondaryTable);
        this.updateDefaultPrimaryKeyJoinColumn();
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns(XmlSecondaryTable secondaryTable) {
        ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        CloneListIterator resourcePrimaryKeyJoinColumns = new CloneListIterator(secondaryTable.getPrimaryKeyJoinColumns());
        while (primaryKeyJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns.next();
            if (resourcePrimaryKeyJoinColumns.hasNext()) {
                primaryKeyJoinColumn.update((XmlPrimaryKeyJoinColumn)resourcePrimaryKeyJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(primaryKeyJoinColumn);
        }
        while (resourcePrimaryKeyJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnsSize(), this.createPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)resourcePrimaryKeyJoinColumns.next()));
        }
    }

    protected void updateDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            this.setDefaultPrimaryKeyJoinColumn(null);
            return;
        }
        if (this.getDefaultPrimaryKeyJoinColumn() == null) {
            this.setDefaultPrimaryKeyJoinColumn(this.createPrimaryKeyJoinColumn(null));
        } else {
            this.defaultPrimaryKeyJoinColumn.update(null);
        }
    }

    protected OrmPrimaryKeyJoinColumn createPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn xmlPrimaryKeyJoinColumn) {
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        ormPrimaryKeyJoinColumn.initialize(xmlPrimaryKeyJoinColumn);
        return ormPrimaryKeyJoinColumn;
    }

    @Override
    protected String defaultName() {
        return null;
    }

    @Override
    protected String defaultCatalog() {
        return this.getEntityMappings().getCatalog();
    }

    @Override
    protected String defaultSchema() {
        return this.getEntityMappings().getSchema();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addTableMessages(messages);
        for (OrmPrimaryKeyJoinColumn pkJoinColumn : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            pkJoinColumn.addToMessages(messages);
        }
    }

    protected void addTableMessages(List<IMessage> messages) {
        boolean doContinue = this.connectionProfileIsActive();
        String schema = this.getSchema();
        if (doContinue && !this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.getName()}, this, this.getSchemaTextRange()));
            doContinue = false;
        }
        if (doContinue && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange()));
        }
    }

    class PrimaryKeyJoinColumnOwner
    implements OrmBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmSecondaryTable.this.getOrmEntity();
        }

        public Table getDbTable(String tableName) {
            return GenericOrmSecondaryTable.this.getDbTable();
        }

        public Table getDbReferencedColumnTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return GenericOrmSecondaryTable.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmSecondaryTable.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return GenericOrmSecondaryTable.this.getOrmEntity().getParentEntity().getPrimaryKeyColumnName();
        }

        public TextRange getValidationTextRange() {
            return null;
        }
    }
}

