/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmTable;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlTable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmTable
extends AbstractOrmTable
implements OrmTable {
    protected XmlEntity entity;

    public GenericOrmTable(OrmEntity parent) {
        super(parent);
    }

    public OrmEntity getOrmEntity() {
        return (OrmEntity)super.getParent();
    }

    @Override
    protected XmlTable getTableResource() {
        return this.entity.getTable();
    }

    @Override
    protected void removeTableResource() {
        this.entity.setTable(null);
    }

    @Override
    protected void addTableResource() {
        this.entity.setTable(OrmFactory.eINSTANCE.createXmlTable());
    }

    protected JavaTable getJavaTable() {
        JavaEntity javaEntity = this.getOrmEntity().getJavaEntity();
        if (javaEntity != null) {
            return javaEntity.getTable();
        }
        return null;
    }

    @Override
    public void initialize(XmlEntity entity) {
        this.entity = entity;
        this.initialize(this.getTableResource());
    }

    @Override
    public void update(XmlEntity entity) {
        this.entity = entity;
        this.update(this.getTableResource());
    }

    @Override
    protected String defaultName() {
        JavaTable javaTable = this.getJavaTable();
        if (javaTable != null && !this.getOrmEntity().isMetadataComplete() && this.getTableResource() == null && javaTable.getSpecifiedName() != null) {
            return javaTable.getSpecifiedName();
        }
        Entity rootEntity = this.getOrmEntity().getRootEntity();
        if (rootEntity != this.getOrmEntity() && rootEntity.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE) {
            return rootEntity.getTable().getName();
        }
        return this.getOrmEntity().getName();
    }

    @Override
    protected String defaultSchema() {
        JavaTable javaTable = this.getJavaTable();
        if (javaTable != null) {
            if (this.getOrmEntity().isMetadataComplete() || this.getTableResource() != null) {
                return javaTable.getDefaultSchema();
            }
            return javaTable.getSchema();
        }
        Entity rootEntity = this.getOrmEntity().getRootEntity();
        if (rootEntity != this.getOrmEntity() && rootEntity.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE) {
            return rootEntity.getTable().getSchema();
        }
        return this.getEntityMappings().getSchema();
    }

    @Override
    protected String defaultCatalog() {
        JavaTable javaTable = this.getJavaTable();
        if (javaTable != null) {
            if (this.getOrmEntity().isMetadataComplete() || this.getTableResource() != null) {
                return javaTable.getDefaultCatalog();
            }
            return javaTable.getCatalog();
        }
        Entity rootEntity = this.getOrmEntity().getRootEntity();
        if (rootEntity != this.getOrmEntity() && rootEntity.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE) {
            return rootEntity.getTable().getCatalog();
        }
        return this.getEntityMappings().getCatalog();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        boolean doContinue = this.connectionProfileIsActive();
        String schema = this.getSchema();
        if (doContinue && !this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.getName()}, this, this.getSchemaTextRange()));
            doContinue = false;
        }
        if (doContinue && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange()));
        }
    }
}

