/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.resource.common.AbstractJpaEObject;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.utility.TextRange;

public class VirtualXmlColumn
extends AbstractJpaEObject
implements XmlColumn {
    protected Column column;
    protected boolean metadataComplete;
    protected OrmTypeMapping ormTypeMapping;

    protected VirtualXmlColumn(OrmTypeMapping ormTypeMapping, Column column, boolean metadataComplete) {
        this.ormTypeMapping = ormTypeMapping;
        this.column = column;
        this.metadataComplete = metadataComplete;
    }

    public String getColumnDefinition() {
        if (this.metadataComplete) {
            return null;
        }
        return this.column.getColumnDefinition();
    }

    public void setColumnDefinition(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public Boolean getInsertable() {
        if (this.metadataComplete) {
            return this.column.getDefaultInsertable();
        }
        return this.column.getInsertable();
    }

    public void setInsertable(Boolean value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public Integer getLength() {
        if (this.metadataComplete) {
            return this.column.getDefaultLength();
        }
        return this.column.getLength();
    }

    public void setLength(Integer value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public String getName() {
        if (this.metadataComplete) {
            return this.column.getDefaultName();
        }
        return this.column.getName();
    }

    public void setName(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public Boolean getNullable() {
        if (this.metadataComplete) {
            return this.column.getDefaultNullable();
        }
        return this.column.getNullable();
    }

    public void setNullable(Boolean value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public Integer getPrecision() {
        if (this.metadataComplete) {
            return this.column.getDefaultPrecision();
        }
        return this.column.getPrecision();
    }

    public void setPrecision(Integer value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public Integer getScale() {
        if (this.metadataComplete) {
            return this.column.getDefaultScale();
        }
        return this.column.getScale();
    }

    public void setScale(Integer value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public String getTable() {
        if (!this.metadataComplete && this.column.getSpecifiedTable() != null) {
            return this.column.getSpecifiedTable();
        }
        return this.ormTypeMapping.getTableName();
    }

    public void setTable(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public Boolean getUnique() {
        if (this.metadataComplete) {
            return this.column.getDefaultUnique();
        }
        return this.column.getUnique();
    }

    public void setUnique(Boolean value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public Boolean getUpdatable() {
        if (this.metadataComplete) {
            return this.column.getDefaultUpdatable();
        }
        return this.column.getUpdatable();
    }

    public void setUpdatable(Boolean value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public void update(Column column) {
        this.column = column;
    }

    public TextRange getNameTextRange() {
        return null;
    }

    public TextRange getTableTextRange() {
        return null;
    }
}

