/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.internal.AbstractResourceModel;
import org.eclipse.jpt.core.internal.resource.java.JpaCompilationUnitImpl;
import org.eclipse.jpt.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.BitTools;

public class JavaResourceModelImpl
extends AbstractResourceModel
implements JavaResourceModel {
    private final Collection<ResourceModelListener> resourceModelListeners = new ArrayList<ResourceModelListener>();
    private final JpaCompilationUnit jpaCompilationUnit;

    public JavaResourceModelImpl(IFile file, JpaAnnotationProvider annotationProvider, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        super(file);
        this.jpaCompilationUnit = new JpaCompilationUnitImpl(file, annotationProvider, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter, this);
    }

    public String getResourceType() {
        return "JAVA_RESOURCE_TYPE";
    }

    public JpaCompilationUnit getJpaCompilationUnit() {
        return this.jpaCompilationUnit;
    }

    public void addResourceModelChangeListener(ResourceModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (this.resourceModelListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener " + listener + " already added");
        }
        this.resourceModelListeners.add(listener);
    }

    public void removeResourceModelChangeListener(ResourceModelListener listener) {
        if (!this.resourceModelListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener " + listener + " was never added");
        }
        this.resourceModelListeners.add(listener);
    }

    public void resourceChanged() {
        if (this.jpaCompilationUnit == null) {
            throw new IllegalStateException("Change events should not be fired during construction");
        }
        for (ResourceModelListener listener : this.resourceModelListeners) {
            listener.resourceModelChanged();
        }
    }

    public void javaElementChanged(ElementChangedEvent event) {
        this.synchWithJavaDelta(event.getDelta());
    }

    private void synchWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.synchChildrenWithJavaDelta(delta);
                break;
            }
            case 5: {
                this.synchCompilationUnitWithJavaDelta(delta);
                break;
            }
        }
    }

    private void synchChildrenWithJavaDelta(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.synchWithJavaDelta(child);
            ++n2;
        }
    }

    private void synchCompilationUnitWithJavaDelta(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return;
        }
        if (delta.getKind() == 2) {
            return;
        }
        if (delta.getElement().equals(this.jpaCompilationUnit.getCompilationUnit())) {
            this.jpaCompilationUnit.updateFromJava();
        }
    }

    public void updateFromResource() {
        this.jpaCompilationUnit.updateFromJava();
    }

    public void resolveTypes() {
        this.jpaCompilationUnit.resolveTypes();
    }
}

