/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIterator<E>
implements Iterator<E> {
    private final Collection<Iterator<? extends E>> iterators;
    private final Set<E> visitedNeighbors;
    private final MisterRogers<E> misterRogers;
    private Iterator<? extends E> currentIterator;
    private E nextNeighbor;
    private boolean done;

    public GraphIterator(E ... roots) {
        this(new ArrayIterator<E>(roots));
    }

    public GraphIterator(Iterator<? extends E> roots) {
        this(roots, MisterRogers.Disabled.instance());
    }

    public GraphIterator(E root) {
        this(root, MisterRogers.Disabled.instance());
    }

    public GraphIterator(E root, MisterRogers<E> misterRogers) {
        this(new SingleElementIterator<E>(root), misterRogers);
    }

    public GraphIterator(Iterator<? extends E> roots, MisterRogers<E> misterRogers) {
        this.currentIterator = roots;
        this.iterators = new LinkedList<Iterator<? extends E>>();
        this.misterRogers = misterRogers;
        this.visitedNeighbors = new HashSet();
        this.loadNextNeighbor();
    }

    private void loadNextNeighbor() {
        if (this.currentIterator == EmptyIterator.instance()) {
            this.done = true;
        } else if (this.currentIterator.hasNext()) {
            E nextPossibleNeighbor = this.currentIterator.next();
            if (this.visitedNeighbors.contains(nextPossibleNeighbor)) {
                this.loadNextNeighbor();
            } else {
                this.nextNeighbor = nextPossibleNeighbor;
                this.visitedNeighbors.add(nextPossibleNeighbor);
                this.iterators.add(this.neighbors(nextPossibleNeighbor));
            }
        } else {
            Iterator<Iterator<E>> stream = this.iterators.iterator();
            while (!this.currentIterator.hasNext() && stream.hasNext()) {
                this.currentIterator = stream.next();
                stream.remove();
            }
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = EmptyIterator.instance();
            }
            this.loadNextNeighbor();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E next = this.nextNeighbor;
        this.loadNextNeighbor();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected Iterator<? extends E> neighbors(E next) {
        return this.misterRogers.neighbors(next);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.currentIterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MisterRogers<T> {
        public Iterator<? extends T> neighbors(T var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Disabled<S>
        implements MisterRogers<S> {
            public static final MisterRogers INSTANCE = new Disabled();

            public static <R> MisterRogers<R> instance() {
                return INSTANCE;
            }

            private Disabled() {
            }

            @Override
            public Iterator<S> neighbors(S next) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "GraphIterator.MisterRogers.Disabled";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Null<S>
        implements MisterRogers<S> {
            public static final MisterRogers INSTANCE = new Null();

            public static <R> MisterRogers<R> instance() {
                return INSTANCE;
            }

            private Null() {
            }

            @Override
            public Iterator<S> neighbors(S next) {
                return EmptyIterator.instance();
            }

            public String toString() {
                return "GraphIterator.MisterRogers.Null";
            }
        }
    }
}

