/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AspectAdapter<S>
extends AbstractModel {
    protected S subject;
    protected final PropertyValueModel<? extends S> subjectHolder;
    protected final PropertyChangeListener subjectChangeListener;

    protected AspectAdapter(S subject) {
        this((PropertyValueModel<S>)new StaticPropertyValueModel<S>(subject));
    }

    protected AspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        if (subjectHolder == null) {
            throw new NullPointerException();
        }
        this.subjectHolder = subjectHolder;
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.subject = null;
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new LocalChangeSupport(this, this.getListenerClass(), this.getListenerAspectName());
    }

    protected PropertyChangeListener buildSubjectChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                AspectAdapter.this.subjectChanged();
            }

            public String toString() {
                return "subject change listener";
            }
        };
    }

    protected synchronized void subjectChanged() {
        Object oldValue = this.getValue();
        boolean hasListeners = this.hasListeners();
        if (hasListeners) {
            this.disengageSubject();
        }
        this.subject = this.subjectHolder.getValue();
        if (hasListeners) {
            this.engageSubject();
            this.fireAspectChange(oldValue, this.getValue());
        }
    }

    protected abstract Object getValue();

    protected abstract Class<? extends ChangeListener> getListenerClass();

    protected abstract String getListenerAspectName();

    protected abstract boolean hasListeners();

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected abstract void fireAspectChange(Object var1, Object var2);

    protected void engageSubject() {
        if (this.subject != null) {
            this.engageSubject_();
        }
    }

    protected abstract void engageSubject_();

    protected void disengageSubject() {
        if (this.subject != null) {
            this.disengageSubject_();
        }
    }

    protected abstract void disengageSubject_();

    protected void engageSubjectHolder() {
        this.subjectHolder.addPropertyChangeListener("value", this.subjectChangeListener);
        this.subject = this.subjectHolder.getValue();
    }

    protected void disengageSubjectHolder() {
        this.subjectHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        this.subject = null;
    }

    protected void engageModels() {
        this.engageSubjectHolder();
        this.engageSubject();
    }

    protected void disengageModels() {
        this.disengageSubject();
        this.disengageSubjectHolder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LocalChangeSupport
    extends SingleAspectChangeSupport {
        private static final long serialVersionUID = 1L;

        public LocalChangeSupport(AspectAdapter<S> source, Class<? extends ChangeListener> listenerClass, String aspectName) {
            super(source, listenerClass, aspectName);
        }

        protected boolean listenerIsRelevant(Class<? extends ChangeListener> lClass) {
            return lClass == this.listenerClass;
        }

        protected boolean hasNoRelevantListeners(Class<? extends ChangeListener> lClass) {
            return this.listenerIsRelevant(lClass) && this.hasNoListeners(lClass);
        }

        protected boolean listenerIsRelevant(Class<? extends ChangeListener> lClass, String listenerAspectName) {
            return this.listenerIsRelevant(lClass) && listenerAspectName == AspectAdapter.this.getListenerAspectName();
        }

        protected boolean hasNoRelevantListeners(Class<? extends ChangeListener> lClass, String listenerAspectName) {
            return this.listenerIsRelevant(lClass, listenerAspectName) && this.hasNoListeners(lClass, listenerAspectName);
        }

        @Override
        protected <T extends ChangeListener> void addListener(Class<T> lClass, T listener) {
            if (this.hasNoRelevantListeners(lClass)) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(lClass, listener);
        }

        @Override
        protected <T extends ChangeListener> void addListener(String listenerAspectName, Class<T> lClass, T listener) {
            if (this.hasNoRelevantListeners(lClass, listenerAspectName)) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(listenerAspectName, lClass, listener);
        }

        @Override
        protected <T extends ChangeListener> void removeListener(Class<T> lClass, T listener) {
            super.removeListener(lClass, listener);
            if (this.hasNoRelevantListeners(lClass)) {
                AspectAdapter.this.disengageModels();
            }
        }

        @Override
        protected <T extends ChangeListener> void removeListener(String listenerAspectName, Class<T> lClass, T listener) {
            super.removeListener(listenerAspectName, lClass, listener);
            if (this.hasNoRelevantListeners(lClass, listenerAspectName)) {
                AspectAdapter.this.disengageModels();
            }
        }
    }
}

