/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.support.jsp;

import java.util.ArrayList;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jst.jsp.core.internal.text.StructuredTextPartitionerForJSP;
import org.eclipse.jst.jsp.ui.StructuredTextViewerConfigurationJSP;
import org.eclipse.jst.jsp.ui.internal.autoedit.StructuredAutoEditStrategyJSP;
import org.eclipse.wst.jsdt.web.ui.StructuredTextViewerConfigurationJSDT;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class JSDTStructuredTextViewerConfigurationJSP
extends StructuredTextViewerConfigurationJSP {
    private String[] fConfiguredContentTypes;
    private StructuredTextViewerConfiguration fHTMLSourceViewerConfiguration;

    private StructuredTextViewerConfiguration getHTMLSourceViewerConfiguration() {
        if (this.fHTMLSourceViewerConfiguration == null) {
            this.fHTMLSourceViewerConfiguration = new StructuredTextViewerConfigurationJSDT();
        }
        return this.fHTMLSourceViewerConfiguration;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] strategies = null;
        if (contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.HTML_DECLARATION") {
            ArrayList<Object> allStrategies = new ArrayList<Object>(0);
            allStrategies.add(new StructuredAutoEditStrategyJSP());
            IAutoEditStrategy[] htmlStrategies = this.getHTMLSourceViewerConfiguration().getAutoEditStrategies(sourceViewer, contentType);
            int i = 0;
            while (i < htmlStrategies.length) {
                allStrategies.add(htmlStrategies[i]);
                ++i;
            }
            strategies = allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
        } else {
            strategies = super.getAutoEditStrategies(sourceViewer, contentType);
        }
        return strategies;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            String[] htmlTypes = this.getHTMLSourceViewerConfiguration().getConfiguredContentTypes(sourceViewer);
            String[] jspTypes = StructuredTextPartitionerForJSP.getConfiguredContentTypes();
            this.fConfiguredContentTypes = new String[htmlTypes.length + jspTypes.length];
            int index = 0;
            System.arraycopy(htmlTypes, 0, this.fConfiguredContentTypes, index, htmlTypes.length);
            System.arraycopy(jspTypes, 0, this.fConfiguredContentTypes, index += htmlTypes.length, jspTypes.length);
        }
        return this.fConfiguredContentTypes;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            IContentAssistant htmlContentAssistant = this.getHTMLSourceViewerConfiguration().getContentAssistant(sourceViewer);
            IContentAssistProcessor processor = htmlContentAssistant.getContentAssistProcessor("org.eclipse.wst.html.SCRIPT");
            processors = new IContentAssistProcessor[]{processor};
        } else if (partitionType == "org.eclipse.wst.css.STYLE") {
            IContentAssistant htmlContentAssistant = this.getHTMLSourceViewerConfiguration().getContentAssistant(sourceViewer);
            IContentAssistProcessor processor = htmlContentAssistant.getContentAssistProcessor("org.eclipse.wst.css.STYLE");
            processors = new IContentAssistProcessor[]{processor};
        } else {
            processors = super.getContentAssistProcessors(sourceViewer, partitionType);
        }
        return processors;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            IFormattingStrategy cf = (IFormattingStrategy)ExtendedConfigurationBuilder.getInstance().getConfiguration("contentformater", contentTypes[i]);
            if (cf != null && formatter instanceof MultiPassContentFormatter) {
                ((MultiPassContentFormatter)formatter).setSlaveStrategy(cf, contentTypes[i]);
            }
            ++i;
        }
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        ITextDoubleClickStrategy strategy = null;
        strategy = contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.SCRIPT" ? this.getHTMLSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, contentType) : (contentType == "org.eclipse.jst.jsp.DEFAULT_JSP" ? this.getHTMLSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, "org.eclipse.wst.html.HTML_DEFAULT") : super.getDoubleClickStrategy(sourceViewer, contentType));
        return strategy;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>(0);
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int m = 0;
        while (m < superDetectors.length) {
            IHyperlinkDetector detector = superDetectors[m];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++m;
        }
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            IHyperlinkDetector hl = (IHyperlinkDetector)ExtendedConfigurationBuilder.getInstance().getConfiguration("hyperlinkdetector", contentTypes[i]);
            if (hl != null) {
                allDetectors.add(hl);
            }
            ++i;
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentations = null;
        indentations = contentType == "org.eclipse.wst.xml.XML_DEFAULT" ? super.getIndentPrefixes(sourceViewer, contentType) : this.getHTMLSourceViewerConfiguration().getIndentPrefixes(sourceViewer, contentType);
        return indentations;
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        IInformationProvider provider = null;
        if (partitionType == "org.eclipse.wst.html.HTML_DEFAULT") {
            IInformationPresenter htmlPresenter = this.getHTMLSourceViewerConfiguration().getInformationPresenter(sourceViewer);
            provider = htmlPresenter.getInformationProvider("org.eclipse.wst.html.HTML_DEFAULT");
        } else if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            IInformationPresenter htmlPresenter = this.getHTMLSourceViewerConfiguration().getInformationPresenter(sourceViewer);
            provider = htmlPresenter.getInformationProvider("org.eclipse.wst.html.SCRIPT");
        } else {
            provider = super.getInformationProvider(sourceViewer, partitionType);
        }
        return provider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        providers = partitionType == "org.eclipse.wst.html.HTML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_COMMENT" || partitionType == "org.eclipse.wst.html.HTML_DECLARATION" ? this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.html.HTML_DEFAULT") : (partitionType == "org.eclipse.wst.html.SCRIPT" || partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT" ? this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.html.SCRIPT") : (partitionType == "org.eclipse.wst.css.STYLE" ? this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.css.STYLE") : super.getLineStyleProviders(sourceViewer, partitionType)));
        return providers;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        ITextHover hover = null;
        hover = contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.SCRIPT" ? this.getHTMLSourceViewerConfiguration().getTextHover(sourceViewer, contentType, stateMask) : super.getTextHover(sourceViewer, contentType);
        return hover;
    }
}

