/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.jee.model.internal.common.ManyToOneRelation;
import org.eclipse.jst.jee.model.internal.common.MyModelProviderEvent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationModelProvider<T>
implements IResourceChangeListener,
IModelProvider {
    protected T modelObject;
    private Collection<IModelProviderListener> listeners;
    private Lock listenersLock = new ReentrantLock();
    protected IFacetedProject facetedProject;
    private ManyToOneRelation<SecurityRoleRef, SecurityRole> rolesToRolesRef = new ManyToOneRelation();

    private static SecurityRole findRole(Collection<SecurityRole> securityRoles, String name) {
        for (SecurityRole role : securityRoles) {
            if (!role.getRoleName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public AbstractAnnotationModelProvider(IFacetedProject project) {
        if (project == null) {
            throw new IllegalArgumentException("The project argument can not be null");
        }
        this.facetedProject = project;
    }

    public T getConcreteModel() {
        if (this.modelObject == null) {
            this.preLoad();
            try {
                this.loadModel();
                this.postLoad();
            }
            catch (CoreException e) {
                this.log(e.getStatus());
                return null;
            }
        }
        return this.modelObject;
    }

    public Object getModelObject() {
        return this.getConcreteModel();
    }

    public Object getModelObject(IPath modelPath) {
        return this.getConcreteModel();
    }

    protected abstract void loadModel() throws CoreException;

    protected void preLoad() {
    }

    protected void postLoad() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 22);
    }

    protected void notifyListeners(IModelProviderEvent event) {
        this.notifyListeners(this.listeners, event);
    }

    protected void clearListeners() {
        if (this.listeners == null) {
            return;
        }
        try {
            this.listenersLock.lock();
            this.listeners.clear();
            this.listeners = null;
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    private void notifyListeners(Collection<IModelProviderListener> aListeners, final IModelProviderEvent event) {
        if (this.listeners == null) {
            return;
        }
        this.listenersLock.lock();
        try {
            if (event.getChangedResources() == null || event.getChangedResources().isEmpty()) {
                return;
            }
            for (final IModelProviderListener listener : aListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.modelsChanged(event);
                    }
                });
            }
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    protected Collection<IModelProviderListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet<IModelProviderListener>();
        }
        return this.listeners;
    }

    public void addListener(IModelProviderListener listener) {
        this.listenersLock.lock();
        try {
            this.getModelObject();
            this.getListeners().add(listener);
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    public void removeListener(IModelProviderListener listener) {
        this.listenersLock.lock();
        try {
            this.getListeners().remove(listener);
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    protected boolean isProjectRelative(IProject project) {
        if (project == null || this.facetedProject == null) {
            return false;
        }
        return project.equals((Object)this.facetedProject.getProject());
    }

    public abstract void dispose();

    public void resourceChanged(IResourceChangeEvent event) {
        MyModelProviderEvent modelEvent = new MyModelProviderEvent(0, null, this.facetedProject.getProject());
        switch (event.getType()) {
            case 2: 
            case 4: {
                IProject project = (IProject)event.getResource();
                if (!this.isProjectRelative(project)) {
                    return;
                }
                this.dispose();
                break;
            }
            case 16: {
                this.internalRefresh(modelEvent, event.getDelta());
            }
        }
    }

    protected void internalRefresh(final IModelProviderEvent modelEvent, IResourceDelta projectDelta) {
        final CollectiveResourceDeltaVisitor visitor = this.collectDeltaFiles(projectDelta);
        Job job = new Job("Refresh annotation model"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        for (IFile file : visitor.getRemovedFiles()) {
                            AbstractAnnotationModelProvider.this.processRemovedFile(modelEvent, file);
                        }
                        for (IFile file : visitor.getAddedFiles()) {
                            AbstractAnnotationModelProvider.this.processAddedFile(modelEvent, file);
                        }
                        for (IFile file : visitor.getChangedFiles()) {
                            AbstractAnnotationModelProvider.this.processChangedFile(modelEvent, file);
                        }
                        visitor.clear();
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        AbstractAnnotationModelProvider.this.notifyListeners(modelEvent);
                        return iStatus;
                    }
                }
                finally {
                    AbstractAnnotationModelProvider.this.notifyListeners(modelEvent);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected CollectiveResourceDeltaVisitor collectDeltaFiles(IResourceDelta projectDelta) {
        CollectiveResourceDeltaVisitor visitor = new CollectiveResourceDeltaVisitor(this.facetedProject.getProject());
        try {
            projectDelta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException e1) {
            this.log(e1.getStatus());
            e1.printStackTrace();
        }
        return visitor;
    }

    protected abstract void processRemovedFile(IModelProviderEvent var1, IFile var2) throws CoreException;

    protected abstract void processAddedFile(IModelProviderEvent var1, IFile var2) throws CoreException;

    protected abstract void processChangedFile(IModelProviderEvent var1, IFile var2) throws CoreException;

    protected void log(IStatus status) {
    }

    protected MyModelProviderEvent createModelProviderEvent() {
        return new MyModelProviderEvent(0, null, this.facetedProject.getProject());
    }

    protected abstract Collection<SecurityRole> getSecurityRoles();

    protected abstract Collection<SecurityRoleRef> getSecurityRoleRefs(JavaEEObject var1);

    protected void disconnectFromRoles(JavaEEObject target) {
        Collection<SecurityRole> roles = this.getSecurityRoles();
        if (roles == null) {
            return;
        }
        Collection<SecurityRoleRef> refs = this.getSecurityRoleRefs(target);
        if (refs == null) {
            return;
        }
        for (SecurityRoleRef ref : refs) {
            SecurityRole role = this.rolesToRolesRef.getTarget(ref);
            this.rolesToRolesRef.disconnectSource(ref);
            if (this.rolesToRolesRef.containsTarget(role)) continue;
            this.getSecurityRoles().remove(role);
        }
    }

    protected void securityRoleFound(JavaEEObject object, SecurityRole securityRole) {
        this.connectWithRole(securityRole, object);
    }

    private void connectWithRole(SecurityRole securityRole, JavaEEObject target) {
        Collection<SecurityRole> roles = this.getSecurityRoles();
        if (roles == null) {
            return;
        }
        Collection<SecurityRoleRef> refs = this.getSecurityRoleRefs(target);
        if (refs == null) {
            return;
        }
        SecurityRole role = AbstractAnnotationModelProvider.findRole(roles, securityRole.getRoleName());
        if (role == null) {
            roles.add(securityRole);
            role = securityRole;
        }
        for (SecurityRoleRef ref : refs) {
            if (!ref.getRoleName().equals(role.getRoleName())) continue;
            this.rolesToRolesRef.connect(ref, role);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CollectiveResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private Collection<IFile> addedFiles = new ArrayList<IFile>();
        private Collection<IFile> removedFiles = new ArrayList<IFile>();
        private Collection<IFile> changedFiles = new ArrayList<IFile>();
        private IJavaProject ejbProjectJavaView;

        public CollectiveResourceDeltaVisitor(IProject ejbProject) {
            this.ejbProjectJavaView = JavaCore.create((IProject)ejbProject);
        }

        public Collection<IFile> getAddedFiles() {
            return this.addedFiles;
        }

        public Collection<IFile> getRemovedFiles() {
            return this.removedFiles;
        }

        public Collection<IFile> getChangedFiles() {
            return this.changedFiles;
        }

        public void clear() {
            this.addedFiles.clear();
            this.removedFiles.clear();
            this.changedFiles.clear();
        }

        private boolean isOnClasspath(IFile file) {
            return this.ejbProjectJavaView.isOnClasspath((IResource)file);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getResource().getType() == 4) {
                return AbstractAnnotationModelProvider.this.isProjectRelative((IProject)delta.getResource());
            }
            if (delta.getResource().getType() == 1) {
                IFile file = (IFile)delta.getResource();
                if (!this.isOnClasspath(file)) {
                    return false;
                }
                if ("java".equals(file.getFileExtension())) {
                    switch (delta.getKind()) {
                        case 1: {
                            this.addedFiles.add((IFile)delta.getResource());
                            break;
                        }
                        case 4: {
                            this.changedFiles.add((IFile)delta.getResource());
                            break;
                        }
                        case 2: {
                            this.removedFiles.add((IFile)delta.getResource());
                        }
                    }
                }
                return false;
            }
            return true;
        }
    }
}

