/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.classpath;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JSFLibrariesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench wb;
    private TreeViewer tv;
    private TreeViewerAdapter tvAdapter;
    private TreeLabelProvider tvLabelProvider;
    private Composite btnComp;
    private Button btnNew;
    private Button btnEdit;
    private Button btnDelete;
    private Button btnMakeDefaultImpl;

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        Label lblLibs = new Label(c, 0);
        lblLibs.setText(Messages.JSFLibrariesPreferencePage_DefinedJSFLibraries);
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 2;
        lblLibs.setLayoutData((Object)gd1);
        this.tv = new TreeViewer(c, 2816);
        this.tvAdapter = new TreeViewerAdapter();
        this.tvLabelProvider = new TreeLabelProvider();
        this.tv.setContentProvider((IContentProvider)this.tvAdapter);
        this.tv.setLabelProvider((IBaseLabelProvider)this.tvLabelProvider);
        this.tv.addSelectionChangedListener((ISelectionChangedListener)this.tvAdapter);
        this.tv.addDoubleClickListener((IDoubleClickListener)this.tvAdapter);
        this.tv.setComparator((ViewerComparator)this.tvAdapter);
        this.tv.getTree().setLayoutData((Object)new GridData(1808));
        this.tv.setInput(this.getJSFLibraries());
        this.createButtons(c);
        return c;
    }

    private void createButtons(Composite c) {
        this.btnComp = new Composite(c, 0);
        GridLayout gl1 = new GridLayout(1, false);
        gl1.marginHeight = 0;
        gl1.marginWidth = 0;
        this.btnComp.setLayout((Layout)gl1);
        this.btnComp.setLayoutData((Object)new GridData(19));
        this.btnNew = new Button(this.btnComp, 0);
        this.btnNew.setText(Messages.JSFLibrariesPreferencePage_New);
        this.btnNew.setLayoutData((Object)new GridData(770));
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibrariesPreferencePage.this.openJSFLibraryEditDialog(null);
            }
        });
        this.btnEdit = new Button(this.btnComp, 0);
        this.btnEdit.setText(Messages.JSFLibrariesPreferencePage_Edit);
        this.btnEdit.setLayoutData((Object)new GridData(770));
        this.btnEdit.setEnabled(false);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] element = JSFLibrariesPreferencePage.this.tv.getTree().getSelection();
                if (element != null) {
                    JSFLibrariesPreferencePage.this.openJSFLibraryEditDialog(element[0]);
                }
            }
        });
        this.btnDelete = new Button(this.btnComp, 0);
        this.btnDelete.setText(Messages.JSFLibrariesPreferencePage_Remove);
        this.btnDelete.setLayoutData((Object)new GridData(770));
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection objs;
                boolean modified = false;
                if (JSFLibrariesPreferencePage.this.tv.getSelection() instanceof StructuredSelection && (objs = (StructuredSelection)JSFLibrariesPreferencePage.this.tv.getSelection()) != null) {
                    for (JSFLibrary lib : objs) {
                        if (lib instanceof PluginProvidedJSFLibrary) {
                            MessageDialog.openInformation((Shell)JSFLibrariesPreferencePage.this.getShell(), (String)Messages.JSFLibrariesPreferencePage_CannotRemovePluginProvidedTitle, (String)Messages.JSFLibrariesPreferencePage_CannotRemovePluginProvidedMessage);
                            continue;
                        }
                        JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().removeJSFLibrary(lib);
                        modified = true;
                    }
                    if (modified) {
                        JSFLibraryRegistryUtil.getInstance().saveJSFLibraryRegistry();
                        JSFLibrariesPreferencePage.this.tv.refresh();
                    }
                }
            }
        });
        this.btnMakeDefaultImpl = new Button(this.btnComp, 0);
        this.btnMakeDefaultImpl.setLayoutData((Object)new GridData(264));
        this.btnMakeDefaultImpl.setText(Messages.JSFLibrariesPreferencePage_MakeDefault);
        this.btnMakeDefaultImpl.setVisible(false);
        this.btnMakeDefaultImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection objs;
                if (JSFLibrariesPreferencePage.this.tv.getSelection() instanceof StructuredSelection && (objs = (StructuredSelection)JSFLibrariesPreferencePage.this.tv.getSelection()) != null) {
                    if (objs.getFirstElement() instanceof JSFLibrary) {
                        JSFLibrary lib = (JSFLibrary)objs.getFirstElement();
                        JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().setDefaultImplementation(lib);
                    }
                    JSFLibraryRegistryUtil.getInstance().saveJSFLibraryRegistry();
                    JSFLibrariesPreferencePage.this.tv.refresh();
                }
            }
        });
    }

    private Object getJSFLibraries() {
        return JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getAllJSFLibraries();
    }

    public void init(IWorkbench workbench) {
        this.wb = workbench;
        this.setDescription(Messages.JSFLibrariesPreferencePage_Description);
        this.noDefaultAndApplyButton();
    }

    public Viewer getLibraryViewer() {
        return this.tv;
    }

    protected void doListSelected(SelectionChangedEvent event) {
        this.updateButtonState();
    }

    protected void doDoubleClick(DoubleClickEvent event) {
        this.openJSFLibraryEditDialog(this.tv.getTree().getSelection()[0]);
    }

    private void updateButtonState() {
        this.btnEdit.setEnabled(this.tv.getTree().getSelectionCount() == 1);
        if (this.tv.getTree().getSelectionCount() == 1 && this.tv.getTree().getSelection()[0].getData() instanceof JSFLibrary) {
            this.btnDelete.setEnabled(true);
            this.btnMakeDefaultImpl.setVisible(false);
            JSFLibrary lib = (JSFLibrary)this.tv.getTree().getSelection()[0].getData();
            this.btnMakeDefaultImpl.setVisible(lib.isImplementation());
        } else {
            this.btnDelete.setEnabled(false);
            this.btnMakeDefaultImpl.setVisible(false);
        }
    }

    private void openJSFLibraryEditDialog(Object element) {
        if (this.isPluginProvidedJSFLibrary(element)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.JSFLibrariesPreferencePage_CannotModifyPluginProvidedTitle, (String)Messages.JSFLibrariesPreferencePage_CannotModifyPluginProvidedMessage);
            return;
        }
        JSFLibraryWizard wizard = new JSFLibraryWizard();
        wizard.init(this.wb, this.getStructuredElement(element));
        WizardDialog dialog = new WizardDialog(this.wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int ret = dialog.open();
        if (ret == 0) {
            this.tv.refresh();
        }
    }

    private IStructuredSelection getStructuredElement(Object element) {
        if (element instanceof TreeItem) {
            Object item = ((TreeItem)element).getData();
            if (item instanceof ArchiveFile) {
                JSFLibrary parent = ((ArchiveFile)item).getJSFLibrary();
                return new StructuredSelection((Object)parent);
            }
            if (item instanceof JSFLibrary) {
                return new StructuredSelection(item);
            }
        }
        return null;
    }

    private boolean isPluginProvidedJSFLibrary(Object treeElement) {
        if (treeElement instanceof TreeItem) {
            Object item = ((TreeItem)treeElement).getData();
            if (item instanceof PluginProvidedJSFLibrary) {
                return true;
            }
            if (item instanceof ArchiveFile) {
                return ((ArchiveFile)item).getJSFLibrary() instanceof PluginProvidedJSFLibrary;
            }
        }
        return false;
    }

    private static class TreeLabelProvider
    implements ILabelProvider {
        private final Image libImg;
        private final Image jarImg;

        TreeLabelProvider() {
            ImageDescriptor jarImgDesc = JSFUiPlugin.getImageDescriptor("obj16/jar_obj.gif");
            this.jarImg = jarImgDesc.createImage();
            ImageDescriptor libImgDesc = JSFUiPlugin.getImageDescriptor("obj16/library_obj.gif");
            this.libImg = libImgDesc.createImage();
        }

        public Image getImage(Object element) {
            if (element instanceof JSFLibrary) {
                return this.libImg;
            }
            return this.jarImg;
        }

        public String getText(Object element) {
            StringBuffer labelBuf = new StringBuffer();
            if (element instanceof JSFLibrary) {
                JSFLibrary lib = (JSFLibrary)element;
                labelBuf.append(lib.getLabel());
                if (lib.isImplementation()) {
                    if (lib == JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getDefaultImplementation()) {
                        labelBuf.append(Messages.JSFLibrariesPreferencePage_DEFAULT_IMPL_DESC);
                    } else {
                        labelBuf.append(Messages.JSFLibrariesPreferencePage_IMPL_DESC);
                    }
                }
            }
            if (element instanceof ArchiveFile) {
                ArchiveFile jar = (ArchiveFile)element;
                labelBuf.append(jar.getName());
                if (!jar.exists()) {
                    labelBuf.append(Messages.JSFLibrariesPreferencePage_MISSING_DESC);
                }
                labelBuf.append(" - ").append(((ArchiveFile)element).getSourceLocation());
            }
            return labelBuf.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.libImg != null) {
                this.libImg.dispose();
            }
            if (this.jarImg != null) {
                this.jarImg.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class TreeViewerAdapter
    extends ViewerComparator
    implements ITreeContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private final Object[] NO_ELEMENTS = new Object[0];

        private TreeViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return ((List)JSFLibrariesPreferencePage.this.getJSFLibraries()).toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof JSFLibrary) {
                return ((JSFLibrary)element).getArchiveFiles().toArray();
            }
            return this.NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof JSFLibrary;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JSFLibrariesPreferencePage.this.doListSelected(event);
        }

        public void doubleClick(DoubleClickEvent event) {
            JSFLibrariesPreferencePage.this.doDoubleClick(event);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof JSFLibrary && e2 instanceof JSFLibrary) {
                JSFLibrary lib1 = (JSFLibrary)e1;
                JSFLibrary lib2 = (JSFLibrary)e2;
                return this.getComparator().compare(lib1.getLabel(), lib2.getLabel());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

