/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.component;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IInputProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.Decorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorDecorator;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.form.AbstractMasterForm;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewObjectMappingService;
import org.eclipse.jst.jsf.ui.internal.common.MetadataTagImageManager;
import org.eclipse.jst.jsf.ui.internal.component.ComponentTreeViewProvider;
import org.eclipse.jst.jsf.ui.internal.component.DTJSFViewModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

class ComponentMasterForm
extends AbstractMasterForm {
    private final DTJSFViewModel _model;
    private TreeViewer _treeViewer;
    private Action _refreshAction;

    protected ComponentMasterForm(FormToolkit toolkit, DTJSFViewModel model) {
        super(toolkit);
        this._model = model;
    }

    public Control createClientArea(Composite parent) {
        Tree tree = this.getToolkit().createTree(parent, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)gridData);
        this._treeViewer = new TreeViewer(tree);
        this._treeViewer.getTree().setLayoutData((Object)gridData);
        this._treeViewer.setContentProvider((IContentProvider)new ComponentTreeViewProvider());
        this._treeViewer.setLabelProvider((IBaseLabelProvider)new TreeViewLabelProvider((IInputProvider)this._treeViewer));
        this._treeViewer.setSorter((ViewerSorter)new ComponentTreeSorter());
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentMasterForm.this.getListener().selectionChanged(event);
            }
        });
        this._model.init(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Object[] expanded = ComponentMasterForm.this._treeViewer.getExpandedElements();
                        ComponentMasterForm.this._treeViewer.refresh();
                        ComponentMasterForm.this._treeViewer.setExpandedElements(expanded);
                    }
                });
            }
        });
        this._treeViewer.setInput((Object)this._model);
        this.makeActions();
        return tree;
    }

    protected void contributeActions(IToolBarManager formManager, IToolBarManager localManager) {
        localManager.add((IAction)this._refreshAction);
        localManager.update(false);
    }

    private void makeActions() {
        this._refreshAction = new Action(){

            public void run() {
                ComponentMasterForm.this._model.update();
            }
        };
        this._refreshAction.setText("Refresh View");
        this._refreshAction.setToolTipText("Refresh View");
        this._refreshAction.setImageDescriptor(JSFUICommonPlugin.getDefault().getImageDescriptor("refresh_nav_16.gif"));
    }

    protected void contributeToHeadArea(FormToolkit toolkit, Composite container) {
        Text label = new Text(container, 16396);
        String viewId = this._model.getViewId();
        viewId = viewId == null ? "<unknown>" : viewId;
        label.setText("View: " + viewId + " (Project: " + this._model.getProject().getName() + ")");
    }

    private static class ComponentTreeSorter
    extends ViewerSorter {
        private ComponentTreeSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return 0;
        }

        public int category(Object element) {
            if (element instanceof Decorator) {
                return 0;
            }
            return 1;
        }
    }

    private static class TreeViewLabelProvider
    extends LabelProvider {
        private final IInputProvider _inputProvider;
        private final MetadataTagImageManager _metadataIconManager;

        private TreeViewLabelProvider(IInputProvider inputProvider) {
            this._inputProvider = inputProvider;
            this._metadataIconManager = new MetadataTagImageManager();
        }

        public String getText(Object obj) {
            if (obj instanceof ComponentInfo) {
                String text = "";
                ComponentInfo compInfo = (ComponentInfo)obj;
                String className = compInfo.getComponentTypeInfo().getClassName();
                int dotIdx = className.lastIndexOf(46);
                if (dotIdx > -1 && dotIdx + 1 < className.length()) {
                    className = className.substring(dotIdx + 1);
                }
                text = className;
                String id = compInfo.getId();
                if (id != null) {
                    text = String.valueOf(text) + " (id=" + id + ")";
                }
                return text;
            }
            if (obj instanceof ComponentTreeViewProvider.TreePlaceHolder) {
                return "Calculating view...";
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            Image image = null;
            if (obj instanceof ViewObject) {
                XMLViewObjectMappingService.ElementData elementData;
                XMLViewObjectMappingService mappingService = this.getMappingService();
                if (mappingService != null && (elementData = mappingService.findElementData((ViewObject)obj)) != null) {
                    TagIdentifier tagId = elementData.getTagId();
                    DTJSFViewModel model = this.getModel();
                    if (model != null) {
                        image = this._metadataIconManager.getSmallIconImage(model.getProject(), tagId);
                    }
                }
                if (image == null) {
                    image = this.getDefaultImage((ViewObject)obj);
                }
            } else if (obj instanceof ComponentTreeViewProvider.TreePlaceHolder) {
                return JSFUICommonPlugin.getDefault().getImage("configs.gif");
            }
            if (image == null) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
            return image;
        }

        private XMLViewObjectMappingService getMappingService() {
            DTUIViewRoot root;
            DTJSFViewModel model = this.getModel();
            if (model != null && (root = model.getRoot()) != null) {
                return (XMLViewObjectMappingService)root.getServices().getAdapter(XMLViewObjectMappingService.class);
            }
            return null;
        }

        private DTJSFViewModel getModel() {
            Object input = this._inputProvider.getInput();
            if (input instanceof DTJSFViewModel) {
                return (DTJSFViewModel)input;
            }
            return null;
        }

        private Image getDefaultImage(ViewObject obj) {
            if (obj instanceof DTUIViewRoot) {
                return JSFUICommonPlugin.getDefault().getImage("jsf_view.gif");
            }
            if (obj instanceof ComponentInfo) {
                return JSFUICommonPlugin.getDefault().getImage("object.gif");
            }
            if (obj instanceof ConverterDecorator) {
                return JSFUICommonPlugin.getDefault().getImage("jsf_converter.gif");
            }
            if (obj instanceof ValidatorDecorator) {
                return JSFUICommonPlugin.getDefault().getImage("jsf_validator.gif");
            }
            return JSFUICommonPlugin.getDefault().getImage("PD_Palette_Default.gif");
        }
    }
}

