/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.actions;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.servlet.ui.internal.wizard.ConvertToWebModuleTypeDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.web.ui.internal.Logger;

public class ConvertToWebModuleTypeAction
extends Action
implements IWorkbenchWindowActionDelegate {
    IStructuredSelection fSelection = null;
    IProject project = null;
    IWorkbenchWindow fWindow;

    protected boolean isValidProject(IProject aProject) {
        return J2EEProjectUtilities.isStaticWebProject((IProject)aProject);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean bEnable = false;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            bEnable = this.validateSelected((ISelection)this.fSelection);
        }
        ((Action)action).setEnabled(bEnable);
    }

    protected boolean validateSelected(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        this.fSelection = (IStructuredSelection)selection;
        Object selectedProject = this.fSelection.getFirstElement();
        if (!(selectedProject instanceof IProject)) {
            return false;
        }
        this.project = (IProject)selectedProject;
        return this.isValidProject(this.project);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            ConvertToWebModuleTypeDialog dialog = new ConvertToWebModuleTypeDialog(window.getShell());
            dialog.open();
            if (dialog.getReturnCode() == 1) {
                return;
            }
            this.doConvert(ConvertToWebModuleTypeDialog.getSelectedVersion());
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    protected void doConvert(String selectedVersion) throws Exception {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        fixedFacets.addAll(facetedProject.getFixedProjectFacets());
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"wst.web");
        fixedFacets.remove(webFacet);
        fixedFacets.add(WebFacetUtils.WEB_FACET);
        fixedFacets.add(JavaFacetUtils.JAVA_FACET);
        facetedProject.setFixedProjectFacets(fixedFacets);
        IProjectFacetVersion webFv = WebFacetUtils.WEB_FACET.getVersion(selectedVersion);
        IProjectFacetVersion javaFv = JavaFacetUtils.compilerLevelToFacet((String)JavaFacetUtils.getCompilerLevel((IProject)this.project));
        IFacetedProject.Action uninstall = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, facetedProject.getInstalledVersion(webFacet), null);
        IDataModel webModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
        webModelCfg.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        IDataModel javaModelCfg = null;
        if (ProductManager.shouldUseSingleRootStructure()) {
            javaModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
            String webRoot = webModelCfg.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
            javaModelCfg.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)(String.valueOf(webRoot) + "/" + "WEB-INF/classes"));
        }
        IFacetedProject.Action install = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webFv, (Object)webModelCfg);
        IFacetedProject.Action javaInstall = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javaFv, (Object)javaModelCfg);
        HashSet<IFacetedProject.Action> set = new HashSet<IFacetedProject.Action>();
        set.add(uninstall);
        set.add(install);
        set.add(javaInstall);
        facetedProject.modify(set, (IProgressMonitor)new NullProgressMonitor());
    }
}

