/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.JDTBeanPropertyWorkingCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTBeanIntrospector {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private final IType _type;

    public JDTBeanIntrospector(IType type) {
        this._type = type;
    }

    public Map<String, JDTBeanProperty> getProperties() {
        HashMap<String, JDTBeanProperty> propertiesWorkingCopy = new HashMap<String, JDTBeanProperty>();
        IMethod[] methods = this.getAllMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            try {
                this.processPropertyMethod(method, propertiesWorkingCopy);
            }
            catch (JavaModelException jme) {
                JSFCommonPlugin.log((Exception)((Object)jme), "Error processing IMethod for bean property info");
            }
            ++i;
        }
        HashMap<String, JDTBeanProperty> properties = new HashMap<String, JDTBeanProperty>();
        for (Map.Entry entry : propertiesWorkingCopy.entrySet()) {
            String key = (String)entry.getKey();
            JDTBeanPropertyWorkingCopy wcopy = (JDTBeanPropertyWorkingCopy)entry.getValue();
            properties.put(key, wcopy.toValueObject());
        }
        return properties;
    }

    private void processPropertyMethod(IMethod method, Map<String, JDTBeanProperty> properties) throws JavaModelException {
        if (!method.isConstructor() && Flags.isPublic((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags())) {
            boolean startsWithSet;
            String methodName = method.getElementName();
            String returnType = method.getReturnType();
            boolean startsWithIs = methodName.startsWith(IS_PREFIX) && "Z".equals(returnType) && method.getNumberOfParameters() == 0 && methodName.length() > IS_PREFIX.length();
            boolean startsWithGet = methodName.startsWith(GET_PREFIX) && method.getNumberOfParameters() == 0 && !"V".equals(returnType) && methodName.length() > GET_PREFIX.length();
            boolean bl = startsWithSet = methodName.startsWith(SET_PREFIX) && method.getNumberOfParameters() == 1 && "V".equals(returnType) && methodName.length() > SET_PREFIX.length();
            if (startsWithGet || startsWithSet || startsWithIs) {
                String propertyName = Introspector.decapitalize(methodName.substring(startsWithIs ? 2 : 3));
                JDTBeanPropertyWorkingCopy workingCopy = (JDTBeanPropertyWorkingCopy)properties.get(propertyName);
                if (workingCopy == null) {
                    workingCopy = new JDTBeanPropertyWorkingCopy(this._type);
                    properties.put(propertyName, workingCopy);
                }
                if (startsWithIs) {
                    workingCopy.setIsGetter(method);
                } else if (startsWithGet) {
                    workingCopy.setGetter(method);
                } else if (startsWithSet) {
                    workingCopy.addSetter(method);
                }
            }
        }
    }

    public IMethod[] getAllMethods() {
        IMethod[] methods = new IMethod[]{};
        try {
            if (this._type != null) {
                ITypeHierarchy hierarchy = this._type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                methods = JDTBeanIntrospector.getAllMethods(hierarchy, this._type);
            }
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log((Exception)((Object)jme), "Error getting type information for bean");
        }
        return methods;
    }

    private static IMethod[] getAllMethods(ITypeHierarchy typeHierarchy, IType type) {
        ArrayList methods = new ArrayList();
        IType[] superTypes = typeHierarchy.getAllSuperclasses(type);
        IType[] closure = new IType[superTypes.length + 1];
        closure[0] = type;
        System.arraycopy(superTypes, 0, closure, 1, superTypes.length);
        int i = 0;
        while (i < closure.length) {
            try {
                IType superType = closure[i];
                methods.addAll(Arrays.asList(superType.getMethods()));
            }
            catch (JavaModelException e) {
                JSFCommonPlugin.log((Exception)((Object)e), "Error getting super type information for bean");
            }
            ++i;
        }
        return methods.toArray(new IMethod[methods.size()]);
    }
}

