/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.beaninfo.BeaninfoFactory;
import org.eclipse.jem.internal.beaninfo.BeaninfoPackage;
import org.eclipse.jem.internal.beaninfo.ImplicitItem;
import org.eclipse.jem.internal.beaninfo.MethodDecorator;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.beaninfo.ParameterDecorator;
import org.eclipse.jem.internal.beaninfo.impl.FeatureDecoratorImpl;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public class MethodDecoratorImpl
extends FeatureDecoratorImpl
implements MethodDecorator {
    public static final long METHOD_PARAMETERS_IMPLICIT = 1L;
    public static final long METHOD_PARAMETERS_DEFAULT = 2L;
    protected static final boolean PARMS_EXPLICIT_EMPTY_EDEFAULT = false;
    protected static final int PARMS_EXPLICIT_EMPTY_EFLAG = 262144;
    protected EList serParmDesc = null;

    protected MethodDecoratorImpl() {
    }

    protected EClass eStaticClass() {
        return BeaninfoPackage.eINSTANCE.getMethodDecorator();
    }

    public boolean isParmsExplicitEmpty() {
        return (this.eFlags & 0x40000) != 0;
    }

    public void setParmsExplicitEmpty(boolean newParmsExplicitEmpty) {
        boolean oldParmsExplicitEmpty;
        boolean bl = oldParmsExplicitEmpty = (this.eFlags & 0x40000) != 0;
        this.eFlags = newParmsExplicitEmpty ? (this.eFlags |= 0x40000) : (this.eFlags &= 0xFFFBFFFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldParmsExplicitEmpty, newParmsExplicitEmpty));
        }
    }

    private EList createDefaultParmsList() {
        EList parmsList = this.getSerParmDesc();
        parmsList.clear();
        this.setImplicitlySetBits(this.getImplicitlySetBits() | 2L);
        List p = this.getMethodParameters();
        if (p == null) {
            return parmsList;
        }
        int psize = p.size();
        int i = 0;
        while (i < psize) {
            ParameterDecorator pd = BeaninfoFactory.eINSTANCE.createParameterDecorator();
            JavaParameter jp = (JavaParameter)p.get(i);
            pd.setName(jp.getName());
            pd.setImplicitlySetBits(1L);
            pd.setParameter(jp);
            parmsList.add((Object)pd);
            ++i;
        }
        return parmsList;
    }

    void initializeParameters() {
        if (this.serParmDesc == null) {
            return;
        }
        List mp = this.getMethodParameters();
        if (mp.isEmpty()) {
            return;
        }
        int psize = Math.min(this.serParmDesc.size(), mp.size());
        int i = 0;
        while (i < psize) {
            ((ParameterDecorator)this.serParmDesc.get(i)).setParameter((JavaParameter)mp.get(i));
            ++i;
        }
    }

    private List getMethodParameters() {
        Method m = null;
        EModelElement d = this.getEModelElement();
        if (d instanceof Method) {
            m = (Method)d;
        } else if (d instanceof MethodProxy) {
            m = ((MethodProxy)d).getMethod();
        } else {
            return Collections.EMPTY_LIST;
        }
        if (m == null) {
            return Collections.EMPTY_LIST;
        }
        EList p = m.getParameters();
        return p;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (parmsExplicitEmpty: ");
        result.append((this.eFlags & 0x40000) != 0);
        result.append(')');
        return result.toString();
    }

    public EList getParameterDescriptors() {
        if (!this.isParmsExplicitEmpty() && this.getSerParmDesc().isEmpty() && (this.getImplicitlySetBits() & 3L) == 0L) {
            this.createDefaultParmsList();
        }
        return this.getSerParmDesc();
    }

    public EList getParameterDescriptorsGen() {
        throw new UnsupportedOperationException();
    }

    public EList getSerParmDesc() {
        if (this.serParmDesc == null) {
            this.serParmDesc = new EObjectContainmentEList(ParameterDecorator.class, (InternalEObject)this, 19);
        }
        return this.serParmDesc;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 3: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 3, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return ((InternalEList)this.getDetails()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return this.eBasicSetContainer(null, 3, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
                }
                case 16: {
                    return ((InternalEList)this.getAttributes()).basicRemove((Object)otherEnd, msgs);
                }
                case 19: {
                    return ((InternalEList)this.getSerParmDesc()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 3: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 0, EModelElement.class, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getSource();
            }
            case 2: {
                return this.getDetails();
            }
            case 3: {
                return this.getEModelElement();
            }
            case 4: {
                return this.getContents();
            }
            case 5: {
                return this.getReferences();
            }
            case 6: {
                return this.getDisplayName();
            }
            case 7: {
                return this.getShortDescription();
            }
            case 8: {
                return this.getCategory();
            }
            case 9: {
                return this.isExpert() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return this.isHidden() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.isPreferred() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isMergeIntrospection() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isAttributesExplicitEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return new Long(this.getImplicitlySetBits());
            }
            case 15: {
                return this.getImplicitDecoratorFlag();
            }
            case 16: {
                return this.getAttributes();
            }
            case 17: {
                return this.isParmsExplicitEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return this.getParameterDescriptors();
            }
            case 19: {
                return this.getSerParmDesc();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setSource((String)newValue);
                return;
            }
            case 2: {
                this.getDetails().clear();
                this.getDetails().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setEModelElement((EModelElement)newValue);
                return;
            }
            case 4: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getReferences().clear();
                this.getReferences().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setDisplayName((String)newValue);
                return;
            }
            case 7: {
                this.setShortDescription((String)newValue);
                return;
            }
            case 8: {
                this.setCategory((String)newValue);
                return;
            }
            case 9: {
                this.setExpert((Boolean)newValue);
                return;
            }
            case 10: {
                this.setHidden((Boolean)newValue);
                return;
            }
            case 11: {
                this.setPreferred((Boolean)newValue);
                return;
            }
            case 12: {
                this.setMergeIntrospection((Boolean)newValue);
                return;
            }
            case 13: {
                this.setAttributesExplicitEmpty((Boolean)newValue);
                return;
            }
            case 14: {
                this.setImplicitlySetBits((Long)newValue);
                return;
            }
            case 15: {
                this.setImplicitDecoratorFlag((ImplicitItem)((Object)newValue));
                return;
            }
            case 16: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.setParmsExplicitEmpty((Boolean)newValue);
                return;
            }
            case 18: {
                this.getParameterDescriptors().clear();
                this.getParameterDescriptors().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.getSerParmDesc().clear();
                this.getSerParmDesc().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setSource(SOURCE_EDEFAULT);
                return;
            }
            case 2: {
                this.getDetails().clear();
                return;
            }
            case 3: {
                this.setEModelElement(null);
                return;
            }
            case 4: {
                this.getContents().clear();
                return;
            }
            case 5: {
                this.getReferences().clear();
                return;
            }
            case 6: {
                this.unsetDisplayName();
                return;
            }
            case 7: {
                this.unsetShortDescription();
                return;
            }
            case 8: {
                this.setCategory(CATEGORY_EDEFAULT);
                return;
            }
            case 9: {
                this.unsetExpert();
                return;
            }
            case 10: {
                this.unsetHidden();
                return;
            }
            case 11: {
                this.unsetPreferred();
                return;
            }
            case 12: {
                this.setMergeIntrospection(true);
                return;
            }
            case 13: {
                this.setAttributesExplicitEmpty(false);
                return;
            }
            case 14: {
                this.setImplicitlySetBits(0L);
                return;
            }
            case 15: {
                this.setImplicitDecoratorFlag(IMPLICIT_DECORATOR_FLAG_EDEFAULT);
                return;
            }
            case 16: {
                this.getAttributes().clear();
                return;
            }
            case 17: {
                this.setParmsExplicitEmpty(false);
                return;
            }
            case 18: {
                this.getParameterDescriptors().clear();
                return;
            }
            case 19: {
                this.getSerParmDesc().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 1: {
                return this.isSourceSet();
            }
            case 18: {
                return this.eIsSetGen((EStructuralFeature)BeaninfoPackage.eINSTANCE.getMethodDecorator_SerParmDesc());
            }
            case 19: {
                if ((this.getImplicitlySetBits() & 2L) != 0L) {
                    return false;
                }
                return this.eIsSetGen(eFeature);
            }
        }
        return this.eIsSetGen(eFeature);
    }

    public boolean eIsSetGen(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return SOURCE_EDEFAULT == null ? this.source != null : !SOURCE_EDEFAULT.equals(this.source);
            }
            case 2: {
                return this.details != null && !this.details.isEmpty();
            }
            case 3: {
                return this.getEModelElement() != null;
            }
            case 4: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 5: {
                return this.references != null && !this.references.isEmpty();
            }
            case 6: {
                return this.isSetDisplayName();
            }
            case 7: {
                return this.isSetShortDescription();
            }
            case 8: {
                return CATEGORY_EDEFAULT == null ? this.category != null : !CATEGORY_EDEFAULT.equals(this.category);
            }
            case 9: {
                return this.isSetExpert();
            }
            case 10: {
                return this.isSetHidden();
            }
            case 11: {
                return this.isSetPreferred();
            }
            case 12: {
                return (this.eFlags & 0x10000) == 0;
            }
            case 13: {
                return (this.eFlags & 0x20000) != 0;
            }
            case 14: {
                return this.implicitlySetBits != 0L;
            }
            case 15: {
                return this.implicitDecoratorFlag != IMPLICIT_DECORATOR_FLAG_EDEFAULT;
            }
            case 16: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
            case 17: {
                return (this.eFlags & 0x40000) != 0;
            }
            case 18: {
                return !this.getParameterDescriptors().isEmpty();
            }
            case 19: {
                return this.serParmDesc != null && !this.serParmDesc.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }
}

