/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript;

import java.util.Iterator;
import org.eclipse.wst.jsdt.web.core.javascript.Messages;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class NodeHelper {
    protected static final char DOUBLE_QUOTE_CHAR = '\"';
    protected static final String DOUBLE_QUOTE_ENTITY = "&quot;";
    protected static final char SINGLE_QUOTE_CHAR = '\'';
    protected static final String SINGLE_QUOTE_ENTITY = "&#039;";
    protected final IStructuredDocumentRegion region;

    public static boolean isInArray(String[] StringArray, String text) {
        if (StringArray == null || text == null) {
            return false;
        }
        int i = 0;
        while (i < StringArray.length) {
            if (StringArray[i].equalsIgnoreCase(text.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int lastIndex = string.length() - 1;
        char firstChar = string.charAt(0);
        char lastChar = string.charAt(lastIndex);
        return firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    public NodeHelper(IStructuredDocumentRegion region) {
        this.region = region;
    }

    public boolean attrEquals(String attribute, String value) {
        String attValue = this.getAttributeValue(attribute);
        if (attValue == null) {
            return false;
        }
        return attValue.equalsIgnoreCase(value);
    }

    public String AttrToString() {
        if (this.region == null) {
            return null;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        String StructuredValue = String.valueOf(Messages.getString("NodeHelper.0")) + this.getTagName() + Messages.getString("NodeHelper.1");
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int start = r.getStart();
            int offset = r.getTextEnd();
            StructuredValue = String.valueOf(StructuredValue) + "\t\t" + this.region.getText().substring(start, offset);
            if (regionIterator.hasNext()) {
                regionIterator.next();
            }
            if (regionIterator.hasNext()) {
                r = (ITextRegion)regionIterator.next();
            }
            System.out.println(Messages.getString("NodeHelper.3"));
            if (r.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int valStart = r.getStart();
            int valOffset = r.getTextEnd();
            StructuredValue = String.valueOf(StructuredValue) + "\t\t" + this.stripEndQuotes(this.region.getText().substring(valStart, valOffset)) + "\n";
        }
        return StructuredValue;
    }

    public boolean containsAttribute(String[] name) {
        if (name == null) {
            return false;
        }
        if (this.region == null) {
            return false;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int start = r.getStart();
            int offset = r.getTextEnd();
            String tagname = this.region.getText().substring(start, offset).trim();
            if (!NodeHelper.isInArray(name, tagname)) continue;
            return true;
        }
        return false;
    }

    public String getAttributeValue(String name) {
        if (this.region == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int start = r.getStart();
            int offset = r.getTextEnd();
            String tagname = this.region.getText().substring(start, offset).trim();
            if (!tagname.equalsIgnoreCase(name)) continue;
            if (regionIterator.hasNext()) {
                regionIterator.next();
            }
            if (regionIterator.hasNext()) {
                r = (ITextRegion)regionIterator.next();
            }
            if (r.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int valStart = r.getStart();
            int valOffset = r.getTextEnd();
            return this.stripEndQuotes(this.region.getText().substring(valStart, valOffset));
        }
        return null;
    }

    public String getElementAsFlatString() {
        if (this.region == null) {
            return null;
        }
        String fullRegionText = this.region.getFullText();
        if (fullRegionText == null) {
            return null;
        }
        return fullRegionText.replaceAll("[^a-zA-Z0-9]", "");
    }

    public String getTagName() {
        if (this.region == null) {
            return null;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_NAME") continue;
            int start = r.getStart();
            int offset = r.getTextEnd();
            return this.region.getText().substring(start, offset);
        }
        return null;
    }

    public boolean isEndTag() {
        if (this.region == null) {
            return false;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_END_TAG_OPEN") continue;
            return true;
        }
        return false;
    }

    public boolean isSelfClosingTag() {
        if (this.region == null) {
            return false;
        }
        if (this.region == null) {
            return false;
        }
        ITextRegionList regions = this.region.getRegions();
        ITextRegion r = regions.get(regions.size() - 1);
        return r.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    public boolean nameEquals(String name) {
        if (this.region == null) {
            return false;
        }
        String tagName = this.getTagName();
        return tagName != null && tagName.equalsIgnoreCase(name);
    }

    public String stripEndQuotes(String text) {
        if (text == null) {
            return null;
        }
        if (NodeHelper.isQuoted(text)) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public String toString() {
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        String nodeText = new String();
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            String nodeType = r.getType();
            nodeText = String.valueOf(nodeText) + Messages.getString("NodeHelper.11") + nodeType + Messages.getString("NodeHelper.12") + this.region.getText().substring(r.getStart(), r.getTextEnd()) + "\n";
        }
        return nodeText;
    }
}

