/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.policy;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyPlatformImpl;
import org.eclipse.wst.ws.service.policy.IFilter;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyChildChangeListener;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyPlatformProjectLoadListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePolicyPlatform {
    private static ServicePolicyPlatform instance;
    private ServicePolicyPlatformImpl platformImpl = new ServicePolicyPlatformImpl();

    private ServicePolicyPlatform() {
    }

    public static ServicePolicyPlatform getInstance() {
        if (instance == null) {
            instance = new ServicePolicyPlatform();
            ServicePolicyPlatform.instance.platformImpl.load();
        }
        return instance;
    }

    public boolean isEnabled(Object object) {
        return this.platformImpl.isEnabled(object);
    }

    public void commitChanges() {
        this.platformImpl.commitChanges(true);
    }

    public void discardChanges() {
        this.platformImpl.discardChanges();
    }

    public void commitChanges(IProject project) {
        this.platformImpl.commitChanges(project);
    }

    public void discardChanges(IProject project) {
        this.platformImpl.discardChanges(project);
    }

    public Set<String> getAllPolicyIds() {
        return this.platformImpl.getAllPolicyIds();
    }

    public List<IServicePolicy> getRootServicePolicies(IFilter filter) {
        return this.platformImpl.getRootServicePolicies(filter);
    }

    public IServicePolicy getServicePolicy(String id) {
        return this.platformImpl.getServicePolicy(id);
    }

    public boolean isProjectPreferencesEnabled(IProject project) {
        return this.platformImpl.isProjectPreferencesEnabled(project);
    }

    public void setProjectPreferencesEnabled(IProject project, boolean value) {
        this.platformImpl.setProjectPreferencesEnabled(project, value);
    }

    public void restoreDefaults() {
        this.platformImpl.restoreDefaults();
    }

    public void restoreDefaults(IProject project) {
        this.platformImpl.restoreDefaults(project);
    }

    public IServicePolicy createServicePolicy(IServicePolicy parent, String id, String enumListId, String defaultEnumId) {
        return this.platformImpl.createServicePolicy(parent, id, enumListId, defaultEnumId);
    }

    public void removeServicePolicy(IServicePolicy policy) {
        this.platformImpl.removePlatformPolicy(policy);
    }

    public void addChildChangeListener(IPolicyChildChangeListener listener, boolean onCommit) {
        this.platformImpl.addChildChangeListener(listener, onCommit);
    }

    public void queueChildChangeListeners(boolean queue) {
        this.platformImpl.queueChildChangeListeners(queue);
    }

    public void removeChildChangeListener(IPolicyChildChangeListener listener, boolean onCommit) {
        this.platformImpl.removeChildChangeListener(listener, onCommit);
    }

    public void addProjectLoadListener(IPolicyPlatformProjectLoadListener listener) {
        this.platformImpl.addProjectLoadListener(listener);
    }

    public void removeProjectLoadListener(IPolicyPlatformProjectLoadListener listener) {
        this.platformImpl.removeProjectLoadListener(listener);
    }

    public List<IStateEnumerationItem> getStateEnumeration(String enumId) {
        return this.platformImpl.getStateEnumeration(enumId);
    }

    public IStateEnumerationItem getStateItemEnumeration(String stateItemId) {
        return this.platformImpl.getStateItemEnumeration(stateItemId);
    }
}

