/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;

public class ValOperationJob
extends Job {
    private ValOperation _operation;

    public ValOperationJob(ValOperation operation) {
        super(ValMessages.JobNameMonitor);
        this._operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean ok = true;
        try {
            ValidationFramework.getDefault().join(monitor);
        }
        catch (InterruptedException interruptedException) {
            ok = false;
        }
        this.finished(monitor);
        return ok ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private void finished(IProgressMonitor monitor) {
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.validationFinishing(project, operation.getState(), monitor);
            }
        };
        ValManager.getDefault().accept(visitor, null, ValType.Build, this._operation, monitor);
    }
}

