/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.wizards;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.ui.internal.UIPlugin;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentWSISSBPContext;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLFactoryImpl;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;
import org.eclipse.wst.wsdl.ui.internal.wizards.WSDLNewFileOptionsPage;
import org.eclipse.wst.wsdl.ui.internal.wizards.WSDLNewFilePage;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.DOMValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.w3c.dom.Element;

public class NewWSDLWizard
extends Wizard
implements INewWizard {
    private WSDLNewFilePage newFilePage;
    private WSDLNewFileOptionsPage optionsPage;
    private IStructuredSelection selection;
    private BindingGenerator generator = new BindingGenerator(null, null);
    private boolean fOpenEditorWhenFinished = true;
    private IFile fNewFile = null;
    static /* synthetic */ Class class$0;

    public NewWSDLWizard() {
    }

    public NewWSDLWizard(boolean openEditorWhenFinished) {
        this();
        this.fOpenEditorWhenFinished = openEditorWhenFinished;
    }

    public boolean performFinish() {
        this.fNewFile = this.newFilePage.createNewFile();
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        if (charSet == null || charSet.trim().equals("")) {
            charSet = "UTF-8";
        }
        String wsdlPrefix = "wsdl";
        Vector namespaces = this.optionsPage.getNamespaceInfo();
        String prefix = this.optionsPage.getPrefix();
        String definitionName = this.optionsPage.getDefinitionName();
        URI uri2 = URI.createPlatformResourceURI((String)this.fNewFile.getFullPath().toOSString(), (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        WSDLResourceImpl resource = (WSDLResourceImpl)resourceSet.createResource(URI.createURI((String)"*.wsdl"));
        resource.setURI(uri2);
        WSDLFactoryImpl factory = new WSDLFactoryImpl();
        DefinitionImpl definition = (DefinitionImpl)factory.createDefinition();
        resource.getContents().add((Object)definition);
        definition.setTargetNamespace(this.optionsPage.getTargetNamespace());
        definition.setLocation(this.fNewFile.getLocation().toString());
        definition.setEncoding(charSet);
        definition.setQName(new QName(wsdlPrefix, definitionName));
        definition.addNamespace(prefix, this.optionsPage.getTargetNamespace());
        int i = 0;
        while (i < namespaces.size()) {
            NamespaceInfo info = (NamespaceInfo)namespaces.get(i);
            if (info.prefix.length() > 0) {
                definition.addNamespace(info.prefix, info.uri);
            } else {
                definition.addNamespace(null, info.uri);
            }
            ++i;
        }
        definition.updateElement(true);
        try {
            if (this.optionsPage.getCreateSkeletonBoolean()) {
                CreateWSDLElementHelper.PART_TYPE_OR_DEFINITION = this.optionsPage.isSoapDocLiteralProtocol() ? "ELEMENT_DECLARATION" : "TYPE_DEFINITION";
                CreateWSDLElementHelper.serviceName = definitionName;
                CreateWSDLElementHelper.portName = String.valueOf(definitionName) + this.optionsPage.getProtocol();
                Service service = CreateWSDLElementHelper.createService((Definition)definition);
                Iterator bindingIt = definition.getEBindings().iterator();
                Binding binding = null;
                if (bindingIt.hasNext()) {
                    binding = (Binding)bindingIt.next();
                }
                this.generator.setDefinition((Definition)definition);
                this.generator.setBinding(binding);
                Port port = (Port)service.getEPorts().iterator().next();
                this.generator.setName(ComponentReferenceUtil.getName(port.getEBinding()));
                this.generator.setRefName(ComponentReferenceUtil.getPortTypeReference(port.getEBinding()));
                this.generator.setOverwrite(true);
                this.generator.generateBinding();
                this.generator.generatePortContent();
            }
            resource.save(null);
        }
        catch (Exception e) {
            System.out.println("\nCould not write new WSDL file in WSDL Wizard: " + e);
        }
        if (this.fOpenEditorWhenFinished) {
            NewWSDLWizard.openEditor(this.fNewFile);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.ui.internal.InternalWSDLMultiPageEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/new_wsdl_wiz.png"));
        this.setWindowTitle(Messages._UI_TITLE_NEW_WSDL_FILE);
    }

    public void addPages() {
        this.newFilePage = new WSDLNewFilePage(this.selection);
        this.optionsPage = new WSDLNewFileOptionsPage(Messages._UI_TITLE_OPTIONS, Messages._UI_TITLE_OPTIONS, null, this.newFilePage);
        this.optionsPage.setBindingGenerator(this.generator);
        this.addPage((IWizardPage)this.newFilePage);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public IPath getNewFilePath() {
        String fileName = this.newFilePage.getFileName();
        return fileName != null ? new Path(fileName) : null;
    }

    public IFile getNewFile() {
        return this.fNewFile;
    }

    public boolean canFinish() {
        return this.newFilePage.isPageComplete() && this.optionsPage.isPageComplete();
    }

    public static void openEditor(final IFile iFile) {
        if (iFile != null) {
            IWorkbench workbench = UIPlugin.getDefault().getWorkbench();
            final IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        String editorId = null;
                        IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getLocation().toOSString(), iFile.getContentDescription().getContentType());
                        if (editor != null) {
                            editorId = editor.getId();
                        }
                        workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(iFile), editorId);
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (CoreException coreException) {}
                }
            });
        }
    }

    public void openProjectWSIProperties() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getFile(this.newFilePage.getContainerFullPath().append(this.newFilePage.getFileName())).getProject();
        PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)targetProject, (String)"org.eclipse.wst.ws.internal.ui.wsi.properties.WSICompliancePropertyPage", (String[])new String[]{"org.eclipse.wst.ws.internal.ui.wsi.properties.WSICompliancePropertyPage"}, null).open();
    }

    public String getWSIPreferences() {
        IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getFile(this.newFilePage.getContainerFullPath().append(this.newFilePage.getFileName())).getProject();
        PersistentWSISSBPContext WSISSBcontext = WSPlugin.getInstance().getWSISSBPContext();
        if (WSISSBcontext.projectStopNonWSICompliances(targetProject)) {
            return "0";
        }
        if (WSISSBcontext.projectWarnNonWSICompliances(targetProject)) {
            return "1";
        }
        return "2";
    }

    public class AvailableContentCMVisitor
    extends CMVisitor {
        public static final int INCLUDE_ATTRIBUTES = 1;
        public static final int INCLUDE_CHILD_NODES = 2;
        public static final int INCLUDE_SEQUENCE_GROUPS = 4;
        public Hashtable childNodeTable = new Hashtable();
        public Hashtable attributeTable = new Hashtable();
        public Element rootElement;
        public CMElementDeclaration rootElementDeclaration;
        public boolean isRootVisited;
        protected boolean includeSequenceGroups;
        public DOMValidator validator;

        public AvailableContentCMVisitor(Element rootElement, CMElementDeclaration rootElementDeclaration) {
            this.rootElement = rootElement;
            this.rootElementDeclaration = rootElementDeclaration;
            this.validator = new DOMValidator();
        }

        protected String getKey(CMNode cmNode) {
            String namespaceURI;
            String key = cmNode.getNodeName();
            CMDocument cmDocument = (CMDocument)cmNode.getProperty("CMDocument");
            if (cmDocument != null && (namespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI")) != null) {
                key = "[" + namespaceURI + "]" + key;
            }
            return key;
        }

        public List computeAvailableContent(int includeOptions) {
            Vector<Object> v = new Vector<Object>();
            int contentType = this.rootElementDeclaration.getContentType();
            this.includeSequenceGroups = (includeOptions & 4) != 0;
            this.visitCMNode((CMNode)this.rootElementDeclaration);
            if ((includeOptions & 1) != 0) {
                v.addAll(this.attributeTable.values());
                CMAttributeDeclaration nillableAttribute = (CMAttributeDeclaration)this.rootElementDeclaration.getProperty("http://org.eclipse.wst/cm/properties/nillable");
                if (nillableAttribute != null) {
                    v.add(nillableAttribute);
                }
            }
            if ((includeOptions & 2) != 0) {
                CMDataType dataType;
                CMDocument cmDocument;
                if (contentType == 3 || contentType == 2) {
                    v.addAll(this.childNodeTable.values());
                } else if (contentType == 0 && (cmDocument = (CMDocument)this.rootElementDeclaration.getProperty("CMDocument")) != null) {
                    CMNamedNodeMap elements = cmDocument.getElements();
                    Iterator i = elements.iterator();
                    while (i.hasNext()) {
                        v.add((CMElementDeclaration)i.next());
                    }
                }
                if ((contentType == 3 || contentType == 4 || contentType == 0) && (dataType = this.rootElementDeclaration.getDataType()) != null) {
                    v.add(dataType);
                }
            }
            return v;
        }

        public void visitCMAttributeDeclaration(CMAttributeDeclaration ad) {
            super.visitCMAttributeDeclaration(ad);
            this.attributeTable.put(ad.getNodeName(), ad);
        }

        public void visitCMElementDeclaration(CMElementDeclaration ed) {
            if (ed == this.rootElementDeclaration && !this.isRootVisited) {
                this.isRootVisited = true;
                super.visitCMElementDeclaration(ed);
            } else {
                CMNodeList substitutionGroup;
                if (!Boolean.TRUE.equals(ed.getProperty("Abstract"))) {
                    this.childNodeTable.put(this.getKey((CMNode)ed), ed);
                }
                if ((substitutionGroup = (CMNodeList)ed.getProperty("SubstitutionGroup")) != null) {
                    this.handleSubstitutionGroup(substitutionGroup);
                }
            }
        }

        protected void handleSubstitutionGroup(CMNodeList substitutionGroup) {
            int substitutionGroupLength = substitutionGroup.getLength();
            if (substitutionGroupLength > 1) {
                int i = 0;
                while (i < substitutionGroupLength) {
                    CMNode ed = substitutionGroup.item(i);
                    if (!Boolean.TRUE.equals(ed.getProperty("Abstract"))) {
                        this.childNodeTable.put(this.getKey(ed), ed);
                    }
                    ++i;
                }
            }
        }

        public void visitCMGroup(CMGroup group) {
            if (this.includeSequenceGroups && group.getOperator() == 1 && group.getChildNodes().getLength() > 1 && this.includesRequiredContent(group)) {
                this.childNodeTable.put(group, group);
            }
            super.visitCMGroup(group);
        }

        public boolean includesRequiredContent(CMGroup group) {
            List list = this.getValidator().createContentSpecificationList((CMNode)group);
            return list.size() > 1;
        }

        public DOMValidator getValidator() {
            return this.validator;
        }
    }
}

