/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DefaultUnknownTagConverter
extends AbstractTagConverter {
    public DefaultUnknownTagConverter(Element host, int mode) {
        super(host);
        this.setMode(mode);
    }

    protected Element doConvertRefresh() {
        Element hostEle = this.getHostElement();
        Element divEle = this.createElement("div");
        String style = DOMUtil.getAttributeIgnoreCase(hostEle, "style");
        if (style == null) {
            style = "";
        }
        if (style.length() > 0 && !style.endsWith(";")) {
            style = String.valueOf(style) + ";";
        }
        style = String.valueOf(style) + "border: none; padding: 0; margin: 0";
        divEle.setAttribute("style", style);
        Element div2 = this.createElement("span");
        String border = this.isPreviewMode() ? "border-style: solid;border-width: 1px" : "border:none";
        div2.setAttribute("style", "background-color: white;" + border + ";color:gray");
        Text txt = this.createText(hostEle.getTagName());
        div2.appendChild(txt);
        divEle.appendChild(div2);
        Element div3 = this.createElement("div");
        div3.setAttribute("style", "margin: 0; padding: 0");
        divEle.appendChild(div3);
        this.copyChildren(this.getHostElement(), div3);
        return divEle;
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return false;
    }

    public boolean needBorderDecorator() {
        return true;
    }
}

