/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.meta.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.meta.AttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.internal.CategoryNameComparator;
import org.eclipse.jst.pagedesigner.meta.internal.ElementDescriptor;
import org.eclipse.jst.pagedesigner.meta.internal.LocaleFallback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ElementDescReader {
    private static Logger _log = PDPlugin.getLogger(ElementDescReader.class);
    private Map _definedCategoryMap = new HashMap();
    private Map _definedAttributeMap = new HashMap();
    private URL _url;
    private String[] _optimizedLocales = null;

    public ElementDescReader(URL url) {
        this._url = url;
    }

    public void readElements(Map map) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputStream stream = null;
        Document doc = null;
        try {
            stream = this._url.openStream();
            doc = builder.parse(stream);
        }
        finally {
            ResourceUtils.ensureClosed((InputStream)stream);
        }
        Element taglib = doc.getDocumentElement();
        String nameSpace = taglib.getAttribute("uri");
        NodeList list = doc.getElementsByTagName("tag");
        if (list != null && list.getLength() != 0) {
            int size = list.getLength();
            int i = 0;
            while (i < size) {
                Element tag = (Element)list.item(i);
                ElementDescriptor desc = new ElementDescriptor();
                desc.setTagName(tag.getAttribute("name"));
                desc.setNamespaceURI(nameSpace);
                desc.setHelpContextID(tag.getAttribute("helpContextId"));
                NodeList children = tag.getChildNodes();
                NodeList cateNodes = tag.getElementsByTagName("category");
                NodeList referedCateNodes = tag.getElementsByTagName("referedcategory");
                int cateNum = 0;
                if (cateNodes != null) {
                    cateNum += cateNodes.getLength();
                }
                if (referedCateNodes != null) {
                    cateNum += referedCateNodes.getLength();
                }
                if (cateNum > 0) {
                    int length = children.getLength();
                    String[] cates = new String[cateNum];
                    ArrayList attrList = new ArrayList();
                    int realCate = 0;
                    int j = 0;
                    while (j < length) {
                        Element element;
                        String tagName;
                        Node node = children.item(j);
                        if (node.getNodeType() == 1 && ("category".equals(tagName = (element = (Element)node).getTagName()) || "referedcategory".equals(tagName))) {
                            String categoryName = element.getAttribute("name");
                            if (categoryName != null && !"".equals(categoryName)) {
                                cates[realCate++] = categoryName;
                                this.parseCategory(element, element, attrList);
                            } else {
                                Element definedCategory = this.handleReference(doc, element, true);
                                String labelKey = definedCategory.getAttribute("displaylabel");
                                cates[realCate++] = labelKey != null && !"".equals(labelKey) ? this.getValue(labelKey) : this.calculateDisplayLabel(definedCategory);
                                this.parseCategory(element, definedCategory, attrList);
                            }
                        }
                        ++j;
                    }
                    int m = 0;
                    int len = cates.length;
                    while (m < len) {
                        int j2 = m + 1;
                        while (j2 < len) {
                            CategoryNameComparator.addPair(cates[m], cates[j2]);
                            ++j2;
                        }
                        ++m;
                    }
                    desc.setAttributeDescriptors(attrList);
                }
                map.put(desc.getTagName(), desc);
                ++i;
            }
        }
    }

    private String calculateDisplayLabel(Element definedElement) {
        String label = definedElement.getAttribute("displaylabel");
        return this.getValue(label);
    }

    private void parseCategory(Element category, Element definedCategory, List attrList) {
        NodeList excludes;
        String labelKey;
        String cateLabel = this.calculateDisplayLabel(definedCategory);
        if (category != definedCategory && (labelKey = category.getAttribute("displaylabel")) != null && !"".equals(labelKey)) {
            cateLabel = this.getValue(labelKey);
        }
        this.handleAttributes(definedCategory, cateLabel, attrList);
        if (category == definedCategory) {
            return;
        }
        NodeList includes = category.getElementsByTagName("includeattrs");
        if (includes != null && includes.getLength() != 0) {
            int mapSize;
            Element includeAttrsTag = (Element)includes.item(0);
            this.handleAttributes(includeAttrsTag, cateLabel, attrList);
            HashMap<String, AttributeDescriptor> tempMap = new HashMap<String, AttributeDescriptor>();
            for (AttributeDescriptor adp : attrList) {
                tempMap.put(adp.getAttributeName(), adp);
            }
            int listSize = attrList.size();
            if (listSize != (mapSize = tempMap.size())) {
                attrList.clear();
                Set set = tempMap.keySet();
                for (String atName : set) {
                    AttributeDescriptor ad = (AttributeDescriptor)tempMap.get(atName);
                    attrList.add(ad);
                }
            }
        }
        if ((excludes = category.getElementsByTagName("excludeattrs")) != null && excludes.getLength() != 0) {
            String displayNames = ((Element)excludes.item(0)).getAttribute("refs");
            StringTokenizer tokenizer = new StringTokenizer(displayNames, ", ");
            block2: while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                for (IAttributeDescriptor atr : attrList) {
                    String atrName = atr.getAttributeName();
                    if (!name.equals(atrName)) continue;
                    attrList.remove(atr);
                    continue block2;
                }
            }
        }
    }

    private void handleAttributes(Element root, String cateLabel, List attrList) {
        NodeList allNodes = root.getChildNodes();
        NodeList attrNodes = root.getElementsByTagName("attribute");
        NodeList referedattrNodes = root.getElementsByTagName("referedattribute");
        int attrNum = 0;
        if (attrNodes != null) {
            attrNum += attrNodes.getLength();
        }
        if (referedattrNodes != null) {
            attrNum += referedattrNodes.getLength();
        }
        if (attrNum > 0) {
            int incAttrLength = allNodes.getLength();
            int i = 0;
            while (i < incAttrLength) {
                Element incAttr;
                String tagName;
                Node node = allNodes.item(i);
                if (node.getNodeType() == 1 && ("attribute".equals(tagName = (incAttr = (Element)node).getTagName()) || "referedattribute".equals(tagName))) {
                    String ovDisplayLabel;
                    String incAtrName = incAttr.getAttribute("name");
                    Element refAttr = incAttr;
                    if (incAtrName == null || "".equals(incAtrName)) {
                        incAttr = this.handleReference(root.getOwnerDocument(), incAttr, false);
                    }
                    AttributeDescriptor attrDesc = this.parseAttribute(cateLabel, incAttr);
                    String overrideName = refAttr.getAttribute("overridename");
                    if (overrideName != null && !"".equalsIgnoreCase(overrideName)) {
                        attrDesc.setAttributeName(overrideName);
                    }
                    if ((ovDisplayLabel = refAttr.getAttribute("displaylabel")) != null && !"".equalsIgnoreCase(ovDisplayLabel)) {
                        attrDesc.setLabelString(this.getValue(ovDisplayLabel));
                    }
                    attrList.add(attrDesc);
                }
                ++i;
            }
        }
    }

    private Element handleReference(Document doc, Element refElment, boolean isCategory) {
        Element firstCate;
        NodeList defineCates;
        String refName = refElment.getAttribute("ref");
        if (isCategory) {
            if (this._definedCategoryMap.get(refName) != null) {
                Element definedCategory = (Element)this._definedCategoryMap.get(refName);
                return definedCategory;
            }
        } else if (this._definedAttributeMap.get(refName) != null) {
            Element definedAttribute = (Element)this._definedAttributeMap.get(refName);
            return definedAttribute;
        }
        NodeList catgs = null;
        if (isCategory) {
            defineCates = doc.getElementsByTagName("categories");
            firstCate = (Element)defineCates.item(0);
            catgs = firstCate.getElementsByTagName("category");
        } else {
            defineCates = doc.getElementsByTagName("attributes");
            firstCate = (Element)defineCates.item(0);
            catgs = firstCate.getElementsByTagName("attribute");
        }
        int cateLen = catgs.getLength();
        Element definedElement = null;
        int n = 0;
        while (n < cateLen) {
            String cateName = ((Element)catgs.item(n)).getAttribute("name");
            if (refName.equals(cateName) && !"".equals(refName)) {
                definedElement = (Element)catgs.item(n);
                break;
            }
            ++n;
        }
        if (isCategory) {
            this._definedCategoryMap.put(refName, definedElement);
        } else {
            this._definedAttributeMap.put(refName, definedElement);
        }
        return definedElement;
    }

    private AttributeDescriptor parseAttribute(String categoryName, Element attribute) {
        AttributeDescriptor attrDesc = new AttributeDescriptor();
        attrDesc.setCategory(categoryName);
        attrDesc.setAttributeName(attribute.getAttribute("name"));
        attrDesc.setDescription(attribute.getAttribute("description"));
        attrDesc.setValueType(attribute.getAttribute("type"));
        attrDesc.setRequired(attribute.hasAttribute("required"));
        attrDesc.setTypeParameter(attribute.getAttribute("typeparam"));
        String labelKey = attribute.getAttribute("displaylabel");
        attrDesc.setLabelString(this.getValue(labelKey));
        NodeList optionNodes = attribute.getElementsByTagName("option");
        if (optionNodes != null && optionNodes.getLength() != 0) {
            HashMap<String, String> optionMap = new HashMap<String, String>();
            int opLength = optionNodes.getLength();
            String defaultValue = null;
            int m = 0;
            while (m < opLength) {
                Element optNode = (Element)optionNodes.item(m);
                String key = optNode.getAttribute("key");
                String value = optNode.getAttribute("value");
                if (value == null || value.length() == 0) {
                    value = key;
                }
                if (optNode.hasAttribute("default")) {
                    defaultValue = value;
                }
                optionMap.put(key, value);
                ++m;
            }
            attrDesc.setOptions(optionMap, defaultValue);
        }
        return attrDesc;
    }

    private String getValue(String key) {
        if (key != null && key.startsWith("%")) {
            String[] localeOptions;
            String cmStr = this._url.toString();
            String propBaseStr = cmStr.substring(0, cmStr.lastIndexOf("."));
            String[] options = localeOptions = LocaleFallback.fallBack(Locale.getDefault());
            if (this._optimizedLocales != null) {
                options = this._optimizedLocales;
            }
            int i = 0;
            int size = options.length;
            while (i < size) {
                block9: {
                    StringBuffer sb = new StringBuffer();
                    sb.append(propBaseStr);
                    sb.append(options[i]);
                    sb.append(".properties");
                    String str = sb.toString();
                    PropertyResourceBundle rb = null;
                    try {
                        URL propUrl = new URL(str);
                        rb = new PropertyResourceBundle(propUrl.openStream());
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    if (this._optimizedLocales == null) {
                        this.setOptimizedLocales(localeOptions, i);
                    }
                    String rbKey = key.substring(1);
                    String value = null;
                    try {
                        value = rb.getString(rbKey);
                    }
                    catch (Exception exception) {
                        _log.info("Info.ElementDescReader.ReadPropertyFile.Key", rbKey, str, null);
                        break block9;
                    }
                    if (value != null) {
                        return value;
                    }
                }
                ++i;
            }
            return null;
        }
        return key;
    }

    private void setOptimizedLocales(String[] originalLocales, int startPoint) {
        int size = originalLocales.length - startPoint;
        this._optimizedLocales = new String[size];
        int i = 0;
        while (i < size) {
            this._optimizedLocales[i] = originalLocales[i + startPoint];
            ++i;
        }
    }
}

