/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets.runtime;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.DefaultingUtils;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.ProjectTopologyContext;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ClientRuntimeSelectionWidgetDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.FacetMatchCache;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.WSUIPluginMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerRuntimeSelectionWidgetDefaultingCommand
extends ClientRuntimeSelectionWidgetDefaultingCommand {
    private boolean generateProxy_ = true;
    private TypeRuntimeServer serviceIds_;
    private boolean serviceIdsFixed_ = false;
    private String serviceRuntimeId_;
    private String serviceProjectName_;
    private String serviceEarProjectName_;
    private String serviceComponentType_;
    private IProject initialProject_;
    private boolean serviceNeedEAR_ = true;
    private FacetMatcher serviceFacetMatcher_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        try {
            IStatus serverStatus;
            IProject serviceProject;
            ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet drt;
            if (this.serviceIdsFixed_) {
                if (this.serviceProjectName_ != null) {
                    this.initialProject_ = ResourcesPlugin.getWorkspace().getRoot().getProject(this.serviceProjectName_);
                    drt = this.getDefaultRuntime(this.initialProject_, this.serviceIds_.getTypeId(), false, this.serviceIds_.getServerId());
                    this.serviceFacetMatcher_ = drt.getFacetMatcher();
                    this.serviceProjectName_ = drt.getProjectName();
                    this.serviceRuntimeId_ = drt.getRuntimeId();
                    if (this.serviceRuntimeId_ != null) {
                        this.serviceIds_.setRuntimeId(WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_).getRuntime().getId());
                    }
                } else {
                    drt = this.getDefaultServiceRuntimeForFixedRuntimeAndServer(this.initialProject_, this.serviceIds_.getServerId());
                    this.serviceFacetMatcher_ = drt.getFacetMatcher();
                    this.serviceProjectName_ = drt.getProjectName();
                    this.serviceRuntimeId_ = drt.getRuntimeId();
                }
            } else {
                drt = this.getDefaultRuntime(this.initialProject_, this.serviceIds_.getTypeId(), false, this.serviceIds_.getServerId());
                this.serviceFacetMatcher_ = drt.getFacetMatcher();
                this.serviceProjectName_ = drt.getProjectName();
                this.serviceRuntimeId_ = drt.getRuntimeId();
                if (this.serviceRuntimeId_ != null) {
                    this.serviceIds_.setRuntimeId(WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_).getRuntime().getId());
                }
            }
            if (this.serviceProjectName_ == null) {
                this.serviceProjectName_ = this.getDefaultServiceProjectName();
            }
            this.serviceComponentType_ = !(serviceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.serviceProjectName_)).exists() ? this.getDefaultServiceProjectTemplate() : "";
            if (!this.serviceIdsFixed_ && (serverStatus = this.setServiceDefaultServer()).getSeverity() == 4) {
                env.getStatusHandler().reportError(serverStatus);
                return serverStatus;
            }
            this.setDefaultServiceEarProject();
            IStatus clientSideStatus = this.defaultClientSide(monitor);
            if (clientSideStatus.getSeverity() == 4) {
                return clientSideStatus;
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Object[])new String[]{e.getMessage()}), (Throwable)e);
            if (e.getMessage() == null) {
                ILog pluginlog = WebServiceConsumptionUIPlugin.getInstance().getLog();
                pluginlog.log(errorStatus);
                errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Object[])new String[]{WSUIPluginMessages.MSG_SEE_ERROR_LOG}), (Throwable)e);
            }
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
    }

    private IStatus defaultClientSide(IProgressMonitor monitor) {
        IStatus clientDefaultFromServiceStatus = this.defaultClientSideFromServiceSide(this.serviceProjectName_, this.serviceIds_, this.serviceNeedEAR_, this.serviceEarProjectName_);
        if (clientDefaultFromServiceStatus.getSeverity() == 4) {
            IProject clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClientProjectName());
            this.setClientInitialProject(clientProject);
            IStatus clientExecuteStatus = super.execute(monitor, null);
            if (clientExecuteStatus.getSeverity() == 4) {
                return clientExecuteStatus;
            }
            if (this.serviceNeedEAR_) {
                this.defaultClientEarFromServiceEar(this.serviceProjectName_, this.serviceEarProjectName_);
            }
        }
        return Status.OK_STATUS;
    }

    private void setDefaultServiceEarProject() {
        IProject serviceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.serviceProjectName_);
        if (serviceProject.exists()) {
            this.serviceNeedEAR_ = !FacetUtils.isJavaProject((IProject)serviceProject);
        } else {
            boolean bl = this.serviceNeedEAR_ = !FacetUtils.isUtilityTemplate((String)this.serviceComponentType_);
        }
        if (this.serviceNeedEAR_) {
            String serverId = this.serviceIds_.getServerId();
            if (serverId != null) {
                String serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverId);
                if (serverTargetId != null && serverTargetId.length() > 0 && !ServerUtils.isTargetValidForEAR((String)serverTargetId, (String)"13")) {
                    this.serviceNeedEAR_ = false;
                }
            } else {
                this.serviceNeedEAR_ = false;
            }
        }
        this.serviceEarProjectName_ = this.serviceNeedEAR_ ? DefaultingUtils.getDefaultEARProjectName((String)this.serviceProjectName_) : "";
    }

    private IStatus setServiceDefaultServer() {
        IServerType serverType;
        IServer server;
        IProject serviceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.serviceProjectName_);
        IServer[] configuredServers = null;
        if (serviceProject.exists()) {
            configuredServers = ServerUtil.getServersByModule((IModule)ServerUtils.getModule((IProject)serviceProject), null);
        }
        if (configuredServers != null && configuredServers.length > 0) {
            this.serviceIds_.setServerId(configuredServers[0].getServerType().getId());
            this.serviceIds_.setServerInstanceId(configuredServers[0].getId());
            return Status.OK_STATUS;
        }
        if (serviceProject.exists()) {
            server = this.getServerFromProject(this.serviceProjectName_, this.serviceFacetMatcher_);
            if (server != null) {
                this.serviceIds_.setServerId(server.getServerType().getId());
                this.serviceIds_.setServerInstanceId(server.getId());
                return Status.OK_STATUS;
            }
            serverType = this.getServerTypeFromProject(this.serviceProjectName_, this.serviceFacetMatcher_);
            if (serverType != null) {
                this.serviceIds_.setServerId(serverType.getId());
                return Status.OK_STATUS;
            }
        }
        if ((server = this.getServerFromServiceRuntimeId()) != null) {
            this.serviceIds_.setServerId(server.getServerType().getId());
            this.serviceIds_.setServerInstanceId(server.getId());
            return Status.OK_STATUS;
        }
        serverType = this.getServerTypeFromServiceRuntimeId();
        if (serverType != null) {
            this.serviceIds_.setServerId(serverType.getId());
            return Status.OK_STATUS;
        }
        RuntimeDescriptor runtimeDescriptor = WebServiceRuntimeExtensionUtils2.getRuntimeById((String)this.serviceIds_.getRuntimeId());
        if (runtimeDescriptor.getServerRequired()) {
            String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById((String)this.serviceIds_.getRuntimeId());
            IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_NO_SERVER_RUNTIME, (Object[])new String[]{runtimeLabel}));
            return status;
        }
        return Status.OK_STATUS;
    }

    private IServer getServerFromServiceRuntimeId() {
        IServer[] servers = ServerCore.getServers();
        if (servers != null && servers.length > 0) {
            String serverFactoryId;
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String preferredServerFactoryId = context.getServerFactoryId();
            int j = 0;
            while (j < servers.length) {
                if (servers[j] != null && servers[j].getServerType() != null && (serverFactoryId = servers[j].getServerType().getId()).equals(preferredServerFactoryId) && WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer((String)this.serviceRuntimeId_, (String)serverFactoryId)) {
                    return servers[j];
                }
                ++j;
            }
            int i = 0;
            while (i < servers.length) {
                if (servers[i] != null && servers[i].getServerType() != null && WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer((String)this.serviceRuntimeId_, (String)(serverFactoryId = servers[i].getServerType().getId()))) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    private IServerType getServerTypeFromServiceRuntimeId() {
        String[] serverTypes = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceRuntime((String)this.serviceRuntimeId_);
        if (serverTypes != null && serverTypes.length > 0) {
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String preferredServerFactoryId = context.getServerFactoryId();
            int i = 0;
            while (i < serverTypes.length) {
                if (serverTypes[i].equals(preferredServerFactoryId)) {
                    return ServerCore.findServerType((String)serverTypes[i]);
                }
                ++i;
            }
            return ServerCore.findServerType((String)serverTypes[0]);
        }
        return null;
    }

    private String getDefaultServiceProjectTemplate() {
        String[] templates = WebServiceRuntimeExtensionUtils2.getServiceProjectTemplates((String)this.serviceIds_.getTypeId(), (String)this.serviceIds_.getRuntimeId());
        ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
        String[] preferredTemplateIds = ptc.getServiceTypes();
        int j = 0;
        while (j < preferredTemplateIds.length) {
            int i = 0;
            while (i < templates.length) {
                boolean matches;
                String templateId = templates[i];
                if (templateId.equals(preferredTemplateIds[j]) && (matches = WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportTemplate((String)this.serviceRuntimeId_, (String)templateId))) {
                    return templates[i];
                }
                ++i;
            }
            ++j;
        }
        if (templates.length > 0) {
            return templates[0];
        }
        return "";
    }

    private String getDefaultServiceProjectName() {
        IProject[] projects = FacetUtils.getAllProjects();
        ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_);
        RequiredFacetVersion[] rfvs = desc.getRequiredFacetVersions();
        int i = 0;
        while (i < projects.length) {
            Set facetVersions = FacetUtils.getFacetsForProject((String)projects[i].getName());
            IRuntime fRuntime = null;
            String fRuntimeName = null;
            fRuntime = FacetUtils.getFacetRuntimeForProject((String)projects[i].getName());
            if (fRuntime != null) {
                fRuntimeName = fRuntime.getName();
            }
            if (facetVersions != null) {
                FacetMatcher fm = FacetMatchCache.getInstance().getMatchForProject(false, this.serviceRuntimeId_, projects[i].getName());
                boolean facetRuntimeMatches = true;
                if (fRuntimeName != null) {
                    facetRuntimeMatches = FacetUtils.isFacetRuntimeSupported((RequiredFacetVersion[])rfvs, (String)fRuntimeName);
                }
                if (fm.isMatch() && facetRuntimeMatches) {
                    this.serviceFacetMatcher_ = fm;
                    return projects[i].getName();
                }
            }
            ++i;
        }
        return ResourceUtils.getDefaultWebProjectName();
    }

    private ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet getDefaultServiceRuntimeForFixedRuntimeAndServer(IProject project, String runtimePreferredServer) {
        String[] serviceRuntimes = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType((String)this.serviceIds_.getTypeId(), (String)runtimePreferredServer);
        ArrayList<String> validServiceRuntimes = new ArrayList<String>();
        int i = 0;
        while (i < serviceRuntimes.length) {
            ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)serviceRuntimes[i]);
            if (desc.getRuntime().getId().equals(this.serviceIds_.getRuntimeId()) && WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer((String)desc.getId(), (String)this.serviceIds_.getServerId())) {
                FacetMatcher fm;
                Set facetVersions;
                validServiceRuntimes.add(desc.getId());
                if (project != null && project.exists() && (facetVersions = FacetUtils.getFacetsForProject((String)project.getName())) != null && (fm = FacetMatchCache.getInstance().getMatchForProject(false, serviceRuntimes[i], project.getName())).isMatch()) {
                    ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet drt = new ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet((ClientRuntimeSelectionWidgetDefaultingCommand)this);
                    drt.setFacetMatcher(fm);
                    drt.setProjectName(project.getName());
                    drt.setRuntimeId(desc.getId());
                    return drt;
                }
            }
            ++i;
        }
        if (validServiceRuntimes.size() > 0) {
            ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet drt = new ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet((ClientRuntimeSelectionWidgetDefaultingCommand)this);
            drt.setFacetMatcher(null);
            drt.setProjectName(null);
            drt.setRuntimeId(validServiceRuntimes.toArray(new String[0])[0]);
            return drt;
        }
        this.serviceIdsFixed_ = false;
        return this.getDefaultRuntime(project, this.serviceIds_.getTypeId(), false, this.serviceIds_.getServerId());
    }

    public void setInitialSelection(IStructuredSelection selection) {
    }

    public void setInitialProject(IProject initialProject) {
        this.initialProject_ = initialProject;
    }

    public IProject getInitialProject() {
        return this.initialProject_;
    }

    public void setInitialComponentName(String name) {
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.serviceIds_ = ids;
    }

    public void setServiceIdsFixed(boolean b) {
        this.serviceIdsFixed_ = b;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        return this.serviceIds_;
    }

    public String getServiceRuntimeId() {
        return this.serviceRuntimeId_;
    }

    public boolean getGenerateProxy() {
        return this.generateProxy_;
    }

    public void setGenerateProxy(boolean generateProxy_) {
        this.generateProxy_ = generateProxy_;
    }

    public String getServiceProjectName() {
        return this.serviceProjectName_;
    }

    public String getServiceEarProjectName() {
        return this.serviceEarProjectName_;
    }

    public String getServiceComponentType() {
        return this.serviceComponentType_;
    }

    public boolean getServiceNeedEAR() {
        return this.serviceNeedEAR_;
    }

    public void setServiceProjectName(String name) {
        this.serviceProjectName_ = name;
    }
}

