/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.ui.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.http.core.internal.HttpRuntime;
import org.eclipse.wst.server.http.ui.internal.HttpUIPlugin;
import org.eclipse.wst.server.http.ui.internal.Messages;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class HttpRuntimeComposite
extends Composite {
    protected IRuntimeWorkingCopy runtimeWC;
    protected HttpRuntime runtime;
    protected Text name;
    protected Text publishDir;
    protected Button browseButton;
    protected IWizardHandle wizard;

    public HttpRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.wizardTitle);
        wizard.setDescription(Messages.wizardDescription);
        wizard.setImageDescriptor(HttpUIPlugin.getImageDescriptor("wizServer"));
        this.createControl();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (HttpRuntime)newRuntime.loadAdapter(HttpRuntime.class, null);
        }
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Composite nameGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.wst.server.http.ui.twnr0000");
        Label label = new Label(nameGroup, 0);
        label.setText(Messages.runtimeName);
        GridData data = new GridData(776);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HttpRuntimeComposite.this.runtimeWC.setName(HttpRuntimeComposite.this.name.getText());
                HttpRuntimeComposite.this.validate();
            }
        });
        this.createPublishLocationGroup(nameGroup);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void init() {
        if (this.name == null || this.runtimeWC == null || this.runtime == null) {
            return;
        }
        this.name.setText(this.runtimeWC.getName());
        if (this.runtimeWC.getLocation() != null) {
            this.publishDir.setText(this.runtimeWC.getLocation().toOSString());
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        this.wizard.setMessage(null, 0);
        if (this.runtimeWC != null) {
            String name2 = this.runtimeWC.getName();
            if (name2 == null || name2.trim().equals("")) {
                this.wizard.setMessage(Messages.wizardMissingRuntimeName, 3);
            } else {
                boolean ok = this.checkRuntimeName(name2);
                if (!ok) {
                    this.wizard.setMessage(Messages.wizardDuplicateName, 3);
                }
            }
        }
    }

    private void createPublishLocationGroup(Composite publishInfoGroup) {
        Font font = publishInfoGroup.getFont();
        Label locationLabel = new Label(publishInfoGroup, 0);
        locationLabel.setFont(font);
        locationLabel.setText(Messages.publishDir);
        GridData data = new GridData(776);
        data.horizontalSpan = 2;
        locationLabel.setLayoutData((Object)data);
        this.publishDir = new Text(publishInfoGroup, 2048);
        data = new GridData(768);
        this.publishDir.setLayoutData((Object)data);
        this.publishDir.setFont(font);
        this.publishDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HttpRuntimeComposite.this.runtimeWC.setLocation((IPath)new Path(HttpRuntimeComposite.this.publishDir.getText()));
                HttpRuntimeComposite.this.validate();
            }
        });
        this.browseButton = new Button(publishInfoGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText(Messages.browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(HttpRuntimeComposite.this.getShell());
                dialog.setMessage(Messages.selectInstallDir);
                dialog.setFilterPath(HttpRuntimeComposite.this.publishDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    HttpRuntimeComposite.this.publishDir.setText(selectedDirectory);
                }
            }
        });
    }

    private boolean checkRuntimeName(String name2) {
        if ((name2 = name2.trim()).equals(this.runtimeWC.getName())) {
            return true;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            IRuntime[] iRuntimeArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime2 = iRuntimeArray[n2];
                if (name2.equals(runtime2.getName())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

