/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.componentcore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.componentcore.AppClientBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.ComponentArchiveOptions;
import org.eclipse.jst.j2ee.internal.componentcore.EJBBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.JCABinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.UtilityBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.WebBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.BinaryComponentHelper;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public abstract class EnterpriseBinaryComponentHelper
extends BinaryComponentHelper {
    private IReferenceCountedArchive archive = null;
    boolean gotResource = false;

    public static EnterpriseBinaryComponentHelper getHelper(IVirtualComponent aComponent) {
        EnterpriseBinaryComponentHelper helper = null;
        helper = J2EEProjectUtilities.isEJBComponent(aComponent) ? new EJBBinaryComponentHelper(aComponent) : (J2EEProjectUtilities.isApplicationClientComponent(aComponent) ? new AppClientBinaryComponentHelper(aComponent) : (J2EEProjectUtilities.isJCAComponent(aComponent) ? new JCABinaryComponentHelper(aComponent) : (J2EEProjectUtilities.isDynamicWebComponent(aComponent) ? new WebBinaryComponentHelper(aComponent) : new UtilityBinaryComponentHelper(aComponent))));
        return helper;
    }

    protected EnterpriseBinaryComponentHelper(IVirtualComponent component) {
        super(component);
    }

    protected ComponentArchiveOptions getArchiveOptions() {
        ComponentArchiveOptions options = new ComponentArchiveOptions(this.getComponent());
        options.setIsReadOnly(true);
        options.setRendererType(1);
        options.setUseJavaReflection(false);
        return options;
    }

    protected IReferenceCountedArchive getUniqueArchive() {
        try {
            return this.openArchive();
        }
        catch (OpenFailureException e) {
            Logger.getLogger().logError((Throwable)e);
            return null;
        }
    }

    public Archive accessArchive() {
        IReferenceCountedArchive archive = this.getArchive();
        archive.access();
        if (!EnterpriseBinaryComponentHelper.isPhysicallyOpen(archive)) {
            EnterpriseBinaryComponentHelper.physicallyOpen(archive);
        }
        return archive;
    }

    protected IReferenceCountedArchive getArchive() {
        if (this.archive == null) {
            this.archive = this.getUniqueArchive();
        }
        return this.archive;
    }

    protected boolean isArchiveValid() {
        if (this.archive != null) {
            return true;
        }
        Archive anArchive = null;
        try {
            anArchive = CommonarchiveFactory.eINSTANCE.primOpenArchive((ArchiveOptions)this.getArchiveOptions(), this.getArchiveURI());
            ArchiveTypeDiscriminator disc = this.getDiscriminator();
            boolean bl = disc == null || disc.canImport(anArchive);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (anArchive != null) {
                anArchive.close();
            }
        }
    }

    protected String getArchiveURI() {
        String archiveURI = null;
        VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)this.getComponent();
        File diskFile = archiveComp.getUnderlyingDiskFile();
        if (diskFile.exists()) {
            archiveURI = diskFile.getAbsolutePath();
        } else {
            IFile iFile = archiveComp.getUnderlyingWorkbenchFile();
            archiveURI = iFile.getRawLocation().toOSString();
        }
        return archiveURI;
    }

    public void dispose() {
        if (this.archive != null) {
            this.archive.close();
            this.archive = null;
        }
    }

    protected abstract ArchiveTypeDiscriminator getDiscriminator();

    protected IReferenceCountedArchive openArchive() throws OpenFailureException {
        ArchiveCache cache = ArchiveCache.getInstance();
        IReferenceCountedArchive archive = cache.getArchive(this.getComponent());
        if (archive != null) {
            archive.access();
            return archive;
        }
        return cache.openArchive(this);
    }

    public Resource getResource(URI uri) {
        Resource resource = null;
        if (!EnterpriseBinaryComponentHelper.isPhysicallyOpen(this.getArchive()) && (resource = this.getArchive().getResourceSet().getResource(uri, false)) == null) {
            EnterpriseBinaryComponentHelper.physicallyOpen(this.getArchive());
        }
        if (resource == null) {
            resource = this.getArchive().getResourceSet().getResource(uri, true);
        }
        return resource;
    }

    public void releaseAccess() {
        this.dispose();
    }

    private static void unloadArchive(IReferenceCountedArchive archive) {
        WorkbenchResourceHelperBase.removeAndUnloadAll((List)archive.getResourceSet().getResources(), (ResourceSet)archive.getResourceSet());
        archive.getLoadStrategy().setResourceSet(null);
        archive.setLoadStrategy(null);
    }

    private static boolean isPhysicallyOpen(IReferenceCountedArchive archive) {
        return ((BinaryZipFileLoadStrategy)archive.getLoadStrategy()).isPhysicallyOpen();
    }

    private static void physicallyOpen(IReferenceCountedArchive archive) {
        try {
            ((BinaryZipFileLoadStrategy)archive.getLoadStrategy()).physicallyOpen();
        }
        catch (ZipException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected static void physicallyClose(IReferenceCountedArchive archive) {
        ((BinaryZipFileLoadStrategy)archive.getLoadStrategy()).physicallyClose();
    }

    protected static BinaryZipFileLoadStrategy createBinaryLoadStrategy(EnterpriseBinaryComponentHelper helper) throws OpenFailureException {
        String archiveURI = helper.getArchiveURI();
        String filename = archiveURI.replace('/', File.separatorChar);
        File file = new File(filename);
        if (!file.exists()) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString((String)CommonArchiveResourceHandler.file_not_found_EXC_, (Object[])new Object[]{archiveURI, file.getAbsolutePath()}));
        }
        try {
            BinaryZipFileLoadStrategy strategy = new BinaryZipFileLoadStrategy(file);
            return strategy;
        }
        catch (IOException ex) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString((String)CommonArchiveResourceHandler.could_not_open_EXC_, (Object[])new Object[]{archiveURI}), (Exception)ex);
        }
    }

    public static class ArchiveCache {
        private static ArchiveCache instance = null;
        protected Map componentsToArchives = new Hashtable();

        public static ArchiveCache getInstance() {
            if (instance == null) {
                instance = new ArchiveCache();
            }
            return instance;
        }

        public synchronized IReferenceCountedArchive getArchive(IVirtualComponent component) {
            IReferenceCountedArchive archive = (IReferenceCountedArchive)this.componentsToArchives.get(component);
            return archive;
        }

        public synchronized void clearDisconnectedArchivesInEAR(IVirtualComponent earComponent) {
            if (this.componentsToArchives.isEmpty()) {
                return;
            }
            HashSet<IVirtualComponent> liveBinaryComponnts = new HashSet<IVirtualComponent>();
            IVirtualReference[] refs = earComponent.getReferences();
            IVirtualComponent component = null;
            int i = 0;
            while (i < refs.length) {
                component = refs[i].getReferencedComponent();
                if (component.isBinary()) {
                    liveBinaryComponnts.add(component);
                }
                ++i;
            }
            this.clearArchivesInProject(earComponent.getProject(), liveBinaryComponnts);
        }

        public synchronized void clearAllArchivesInProject(IProject earProject) {
            if (this.componentsToArchives.isEmpty()) {
                return;
            }
            this.clearArchivesInProject(earProject, null);
        }

        private void clearArchivesInProject(IProject earProject, Set excludeSet) {
            Iterator iterator = this.componentsToArchives.entrySet().iterator();
            IVirtualComponent component = null;
            IReferenceCountedArchive archive = null;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                component = (IVirtualComponent)entry.getKey();
                if (!component.getProject().equals((Object)earProject) || excludeSet != null && excludeSet.contains(component)) continue;
                archive = (IReferenceCountedArchive)entry.getValue();
                archive.forceClose();
                EnterpriseBinaryComponentHelper.unloadArchive(archive);
                iterator.remove();
            }
        }

        public synchronized IReferenceCountedArchive openArchive(EnterpriseBinaryComponentHelper helper) throws OpenFailureException {
            ComponentArchiveOptions options = helper.getArchiveOptions();
            String archiveURI = helper.getArchiveURI();
            options.setLoadStrategy((LoadStrategy)EnterpriseBinaryComponentHelper.createBinaryLoadStrategy(helper));
            Archive anArchive = CommonarchiveFactory.eINSTANCE.primOpenArchive((ArchiveOptions)options, archiveURI);
            ArchiveTypeDiscriminator discriminator = helper.getDiscriminator();
            if (!discriminator.canImport(anArchive)) {
                anArchive.close();
                throw new OpenFailureException(discriminator.getUnableToOpenMessage());
            }
            IReferenceCountedArchive specificArchive = (IReferenceCountedArchive)discriminator.openArchive(anArchive);
            specificArchive.setEnterpriseBinaryComponentHelper(helper);
            specificArchive.initializeAfterOpen();
            specificArchive.access();
            this.componentsToArchives.put(helper.getComponent(), specificArchive);
            return specificArchive;
        }
    }

    private static class BinaryZipFileLoadStrategy
    extends ZipFileLoadStrategyImpl {
        private boolean physicallyOpen = true;

        public BinaryZipFileLoadStrategy() {
        }

        public BinaryZipFileLoadStrategy(File file) throws IOException {
            super(file);
        }

        public boolean isPhysicallyOpen() {
            return this.physicallyOpen;
        }

        public void physicallyOpen() throws ZipException, IOException {
            if (!this.isPhysicallyOpen()) {
                this.physicallyOpen = true;
                this.setZipFile(new ZipFile(this.file));
            }
        }

        public void physicallyClose() {
            if (this.isPhysicallyOpen()) {
                this.physicallyOpen = false;
                try {
                    this.zipFile.close();
                }
                catch (Throwable throwable) {}
            }
        }

        public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
            final boolean isPhysciallyOpen = this.isPhysicallyOpen();
            Exception caughtException = null;
            try {
                ZipEntry entry;
                if (!isPhysciallyOpen) {
                    this.physicallyOpen();
                }
                if ((entry = this.getZipFile().getEntry(uri)) == null) {
                    throw new FileNotFoundException(uri);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getZipFile().getInputStream(entry)){

                    public void close() throws IOException {
                        super.close();
                        if (!isPhysciallyOpen) {
                            BinaryZipFileLoadStrategy.this.physicallyClose();
                        }
                    }
                };
                return bufferedInputStream;
            }
            catch (FileNotFoundException e) {
                caughtException = e;
                throw e;
            }
            catch (IllegalStateException zipClosed) {
                caughtException = zipClosed;
                throw new IOException(zipClosed.toString());
            }
            catch (Exception e) {
                caughtException = e;
                throw new IOException(e.toString());
            }
            finally {
                if (caughtException != null && !isPhysciallyOpen) {
                    this.physicallyClose();
                }
            }
        }
    }

    protected static interface IReferenceCountedArchive
    extends Archive {
        public void access();

        public void forceClose();

        public void setEnterpriseBinaryComponentHelper(EnterpriseBinaryComponentHelper var1);

        public EnterpriseBinaryComponentHelper getEnterpriseBinaryComponentHelper();
    }
}

