/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.componentcore;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentLoadAdapter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.internal.BinaryComponentHelper;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JavaEEBinaryComponentHelper
extends BinaryComponentHelper {
    private IArchive archive;
    private int localArchiveAccessCount = 0;

    public static JavaEEQuickPeek getJavaEEQuickPeek(IVirtualComponent aBinaryComponent) {
        JavaEEBinaryComponentHelper helper = null;
        try {
            JavaEEQuickPeek qp;
            helper = new JavaEEBinaryComponentHelper(aBinaryComponent);
            IArchive archive = helper.getArchive();
            if (archive == null) {
                JavaEEQuickPeek javaEEQuickPeek = new JavaEEQuickPeek(null);
                return javaEEQuickPeek;
            }
            JavaEEQuickPeek javaEEQuickPeek = qp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
            return javaEEQuickPeek;
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    public JavaEEBinaryComponentHelper(IVirtualComponent aBinaryComponent) {
        super(aBinaryComponent);
    }

    public EObject getPrimaryRootObject() {
        JavaEEQuickPeek qp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.getArchive());
        Path ddPath = null;
        switch (qp.getType()) {
            case 3: {
                ddPath = new Path("META-INF/application-client.xml");
                break;
            }
            case 0: {
                ddPath = new Path("META-INF/ejb-jar.xml");
                break;
            }
            case 4: {
                ddPath = new Path("WEB-INF/web.xml");
                break;
            }
            case 2: {
                ddPath = new Path("META-INF/ra.xml");
            }
        }
        if (ddPath != null) {
            try {
                return (EObject)this.getArchive().getModelObject((IPath)ddPath);
            }
            catch (ArchiveModelLoadException e) {
                J2EEPlugin.logError(e);
            }
        }
        return null;
    }

    public Resource getResource(URI uri) {
        Path path = new Path(uri.toString());
        try {
            return (Resource)((JavaEEBinaryComponentLoadAdapter)this.getArchive().getLoadAdapter()).getModelObject((IPath)path);
        }
        catch (ArchiveModelLoadException e) {
            J2EEPlugin.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IArchive accessArchive() {
        IArchive archive = this.getArchive();
        if (archive != null) {
            ArchiveCache cache = ArchiveCache.getInstance();
            cache.accessArchive(archive);
            JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
            synchronized (javaEEBinaryComponentHelper) {
                ++this.localArchiveAccessCount;
            }
        }
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseArchive(IArchive archive) {
        if (archive != this.archive) {
            throw new RuntimeException("The IArchive parameter must be the same IArchive retrieved from accessArchive");
        }
        if (archive != null) {
            ArchiveCache cache = ArchiveCache.getInstance();
            cache.releaseArchive(archive);
            JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
            synchronized (javaEEBinaryComponentHelper) {
                --this.localArchiveAccessCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        int count = 0;
        JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
        synchronized (javaEEBinaryComponentHelper) {
            count = this.localArchiveAccessCount;
        }
        if (count > 0 && this.archive != null) {
            ArchiveCache cache = ArchiveCache.getInstance();
            int i = 0;
            while (i < count) {
                cache.releaseArchive(this.archive);
                JavaEEBinaryComponentHelper javaEEBinaryComponentHelper2 = this;
                synchronized (javaEEBinaryComponentHelper2) {
                    --this.localArchiveAccessCount;
                }
                ++i;
            }
        }
    }

    protected IArchive getArchive() {
        if (this.archive == null) {
            this.archive = this.getUniqueArchive();
        }
        return this.archive;
    }

    protected IArchive getUniqueArchive() {
        try {
            return this.openArchive();
        }
        catch (ArchiveOpenFailureException e) {
            J2EEPlugin.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IArchive openArchive() throws ArchiveOpenFailureException {
        ArchiveCache cache = ArchiveCache.getInstance();
        IArchive archive = cache.getArchive(this.getComponent());
        if (archive == null) {
            archive = cache.openArchive(this);
        }
        if (archive != null) {
            cache.accessArchive(archive);
            JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
            synchronized (javaEEBinaryComponentHelper) {
                ++this.localArchiveAccessCount;
            }
        }
        return archive;
    }

    public static void clearDisconnectedArchivesInEAR(IVirtualComponent earComponent) {
        ArchiveCache.getInstance().clearDisconnectedArchivesInEAR(earComponent);
    }

    public static void clearAllArchivesInProject(IProject earProject) {
        ArchiveCache.getInstance().clearAllArchivesInProject(earProject);
    }

    private static class ArchiveCache {
        private static ArchiveCache instance = null;
        protected Map<IVirtualComponent, IArchive> componentsToArchives = new Hashtable<IVirtualComponent, IArchive>();
        protected Map<IArchive, Integer> archiveAccessCount = new Hashtable<IArchive, Integer>();

        private ArchiveCache() {
        }

        public static ArchiveCache getInstance() {
            if (instance == null) {
                instance = new ArchiveCache();
            }
            return instance;
        }

        public synchronized void accessArchive(IArchive archive) {
            Integer count = this.archiveAccessCount.get(archive);
            Integer newCount = new Integer(count + 1);
            this.archiveAccessCount.put(archive, newCount);
            if (newCount == 1) {
                JavaEEBinaryComponentLoadAdapter binaryAdapter = null;
                binaryAdapter = archive.getArchiveOptions().hasOption((Object)"WRAPPED_LOAD_ADAPTER") ? (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"WRAPPED_LOAD_ADAPTER")) : (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"LOAD_ADAPTER"));
                if (!binaryAdapter.isPhysicallyOpen()) {
                    try {
                        binaryAdapter.physicallyOpen();
                    }
                    catch (ZipException e) {
                        J2EEPlugin.logError(e);
                    }
                    catch (IOException e) {
                        J2EEPlugin.logError(e);
                    }
                }
            }
        }

        public synchronized void releaseArchive(IArchive archive) {
            Integer count = this.archiveAccessCount.get(archive);
            Integer newCount = new Integer(count - 1);
            this.archiveAccessCount.put(archive, newCount);
            if (newCount == 0) {
                JavaEEBinaryComponentLoadAdapter binaryAdapter = null;
                binaryAdapter = archive.getArchiveOptions().hasOption((Object)"WRAPPED_LOAD_ADAPTER") ? (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"WRAPPED_LOAD_ADAPTER")) : (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"LOAD_ADAPTER"));
                if (binaryAdapter.isPhysicallyOpen()) {
                    binaryAdapter.physicallyClose();
                }
            }
        }

        public synchronized IArchive getArchive(IVirtualComponent component) {
            IArchive archive = this.componentsToArchives.get(component);
            return archive;
        }

        public synchronized void clearDisconnectedArchivesInEAR(IVirtualComponent earComponent) {
            if (this.componentsToArchives.isEmpty()) {
                return;
            }
            HashSet<IVirtualComponent> liveBinaryComponnts = new HashSet<IVirtualComponent>();
            IVirtualReference[] refs = earComponent.getReferences();
            IVirtualComponent component = null;
            int i = 0;
            while (i < refs.length) {
                component = refs[i].getReferencedComponent();
                if (component.isBinary()) {
                    liveBinaryComponnts.add(component);
                }
                ++i;
            }
            this.clearArchivesInProject(earComponent.getProject(), liveBinaryComponnts);
        }

        public synchronized void clearAllArchivesInProject(IProject earProject) {
            if (this.componentsToArchives.isEmpty()) {
                return;
            }
            this.clearArchivesInProject(earProject, null);
        }

        private void clearArchivesInProject(IProject earProject, Set excludeSet) {
            Iterator<Map.Entry<IVirtualComponent, IArchive>> iterator = this.componentsToArchives.entrySet().iterator();
            IVirtualComponent component = null;
            IArchive archive = null;
            while (iterator.hasNext()) {
                Map.Entry<IVirtualComponent, IArchive> entry = iterator.next();
                component = entry.getKey();
                if (!component.getProject().equals((Object)earProject) || excludeSet != null && excludeSet.contains(component)) continue;
                archive = entry.getValue();
                IArchiveFactory.INSTANCE.closeArchive(archive);
                iterator.remove();
                this.archiveAccessCount.remove(archive);
            }
        }

        public synchronized IArchive openArchive(JavaEEBinaryComponentHelper helper) throws ArchiveOpenFailureException {
            IArchive archive = JavaEEArchiveUtilities.INSTANCE.openArchive(helper.getComponent());
            this.componentsToArchives.put(helper.getComponent(), archive);
            this.archiveAccessCount.put(archive, new Integer(0));
            return archive;
        }
    }
}

