/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.componentcore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.JavaEEEMFZipFileLoadAdapterImpl;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;

public class JavaEEBinaryComponentLoadAdapter
extends JavaEEEMFZipFileLoadAdapterImpl {
    private File file = null;
    private IPath archivePath;
    private boolean physicallyOpen = true;
    private VirtualArchiveComponent archiveComponent;

    public JavaEEBinaryComponentLoadAdapter(VirtualArchiveComponent archiveComponent) throws ArchiveOpenFailureException {
        ZipFile zipFile;
        this.archiveComponent = archiveComponent;
        File diskFile = null;
        diskFile = archiveComponent.getUnderlyingDiskFile();
        if (!diskFile.exists()) {
            IFile wbFile = archiveComponent.getUnderlyingWorkbenchFile();
            diskFile = new File(wbFile.getLocation().toOSString());
        }
        Path archivePath = new Path(diskFile.getAbsolutePath());
        this.file = new File(archivePath.toOSString());
        try {
            zipFile = new ZipFile(this.file);
        }
        catch (ZipException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(this.file.getAbsolutePath(), (Throwable)e);
            throw openFailureException;
        }
        catch (IOException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(this.file.getAbsolutePath(), (Throwable)e);
            throw openFailureException;
        }
        this.setZipFile(zipFile);
        this.setArchivePath((IPath)archivePath);
    }

    private void setArchivePath(IPath archivePath) {
        this.archivePath = archivePath;
    }

    public IPath getArchivePath() {
        return this.archivePath;
    }

    public boolean isPhysicallyOpen() {
        return this.physicallyOpen;
    }

    public void physicallyOpen() throws ZipException, IOException {
        if (!this.isPhysicallyOpen()) {
            this.physicallyOpen = true;
            this.setZipFile(new ZipFile(this.file));
        }
    }

    public void physicallyClose() {
        if (this.isPhysicallyOpen()) {
            this.physicallyOpen = false;
            try {
                this.zipFile.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public InputStream getInputStream(IArchiveResource aFile) throws IOException, FileNotFoundException {
        final boolean isPhysciallyOpen = this.isPhysicallyOpen();
        Exception caughtException = null;
        try {
            if (!isPhysciallyOpen) {
                this.physicallyOpen();
            }
            IPath path = aFile.getPath();
            String uri = path.toString();
            ZipEntry entry = this.getZipFile().getEntry(uri);
            if (entry == null) {
                throw new FileNotFoundException(uri);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getZipFile().getInputStream(entry)){

                public void close() throws IOException {
                    super.close();
                    if (!isPhysciallyOpen) {
                        JavaEEBinaryComponentLoadAdapter.this.physicallyClose();
                    }
                }
            };
            return bufferedInputStream;
        }
        catch (FileNotFoundException e) {
            caughtException = e;
            throw e;
        }
        catch (IllegalStateException zipClosed) {
            caughtException = zipClosed;
            throw new IOException(zipClosed.toString());
        }
        catch (Exception e) {
            caughtException = e;
            throw new IOException(e.toString());
        }
        finally {
            if (caughtException != null && !isPhysciallyOpen) {
                this.physicallyClose();
            }
        }
    }

    public VirtualArchiveComponent getArchiveComponent() {
        return this.archiveComponent;
    }
}

