/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EJBUtilities
extends JavaEEProjectUtilities {
    public static IVirtualComponent getEJBClientJar(IProject ejbProject) {
        Object jar = ModelProviderManager.getModelProvider(ejbProject).getModelObject();
        IVirtualComponent ejbClientComponent = null;
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)ejbProject);
        if (ejbComponent == null) {
            return null;
        }
        Properties props = ejbComponent.getMetaProperties();
        String clientCompName = props.getProperty("ClientProject");
        if (clientCompName != null && !clientCompName.equals("")) {
            IVirtualReference vRef = ejbComponent.getReference(clientCompName);
            if (vRef != null) {
                ejbClientComponent = vRef.getReferencedComponent();
            }
        } else {
            String clientJAR = null;
            if (jar != null) {
                if (jar instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
                    clientJAR = ((org.eclipse.jst.j2ee.ejb.EJBJar)jar).getEjbClientJar();
                } else if (jar instanceof EJBJar) {
                    clientJAR = ((EJBJar)jar).getEjbClientJar();
                }
            }
            if (clientJAR != null) {
                clientJAR = clientJAR.substring(0, clientJAR.length() - 4);
                ejbComponent = ComponentCore.createComponent((IProject)ejbProject);
                if (ejbComponent == null) {
                    return null;
                }
                IVirtualReference ref = ejbComponent.getReference(clientJAR);
                if (ref != null) {
                    ejbClientComponent = ref.getReferencedComponent();
                }
            }
        }
        return ejbClientComponent;
    }

    public static boolean hasEJBClientJARProject(IProject ejbProject) {
        return EJBUtilities.getEJBClientJar(ejbProject) != null;
    }
}

