/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.PingThread;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.PublishOperation2;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IModulePublishHelper;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.eclipse.wst.server.core.util.SocketUtil;

public class TomcatServerBehaviour
extends ServerBehaviourDelegate
implements ITomcatServerBehaviour,
IModulePublishHelper {
    private static final String ATTR_STOP = "stop-server";
    private static final String[] JMX_EXCLUDE_ARGS = new String[]{"-Dcom.sun.management.jmxremote", "-Dcom.sun.management.jmxremote.port=", "-Dcom.sun.management.jmxremote.ssl=", "-Dcom.sun.management.jmxremote.authenticate="};
    protected transient PingThread ping = null;
    protected transient IDebugEventSetListener processListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void initialize(IProgressMonitor monitor) {
    }

    public TomcatRuntime getTomcatRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TomcatRuntime)iRuntime.loadAdapter((Class)clazz, null);
    }

    public ITomcatVersionHandler getTomcatVersionHandler() {
        return this.getTomcatServer().getTomcatVersionHandler();
    }

    public TomcatConfiguration getTomcatConfiguration() throws CoreException {
        return this.getTomcatServer().getTomcatConfiguration();
    }

    public TomcatServer getTomcatServer() {
        IServer iServer = this.getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TomcatServer)iServer.loadAdapter((Class)clazz, null);
    }

    public String getRuntimeClass() {
        return this.getTomcatVersionHandler().getRuntimeClass();
    }

    public IPath getRuntimeBaseDirectory() {
        return this.getTomcatServer().getRuntimeBaseDirectory();
    }

    protected String[] getRuntimeProgramArguments(boolean starting) {
        IPath configPath = null;
        if (this.getTomcatServer().isTestEnvironment()) {
            configPath = this.getRuntimeBaseDirectory();
        }
        return this.getTomcatVersionHandler().getRuntimeProgramArguments(configPath, this.getTomcatServer().isDebug(), starting);
    }

    protected String[] getExcludedRuntimeProgramArguments(boolean starting) {
        return this.getTomcatVersionHandler().getExcludedRuntimeProgramArguments(this.getTomcatServer().isDebug(), starting);
    }

    protected String[] getRuntimeVMArguments() {
        IPath installPath = this.getServer().getRuntime().getLocation();
        IPath configPath = this.getRuntimeBaseDirectory();
        IPath deployPath = this.getTomcatServer().isServeModulesWithoutPublish() ? ResourcesPlugin.getWorkspace().getRoot().getLocation() : this.getServerDeployDirectory();
        return this.getTomcatVersionHandler().getRuntimeVMArguments(installPath, configPath, deployPath, this.getTomcatServer().isTestEnvironment());
    }

    protected String getRuntimePolicyFile() {
        IPath configPath = this.getRuntimeBaseDirectory();
        return this.getTomcatVersionHandler().getRuntimePolicyFile(configPath);
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    protected void addProcessListener(final IProcess newProcess) {
        if (this.processListener != null || newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (newProcess != null && newProcess.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            TomcatServerBehaviour.this.stopImpl();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void stopImpl() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.setServerState(4);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        IStatus status;
        if (this.getServer().getRuntime() == null) {
            return;
        }
        IPath installDir = this.getServer().getRuntime().getLocation();
        IPath confDir = null;
        if (this.getTomcatServer().isTestEnvironment()) {
            confDir = this.getRuntimeBaseDirectory();
            status = this.getTomcatVersionHandler().prepareRuntimeDirectory(confDir);
            if (status != null && !status.isOK()) {
                throw new CoreException(status);
            }
        } else {
            confDir = installDir;
        }
        if ((status = this.getTomcatVersionHandler().prepareDeployDirectory(this.getServerDeployDirectory())) != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask(Messages.publishServerTask, 600);
        status = this.getTomcatConfiguration().cleanupServer(confDir, installDir, !this.getTomcatServer().isSaveSeparateContextFiles(), ProgressUtil.getSubMonitorFor(monitor, 100));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        status = this.getTomcatConfiguration().backupAndPublish(confDir, !this.getTomcatServer().isTestEnvironment(), ProgressUtil.getSubMonitorFor(monitor, 400));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        status = this.getTomcatConfiguration().localizeConfiguration(confDir, this.getServerDeployDirectory(), this.getTomcatServer(), ProgressUtil.getSubMonitorFor(monitor, 100));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor.done();
        this.setServerPublishState(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
            this.setServerRestartState(true);
        }
        if (this.getTomcatServer().isTestEnvironment()) {
            return;
        }
        IPath path = this.getTempDirectory().append("publish.txt");
        Properties p = new Properties();
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(path.toFile());
                p.load(fin);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                fin.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (Exception exception) {}
        fin.close();
        PublishHelper helper = new PublishHelper(this.getRuntimeBaseDirectory().append("temp").toFile());
        if (moduleTree.length == 1) {
            this.publishDir(deltaKind, p, moduleTree, helper, monitor);
        } else {
            this.publishJar(kind, deltaKind, p, moduleTree, helper, monitor);
        }
        this.setModulePublishState(moduleTree, 1);
        try {
            p.store(new FileOutputStream(path.toFile()), "Tomcat publish data");
            return;
        }
        catch (Exception exception) {}
    }

    private void publishDir(int deltaKind, Properties p, IModule[] module, PublishHelper helper, IProgressMonitor monitor) throws CoreException {
        ArrayList status = new ArrayList();
        if (deltaKind == 3 || this.getTomcatServer().isServeModulesWithoutPublish()) {
            String publishPath = (String)p.get(module[0].getId());
            if (publishPath != null) {
                try {
                    File f = new File(publishPath);
                    if (f.exists()) {
                        IStatus[] stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                        PublishOperation2.addArrayToList(status, stat);
                    }
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishCouldNotRemoveModule, (Object)module[0].getName()), (Throwable)e));
                }
                p.remove(module[0].getId());
            }
        } else {
            IPath path = this.getModuleDeployDirectory(module[0]);
            IModuleResource[] mr = this.getResources(module);
            IPath[] jarPaths = null;
            IModule[] childModules = this.getServer().getChildModules(module, monitor);
            if (childModules != null && childModules.length > 0) {
                jarPaths = new IPath[childModules.length];
                int i = 0;
                while (i < childModules.length) {
                    jarPaths[i] = new Path("WEB-INF/lib").append(String.valueOf(childModules[i].getName()) + ".jar");
                    ++i;
                }
            }
            IStatus[] stat = helper.publishSmart(mr, path, jarPaths, monitor);
            PublishOperation2.addArrayToList(status, stat);
            p.put(module[0].getId(), path.toOSString());
        }
        PublishOperation2.throwException(status);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishJar(int kind, int deltaKind, Properties p, IModule[] module, PublishHelper helper, IProgressMonitor monitor) throws CoreException {
        if (deltaKind == 3 || this.getTomcatServer().isServeModulesWithoutPublish()) {
            try {
                String publishPath = (String)p.get(module[1].getId());
                if (publishPath == null) return;
                new File(publishPath).delete();
                p.remove(module[1].getId());
                return;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.tomcat.core", 0, "Could not remove module", (Throwable)e));
            }
        } else {
            IModuleResourceDelta[] delta;
            IPath path = this.getModuleDeployDirectory(module[0]);
            path = path.append("WEB-INF").append("lib");
            IPath jarPath = path.append(String.valueOf(module[1].getName()) + ".jar");
            if (!path.toFile().exists()) {
                path.toFile().mkdirs();
            } else if (jarPath.toFile().exists() && kind != 4 && kind != 2 && ((delta = this.getPublishedResourceDelta(module)) == null || delta.length == 0)) {
                return;
            }
            IModuleResource[] mr = this.getResources(module);
            IStatus[] stat = helper.publishZip(mr, jarPath, monitor);
            ArrayList status = new ArrayList();
            PublishOperation2.addArrayToList(status, stat);
            PublishOperation2.throwException(status);
            p.put(module[1].getId(), jarPath.toOSString());
        }
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        IPath baseDir = this.getRuntimeBaseDirectory();
        TomcatServer ts = this.getTomcatServer();
        ITomcatVersionHandler tvh = this.getTomcatVersionHandler();
        IStatus status = tvh.prepareForServingDirectly(baseDir, this.getTomcatServer());
        if (status.isOK() && (status = ts.isServeModulesWithoutPublish() ? this.getTomcatConfiguration().updateContextsToServeDirectly(baseDir, tvh.getSharedLoader(baseDir), monitor) : this.getTomcatConfiguration().publishContextConfig(baseDir, this.getServerDeployDirectory(), monitor)).isOK() && ts.isSaveSeparateContextFiles()) {
            String id = this.getServer().getServerType().getId();
            boolean noPath = id.indexOf("55") > 0 || id.indexOf("60") > 0;
            boolean serverStopped = this.getServer().getServerState() == 4;
            TomcatVersionHelper.moveContextsToSeparateFiles(baseDir, noPath, serverStopped, null);
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if ("true".equals(launch.getLaunchConfiguration().getAttribute(ATTR_STOP, "false"))) {
            return;
        }
        IStatus status = this.getTomcatRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        TomcatConfiguration configuration = this.getTomcatConfiguration();
        Iterator iterator = configuration.getServerPorts().iterator();
        ArrayList<ServerPort> usedPorts = new ArrayList<ServerPort>();
        while (iterator.hasNext()) {
            ServerPort sp = (ServerPort)iterator.next();
            if (sp.getPort() < 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorPortInvalid, null));
            }
            if (!SocketUtil.isPortInUse((int)sp.getPort(), (int)5)) continue;
            usedPorts.add(sp);
        }
        if (usedPorts.size() == 1) {
            ServerPort port = (ServerPort)usedPorts.get(0);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{String.valueOf(port.getPort()), this.getServer().getName()}), null));
        }
        if (usedPorts.size() > 1) {
            String portStr = "";
            iterator = usedPorts.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    portStr = String.valueOf(portStr) + ", ";
                }
                first = false;
                ServerPort sp = (ServerPort)iterator.next();
                portStr = String.valueOf(portStr) + sp.getPort();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPortsInUse, (Object[])new String[]{portStr, this.getServer().getName()}), null));
        }
        iterator = configuration.getWebModules().iterator();
        ArrayList<String> contextRoots = new ArrayList<String>();
        while (iterator.hasNext()) {
            WebModule module = (WebModule)iterator.next();
            String contextRoot = module.getPath();
            if (contextRoots.contains(contextRoot)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorDuplicateContextRoot, (Object[])new String[]{contextRoot}), null));
            }
            contextRoots.add(contextRoot);
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
        try {
            String url = "http://localhost";
            int port = configuration.getMainPort().getPort();
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this.ping = new PingThread(this.getServer(), url, -1, this);
        }
        catch (Exception exception) {
            Trace.trace((byte)2, "Can't ping for Tomcat startup.");
        }
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4) {
            return;
        }
        if (state == 1 || state == 3) {
            this.terminate();
            return;
        }
        try {
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Stopping Tomcat");
            }
            if (state != 4) {
                this.setServerState(3);
            }
            ILaunchConfiguration launchConfig = ((Server)this.getServer()).getLaunchConfiguration(true, null);
            ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
            String args = TomcatServerBehaviour.renderCommandLine(this.getRuntimeProgramArguments(false), " ");
            String existingVMArgs = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            if (existingVMArgs.indexOf(JMX_EXCLUDE_ARGS[0]) >= 0) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, TomcatServerBehaviour.mergeArguments(existingVMArgs, new String[0], JMX_EXCLUDE_ARGS, false));
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute(ATTR_STOP, "true");
            wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error stopping Tomcat", e);
        }
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            ILaunch launch;
            this.setServerState(3);
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Killing the Tomcat process");
            }
            if ((launch = this.getServer().getLaunch()) != null) {
                launch.terminate();
                this.stopImpl();
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error killing the process", e);
        }
    }

    public IPath getTempDirectory() {
        return super.getTempDirectory();
    }

    public String toString() {
        return "TomcatServer";
    }

    protected static int getNextToken(String s, int start) {
        int i = start;
        int length = s.length();
        int lookFor = 32;
        while (i < length) {
            int c = s.charAt(i);
            if (lookFor == c) {
                if (lookFor == 34) {
                    return i + 1;
                }
                return i;
            }
            if (c == 34) {
                lookFor = 34;
            }
            ++i;
        }
        return -1;
    }

    public static String mergeArguments(String originalArg, String[] vmArgs, String[] excludeArgs, boolean keepActionLast) {
        int index2;
        String s;
        int index;
        int ind2;
        int ind;
        if (vmArgs == null) {
            return originalArg;
        }
        if (originalArg == null) {
            originalArg = "";
        }
        int size = vmArgs.length;
        int i = 0;
        while (i < size) {
            ind = vmArgs[i].indexOf(" ");
            ind2 = vmArgs[i].indexOf("=");
            if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                index = originalArg.indexOf(vmArgs[i].substring(0, ind + 1));
                if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                    s = originalArg.substring(0, index);
                    index2 = TomcatServerBehaviour.getNextToken(originalArg, index + ind + 1);
                    originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                    vmArgs[i] = null;
                }
            } else if (ind2 >= 0) {
                index = originalArg.indexOf(vmArgs[i].substring(0, ind2 + 1));
                if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                    s = originalArg.substring(0, index);
                    index2 = TomcatServerBehaviour.getNextToken(originalArg, index);
                    originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                    vmArgs[i] = null;
                }
            } else {
                index = originalArg.indexOf(vmArgs[i]);
                if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                    s = originalArg.substring(0, index);
                    index2 = TomcatServerBehaviour.getNextToken(originalArg, index);
                    if (!keepActionLast || i < size - 1) {
                        originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                        vmArgs[i] = null;
                    } else {
                        originalArg = index2 >= 0 ? String.valueOf(s) + originalArg.substring(index2) : s;
                    }
                }
            }
            ++i;
        }
        if (excludeArgs != null && excludeArgs.length > 0) {
            i = 0;
            while (i < excludeArgs.length) {
                ind = excludeArgs[i].indexOf(" ");
                ind2 = excludeArgs[i].indexOf("=");
                if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                    index = originalArg.indexOf(excludeArgs[i].substring(0, ind + 1));
                    if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                        s = originalArg.substring(0, index);
                        index2 = TomcatServerBehaviour.getNextToken(originalArg, index + ind + 1);
                        if (index2 >= 0) {
                            while (index2 < originalArg.length() && originalArg.charAt(index2) == ' ') {
                                ++index2;
                            }
                            originalArg = String.valueOf(s) + originalArg.substring(index2);
                        } else {
                            originalArg = s;
                        }
                    }
                } else if (ind2 >= 0) {
                    index = originalArg.indexOf(excludeArgs[i].substring(0, ind2 + 1));
                    if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                        s = originalArg.substring(0, index);
                        index2 = TomcatServerBehaviour.getNextToken(originalArg, index);
                        if (index2 >= 0) {
                            while (index2 < originalArg.length() && originalArg.charAt(index2) == ' ') {
                                ++index2;
                            }
                            originalArg = String.valueOf(s) + originalArg.substring(index2);
                        } else {
                            originalArg = s;
                        }
                    }
                } else {
                    index = originalArg.indexOf(excludeArgs[i]);
                    if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                        s = originalArg.substring(0, index);
                        index2 = TomcatServerBehaviour.getNextToken(originalArg, index);
                        if (index2 >= 0) {
                            while (index2 < originalArg.length() && originalArg.charAt(index2) == ' ') {
                                ++index2;
                            }
                            originalArg = String.valueOf(s) + originalArg.substring(index2);
                        } else {
                            originalArg = s;
                        }
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < size) {
            if (vmArgs[i] != null) {
                if (originalArg.length() > 0 && !originalArg.endsWith(" ")) {
                    originalArg = String.valueOf(originalArg) + " ";
                }
                originalArg = String.valueOf(originalArg) + vmArgs[i];
            }
            ++i;
        }
        return originalArg;
    }

    public static void replaceJREContainer(List cp, IRuntimeClasspathEntry entry) {
        int size = cp.size();
        int i = 0;
        while (i < size) {
            IRuntimeClasspathEntry entry2 = (IRuntimeClasspathEntry)cp.get(i);
            if (entry2.getPath().uptoSegment(2).isPrefixOf(entry.getPath())) {
                cp.set(i, entry);
                return;
            }
            ++i;
        }
        cp.add(0, entry);
    }

    public static void mergeClasspath(List cp, IRuntimeClasspathEntry entry) {
        Iterator iterator = cp.iterator();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry2 = (IRuntimeClasspathEntry)iterator.next();
            if (!entry2.getPath().equals((Object)entry.getPath())) continue;
            return;
        }
        cp.add(entry);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        String existingProgArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, TomcatServerBehaviour.mergeArguments(existingProgArgs, this.getRuntimeProgramArguments(true), this.getExcludedRuntimeProgramArguments(true), true));
        String existingVMArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        String[] parsedVMArgs = null;
        if (existingVMArgs != null) {
            parsedVMArgs = DebugPlugin.parseArguments((String)existingVMArgs);
        }
        String[] configVMArgs = this.getRuntimeVMArguments();
        if (this.getTomcatServer().isSecure()) {
            boolean addSecurityArgs = true;
            if (parsedVMArgs != null) {
                int i = 0;
                while (i < parsedVMArgs.length) {
                    if (parsedVMArgs[i].startsWith("wtp.configured.security")) {
                        addSecurityArgs = false;
                        break;
                    }
                    ++i;
                }
            }
            if (addSecurityArgs) {
                String[] newVMArgs = new String[configVMArgs.length + 3];
                System.arraycopy(configVMArgs, 0, newVMArgs, 0, configVMArgs.length);
                newVMArgs[configVMArgs.length] = "-Djava.security.manager";
                newVMArgs[configVMArgs.length + 1] = "-Djava.security.policy=\"" + this.getRuntimePolicyFile() + "\"";
                newVMArgs[configVMArgs.length + 2] = "-Dwtp.configured.security=true";
                configVMArgs = newVMArgs;
            }
        } else if (parsedVMArgs != null) {
            boolean removeSecurityArgs = false;
            int i = 0;
            while (i < parsedVMArgs.length) {
                if (parsedVMArgs[i].startsWith("-Dwtp.configured.security")) {
                    removeSecurityArgs = true;
                    break;
                }
                ++i;
            }
            if (removeSecurityArgs) {
                StringBuffer filteredVMArgs = new StringBuffer();
                int i2 = 0;
                while (i2 < parsedVMArgs.length) {
                    String arg = parsedVMArgs[i2];
                    if (!(arg.startsWith("-Djava.security.manager") || arg.startsWith("-Djava.security.policy=") || arg.startsWith("-Dwtp.configured.security="))) {
                        if (filteredVMArgs.length() > 0) {
                            filteredVMArgs.append(' ');
                        }
                        filteredVMArgs.append(arg);
                    }
                    ++i2;
                }
                existingVMArgs = filteredVMArgs.toString();
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, TomcatServerBehaviour.mergeArguments(existingVMArgs, configVMArgs, null, false));
        TomcatRuntime runtime = this.getTomcatRuntime();
        IVMInstall vmInstall = runtime.getVMInstall();
        if (vmInstall != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        IRuntimeClasspathEntry[] originalClasspath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
        int size = originalClasspath.length;
        ArrayList<IRuntimeClasspathEntry> oldCp = new ArrayList<IRuntimeClasspathEntry>(originalClasspath.length + 2);
        int i = 0;
        while (i < size) {
            oldCp.add(originalClasspath[i]);
            ++i;
        }
        List cp2 = runtime.getRuntimeClasspath();
        Iterator iterator = cp2.iterator();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator.next();
            TomcatServerBehaviour.mergeClasspath(oldCp, entry);
        }
        if (vmInstall != null) {
            IPath toolsPath;
            try {
                String typeId = vmInstall.getVMInstallType().getId();
                TomcatServerBehaviour.replaceJREContainer(oldCp, JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(vmInstall.getName()), (int)2));
            }
            catch (Exception exception) {}
            Path jrePath = new Path(vmInstall.getInstallLocation().getAbsolutePath());
            if (jrePath != null && (toolsPath = jrePath.append("lib").append("tools.jar")).toFile().exists()) {
                IRuntimeClasspathEntry toolsJar = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath);
                int toolsIndex = 0;
                while (toolsIndex < oldCp.size()) {
                    IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)oldCp.get(toolsIndex);
                    if (entry.getType() == 2 && entry.getPath().lastSegment().equals("tools.jar")) break;
                    ++toolsIndex;
                }
                if (toolsIndex < oldCp.size()) {
                    oldCp.set(toolsIndex, toolsJar);
                } else {
                    TomcatServerBehaviour.mergeClasspath(oldCp, toolsJar);
                }
            }
        }
        iterator = oldCp.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator.next();
            try {
                list.add(entry.getMemento());
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not resolve classpath entry: " + entry, e);
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, list);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    protected IModuleResource[] getResources(IModule[] module) {
        return super.getResources(module);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public void handleResourceChange() {
        if (this.getServer().getServerRestartState()) {
            return;
        }
        Iterator iterator = this.getAllModules().iterator();
        while (iterator.hasNext()) {
            IModule[] module = (IModule[])iterator.next();
            IModuleResourceDelta[] delta = this.getPublishedResourceDelta(module);
            if (delta == null || delta.length == 0 || !this.containsNonResourceChange(delta)) continue;
            this.setServerRestartState(true);
            return;
        }
    }

    protected boolean containsNonResourceChange(IModuleResourceDelta[] delta) {
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IModuleResourceDelta d = delta[i];
            if (d.getModuleRelativePath().segmentCount() == 0) {
                if ("WEB-INF".equals(d.getModuleResource().getName())) {
                    return this.containsNonResourceChange(d.getAffectedChildren());
                }
            } else {
                if (d.getModuleResource() instanceof IModuleFile) {
                    return true;
                }
                boolean b = this.containsNonAddChange(d.getAffectedChildren());
                if (b) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean containsNonAddChange(IModuleResourceDelta[] delta) {
        if (delta == null) {
            return false;
        }
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IModuleResourceDelta d = delta[i];
            if (d.getModuleResource() instanceof IModuleFile && d.getKind() != 1) {
                return true;
            }
            boolean b = this.containsNonAddChange(d.getAffectedChildren());
            if (b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IStatus cleanServerWorkDir(IProgressMonitor monitor) throws CoreException {
        IStatus result;
        IPath basePath = this.getRuntimeBaseDirectory();
        IPath workPath = this.getTomcatConfiguration().getServerWorkDirectory(basePath);
        if (workPath != null) {
            File[] files;
            File workDir = workPath.toFile();
            result = Status.OK_STATUS;
            if (workDir.exists() && workDir.isDirectory() && (files = workDir.listFiles()) != null && files.length > 0) {
                MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, "Problem occurred deleting work directory for module.", null);
                int size = files.length;
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(NLS.bind((String)"Cleaning Server Work Directory", (Object[])new String[]{workDir.getAbsolutePath()}), size * 10);
                int i = 0;
                while (i < size) {
                    IStatus[] results;
                    File current = files[i];
                    if (current.isDirectory() && (results = PublishHelper.deleteDirectory((File)current, (IProgressMonitor)ProgressUtil.getSubMonitorFor(monitor, 10))) != null && results.length > 0) {
                        int j = 0;
                        while (j < results.length) {
                            ms.add(results[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
                monitor.done();
                result = ms;
            }
        } else {
            result = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, "Could not determine work directory for module", null);
        }
        return result;
    }

    public IStatus cleanContextWorkDir(ITomcatWebModule module, IProgressMonitor monitor) throws CoreException {
        Status result;
        IPath basePath = this.getRuntimeBaseDirectory();
        IPath workPath = this.getTomcatConfiguration().getContextWorkDirectory(basePath, module);
        if (workPath != null) {
            IStatus[] results = PublishHelper.deleteDirectory((File)workPath.toFile(), (IProgressMonitor)monitor);
            MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, "Problem occurred deleting work directory for module.", null);
            if (results != null && results.length > 0) {
                int i = 0;
                while (i < results.length) {
                    ms.add(results[i]);
                    ++i;
                }
            }
            result = ms;
        } else {
            result = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, "Could not determine work directory for module", null);
        }
        return result;
    }

    public IPath getServerDeployDirectory() {
        return this.getTomcatServer().getServerDeployDirectory();
    }

    public IPath getModuleDeployDirectory(IModule module) {
        return this.getServerDeployDirectory().append(module.getName());
    }

    public IPath getPublishDirectory(IModule[] module) {
        if (module == null || module.length != 1) {
            return null;
        }
        return this.getModuleDeployDirectory(module[0]);
    }

    public void setModulePublishState2(IModule[] module, int state) {
        this.setModulePublishState(module, state);
    }
}

