/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameTools {
    public static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    public static final Set<String> JAVA_RESERVED_WORDS_SET = CollectionTools.set(JAVA_RESERVED_WORDS);

    public static String uniqueJavaNameFor(String rootName, Iterator<String> existingNames) {
        Collection existingNames2 = CollectionTools.set(existingNames);
        existingNames2.addAll(JAVA_RESERVED_WORDS_SET);
        return NameTools.uniqueNameFor(rootName, existingNames2, rootName);
    }

    public static String uniqueJavaNameFor(String rootName, Collection<String> existingNames) {
        HashSet<String> existingNames2 = new HashSet<String>(existingNames);
        existingNames2.addAll(JAVA_RESERVED_WORDS_SET);
        return NameTools.uniqueNameFor(rootName, existingNames2, rootName);
    }

    public static String uniqueNameFor(String rootName, Iterator<String> existingNames) {
        return NameTools.uniqueNameFor(rootName, (Collection<String>)CollectionTools.set(existingNames));
    }

    public static String uniqueNameFor(String rootName, Collection<String> existingNames) {
        return NameTools.uniqueNameFor(rootName, existingNames, rootName);
    }

    public static String uniqueNameForIgnoreCase(String rootName, Iterator<String> existingNames) {
        return NameTools.uniqueNameForIgnoreCase(rootName, (Collection<String>)CollectionTools.set(existingNames));
    }

    public static String uniqueNameForIgnoreCase(String rootName, Collection<String> existingNames) {
        return NameTools.uniqueNameFor(rootName, NameTools.convertToLowerCase(existingNames), rootName.toLowerCase());
    }

    private static String uniqueNameFor(String rootName, Collection<String> existingNames, String templateName) {
        if (!existingNames.contains(templateName)) {
            return rootName;
        }
        String uniqueName = templateName;
        int suffix = 2;
        while (existingNames.contains(String.valueOf(uniqueName) + suffix)) {
            ++suffix;
        }
        return rootName.concat(String.valueOf(suffix));
    }

    private static Collection<String> convertToLowerCase(Collection<String> strings) {
        HashBag<String> result = new HashBag<String>(strings.size());
        for (String string : strings) {
            result.add(string.toLowerCase());
        }
        return result;
    }

    public static String buildQualifiedDatabaseObjectName(String catalog, String schema, String name) {
        if (name == null) {
            return null;
        }
        if (catalog == null && schema == null) {
            return name;
        }
        StringBuilder sb = new StringBuilder(100);
        if (catalog != null) {
            sb.append(catalog);
            sb.append('.');
        }
        if (schema != null) {
            sb.append(schema);
        }
        sb.append('.');
        sb.append(name);
        return sb.toString();
    }

    public static Iterator<String> javaReservedWords() {
        return new ArrayIterator<String>(JAVA_RESERVED_WORDS);
    }

    public static String convertToJavaIdentifier(String string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static String convertToJavaIdentifier(String string, char c) {
        if (string.length() == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS_SET.contains(string)) {
            return StringTools.capitalize(string);
        }
        return new String(NameTools.convertToJavaIdentifierInternal(string.toCharArray(), c));
    }

    public static char[] convertToJavaIdentifier(char[] string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static char[] convertToJavaIdentifier(char[] string, char c) {
        int length = string.length;
        if (length == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS_SET.contains(new String(string))) {
            return StringTools.capitalize(string);
        }
        return NameTools.convertToJavaIdentifierInternal(string, c);
    }

    private static char[] convertToJavaIdentifierInternal(char[] string, char c) {
        if (!Character.isJavaIdentifierStart(string[0])) {
            if (!Character.isJavaIdentifierStart(c)) {
                throw new IllegalArgumentException("invalid Java identifier start char: '" + c + "'");
            }
            string[0] = c;
        }
        if (!Character.isJavaIdentifierPart(c)) {
            throw new IllegalArgumentException("invalid Java identifier part char: '" + c + "'");
        }
        int i = string.length;
        while (i-- > 1) {
            if (Character.isJavaIdentifierPart(string[i])) continue;
            string[i] = c;
        }
        return string;
    }

    private NameTools() {
        throw new UnsupportedOperationException();
    }
}

