/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<E>
implements Iterator<E> {
    private final Iterator<? extends Iterator<? extends E>> iterators;
    private Iterator<? extends E> currentIterator;
    private Iterator<? extends E> lastIteratorToReturnNext;

    public CompositeIterator(Collection<? extends Iterator<? extends E>> iterators) {
        this((Iterator<Iterator<E>>)iterators.iterator());
    }

    public CompositeIterator(Iterator<? extends Iterator<? extends E>> iterators) {
        this.iterators = iterators;
    }

    public CompositeIterator(E object, Iterator<? extends E> iterator) {
        this(new Iterator[]{new SingleElementIterator<E>(object), iterator});
    }

    public CompositeIterator(Iterator<? extends E> iterator, E object) {
        this(new Iterator[]{iterator, new SingleElementIterator<E>(object)});
    }

    public CompositeIterator(Iterator<? extends E> ... iterators) {
        this((Iterator<Iterator<? extends E>>)new ArrayIterator<Iterator<? extends E>>(iterators));
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadCurrentIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        this.loadCurrentIterator();
        E result = this.currentIterator.next();
        this.lastIteratorToReturnNext = this.currentIterator;
        return result;
    }

    @Override
    public void remove() {
        if (this.lastIteratorToReturnNext == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnNext.remove();
    }

    private void loadCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterators.next();
        }
        while (!this.currentIterator.hasNext() && this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterators);
    }
}

