/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionListValueModelAdapter<E>
extends AbstractModel
implements ListValueModel<E> {
    protected final CollectionValueModel<? extends E> collectionHolder;
    protected final CollectionChangeListener collectionChangeListener;
    protected final ArrayList<E> list;

    public CollectionListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder) {
        if (collectionHolder == null) {
            throw new NullPointerException();
        }
        this.collectionHolder = collectionHolder;
        this.collectionChangeListener = this.buildCollectionChangeListener();
        this.list = new ArrayList();
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent event) {
                CollectionListValueModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionChangeEvent event) {
                CollectionListValueModelAdapter.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionChangeEvent event) {
                CollectionListValueModelAdapter.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionListValueModelAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator<E>(this.list);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listener);
    }

    @Override
    public void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "list values" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    @Override
    public void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "list values" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.list.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.list.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    protected void buildList() {
        Iterator<E> stream = this.collectionHolder.iterator();
        if (stream.hasNext()) {
            this.list.ensureCapacity(this.collectionHolder.size());
            while (stream.hasNext()) {
                this.list.add(stream.next());
            }
            this.postBuildList();
        }
    }

    protected void postBuildList() {
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("values", this.collectionChangeListener);
        this.buildList();
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("values", this.collectionChangeListener);
        this.list.clear();
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.addItemsToList(this.indexToAddItems(), (Iterable)CollectionTools.list(this.items(e)), this.list, "list values");
    }

    protected int indexToAddItems() {
        return this.list.size();
    }

    protected Iterator<E> items(CollectionChangeEvent e) {
        return e.items();
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        Iterator<E> stream = this.items(e);
        while (stream.hasNext()) {
            this.removeItemFromList(this.lastIdentityIndexOf(stream.next()), this.list, "list values");
        }
    }

    protected void collectionCleared(CollectionChangeEvent e) {
        this.clearList(this.list, "list values");
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        if (!this.list.isEmpty()) {
            ArrayList removedItems = (ArrayList)this.list.clone();
            this.list.clear();
            this.fireItemsRemoved("list values", 0, removedItems);
        }
        this.buildList();
        if (!this.list.isEmpty()) {
            this.fireItemsAdded("list values", 0, this.list);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.collectionHolder);
    }
}

