/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListValueModelAdapter<E>
extends AbstractModel
implements ListValueModel<E> {
    protected final PropertyValueModel<? extends E> valueHolder;
    protected final PropertyChangeListener propertyChangeListener;
    protected E value;
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public PropertyListValueModelAdapter(PropertyValueModel<? extends E> valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PropertyListValueModelAdapter.this.valueChanged(event.getNewValue());
            }

            public String toString() {
                return "property change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.value == null ? EmptyListIterator.instance() : new SingleElementListIterator<E>(this.value);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : 1;
    }

    @Override
    public E get(int index) {
        if (this.value == null) {
            throw this.ioobe(index, 0);
        }
        if (index > 0) {
            throw this.ioobe(index, 1);
        }
        return this.value;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this.value == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.value;
        }
        return objectArray;
    }

    @Override
    public void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listener);
    }

    @Override
    public void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "list values" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    @Override
    public void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "list values" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected IndexOutOfBoundsException ioobe(int index, int size) {
        return new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
    }

    protected void engageModel() {
        this.valueHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.value = this.valueHolder.getValue();
    }

    protected void disengageModel() {
        this.valueHolder.removePropertyChangeListener("value", this.propertyChangeListener);
        this.value = null;
    }

    protected void valueChanged(E newValue) {
        E oldValue = this.value;
        this.value = newValue;
        if (oldValue == null) {
            this.fireItemAdded("list values", 0, newValue);
        } else if (newValue == null) {
            this.fireItemRemoved("list values", 0, oldValue);
        } else {
            this.fireItemReplaced("list values", 0, newValue, oldValue);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.valueHolder);
    }
}

