/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ValMessages;

public class PerformanceCounters {
    private String _validatorId;
    private String _validatorName;
    private String _resourceName;
    private int _numberInvocations;
    private long _elapsedTime;
    private long _cpuTime;

    public PerformanceCounters(String validatorId, String validatorName, String resourceName, int numberInvocations, long elapsedTime, long cpuTime) {
        this._validatorId = validatorId;
        this._validatorName = validatorName;
        this._resourceName = resourceName;
        this._numberInvocations = numberInvocations;
        this._elapsedTime = elapsedTime;
        this._cpuTime = cpuTime;
    }

    public String getValidatorId() {
        return this._validatorId;
    }

    public int getNumberInvocations() {
        return this._numberInvocations;
    }

    public long getElapsedTime() {
        return this._elapsedTime;
    }

    public long getCpuTime() {
        return this._cpuTime;
    }

    public String toString() {
        return NLS.bind((String)ValMessages.LogValEndTime, (Object[])new Object[]{this._validatorName, this._validatorId, this._resourceName, Misc.getTimeMS(this._elapsedTime)});
    }

    public String toString(boolean asSummary) {
        if (asSummary) {
            if (this._cpuTime != -1L) {
                return NLS.bind((String)ValMessages.LogValSummary2, (Object[])new Object[]{this._validatorName, this._validatorId, this._numberInvocations, Misc.getTimeMS(this._elapsedTime), Misc.getTimeNano(this._cpuTime)});
            }
            return NLS.bind((String)ValMessages.LogValSummary, (Object[])new Object[]{this._validatorName, this._validatorId, this._numberInvocations, Misc.getTimeMS(this._elapsedTime)});
        }
        return this.toString();
    }

    public String getValidatorName() {
        return this._validatorName;
    }
}

