/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.IPerformanceMonitor;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.DependencyIndex;
import org.eclipse.wst.validation.internal.DisabledResourceManager;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.PerformanceMonitor;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationRunner;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationFramework {
    private IDependencyIndex _dependencyIndex;
    private IPerformanceMonitor _performanceMonitor;
    private Set<IProject> _suspendedProjects;
    private boolean _suspendAllValidation;
    private static ValidationFramework _me;

    public static ValidationFramework getDefault() {
        if (_me == null) {
            _me = new ValidationFramework();
        }
        return _me;
    }

    private ValidationFramework() {
    }

    public void clearMessages(IResource resource, String validatorId) throws CoreException {
        Validator v = this.getValidator(validatorId, null);
        if (v != null) {
            MarkerManager.getDefault().clearMarker(resource, v);
        }
    }

    public void disableValidation(IResource resource) {
        assert (resource != null);
        DisabledResourceManager.getDefault().disableValidation(resource);
    }

    public void enableValidation(IResource resource) {
        DisabledResourceManager.getDefault().enableValidation(resource);
    }

    public IDependencyIndex getDependencyIndex() {
        if (this._dependencyIndex != null) {
            return this._dependencyIndex;
        }
        return this.getDependencyIndex2();
    }

    private synchronized IDependencyIndex getDependencyIndex2() {
        if (this._dependencyIndex == null) {
            this._dependencyIndex = new DependencyIndex();
        }
        return this._dependencyIndex;
    }

    public synchronized IPerformanceMonitor getPerformanceMonitor() {
        if (this._performanceMonitor == null) {
            boolean traceTimes = Misc.debugOptionAsBoolean("org.eclipse.wst.validation/timings");
            String traceFile = Platform.getDebugOption((String)"org.eclipse.wst.validation/timings/tracefile");
            this._performanceMonitor = PerformanceMonitor.create(traceTimes, traceFile);
        }
        return this._performanceMonitor;
    }

    public IEclipsePreferences getPreferenceStore() {
        return new InstanceScope().getNode("org.eclipse.wst.validation");
    }

    public IReporter getReporter(IProject project, IProgressMonitor monitor) {
        return new WorkbenchReporter(project, monitor);
    }

    public Validator[] getValidatorsFor(IResource resource, boolean isManual, boolean isBuild) {
        IProject project = resource.getProject();
        LinkedList<Validator> list = new LinkedList<Validator>();
        Validator[] validatorArray = ValManager.getDefault().getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (val.shouldValidate(resource, isManual, isBuild)) {
                list.add(val);
            }
            ++n2;
        }
        Validator[] result = new Validator[list.size()];
        list.toArray(result);
        return result;
    }

    public Set<Validator> getDisabledValidatorsFor(IResource resource) {
        IProject project = resource.getProject();
        HashSet<Validator> set = new HashSet<Validator>(10);
        Validator[] validatorArray = ValManager.getDefault().getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            boolean validateIt = false;
            if (val.shouldValidate(resource, false, false)) {
                boolean bl = validateIt = val.isBuildValidation() || val.isManualValidation();
            }
            if (!validateIt) {
                set.add(val);
            }
            ++n2;
        }
        return set;
    }

    public Validator getValidator(String id) {
        return ValManager.getDefault().getValidatorWithId(id, null);
    }

    public Validator getValidator(String id, IProject project) {
        return ValManager.getDefault().getValidatorWithId(id, project);
    }

    public Validator[] getValidatorsFor(IResource resource) {
        LinkedList<Validator> list = new LinkedList<Validator>();
        Validator[] validatorArray = this.getValidatorsFor(resource, false, false);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.isBuildValidation() || v.isManualValidation()) {
                list.add(v);
            }
            ++n2;
        }
        Validator[] vals = new Validator[list.size()];
        return list.toArray(vals);
    }

    public boolean hasValidators(IResource resource, boolean isManual, boolean isBuild) {
        return ValManager.getDefault().hasValidators(resource, isManual, isBuild);
    }

    public void join(IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
        Job.getJobManager().join(ValidationBuilder.FAMILY_VALIDATION_JOB, monitor);
    }

    public void suspendValidation(IProject project, boolean suspend) {
        if (project == null) {
            return;
        }
        if (suspend) {
            this.getSuspendedProjects().add(project);
        } else {
            this.getSuspendedProjects().remove(project);
        }
    }

    private synchronized Set<IProject> getSuspendedProjects() {
        if (this._suspendedProjects == null) {
            this._suspendedProjects = Collections.synchronizedSet(new HashSet(20));
        }
        return this._suspendedProjects;
    }

    public void suspendAllValidation(boolean suspend) {
        this._suspendAllValidation = suspend;
    }

    public boolean isSuspended() {
        return this._suspendAllValidation;
    }

    public boolean isSuspended(IProject project) {
        if (this._suspendAllValidation) {
            return true;
        }
        if (project == null) {
            return false;
        }
        return this.getSuspendedProjects().contains(project);
    }

    public boolean isProjectSuspended(IProject project) {
        if (project == null) {
            return false;
        }
        return this.getSuspendedProjects().contains(project);
    }

    public ValidationResults validate(IProject[] projects, boolean isManual, boolean isBuild, IProgressMonitor monitor) throws CoreException {
        ValType type = ValType.Build;
        if (isManual) {
            type = ValType.Manual;
        }
        ValOperation vo = ValidationRunner.validate(this.createMap(projects), type, monitor);
        return vo.getResults();
    }

    private Map<IProject, Set<IResource>> createMap(IProject[] projects) throws CoreException {
        HashMap<IProject, Set<IResource>> map = new HashMap<IProject, Set<IResource>>(1000);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            HashSet<IResource> set = new HashSet<IResource>(1000);
            ResourceAdder ra = new ResourceAdder(set);
            p.accept((IResourceVisitor)ra);
            map.put(p, set);
            ++n2;
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceAdder
    implements IResourceVisitor {
        private Set<IResource> _set;

        public ResourceAdder(Set<IResource> set) {
            this._set = set;
        }

        public boolean visit(IResource resource) throws CoreException {
            this._set.add(resource);
            return true;
        }
    }
}

