/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.ReporterHelper;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.NullValidator;
import org.eclipse.wst.validation.internal.SummaryReporter;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValOperationManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorExtensionReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Validator
implements Comparable {
    protected boolean _buildValidation = true;
    private String _delegatingId;
    private String _sourceId;
    protected boolean _manualValidation = true;
    private String _markerId;
    private int _version = 1;
    private Map<String, MessageSeveritySetting> _messageSettings;
    protected IProject _project;
    protected transient int _changeCountGlobal;
    protected transient int _changeCountMessages;

    public static Validator create(IConfigurationElement validator, IProject project) {
        V2 v2 = new V2(validator, project);
        return v2;
    }

    public static Validator create(ValidatorMetaData vmd, ValidationConfiguration config, IProject project) {
        V1 v1 = new V1(vmd, config);
        v1._project = project;
        return v1;
    }

    public V1 asV1Validator() {
        return null;
    }

    public V2 asV2Validator() {
        return null;
    }

    public void clean(IProject project, IProgressMonitor monitor) {
    }

    public int compareTo(Object validator) {
        if (validator instanceof Validator) {
            Validator other = (Validator)validator;
            return this.getName().compareTo(other.getName());
        }
        return -1;
    }

    public abstract Validator copy();

    protected void copyLocal(Validator v) {
        this._buildValidation = v._buildValidation;
        this._delegatingId = v._delegatingId;
        this._manualValidation = v._manualValidation;
        this._markerId = v._markerId;
        this._messageSettings = v._messageSettings;
        this._project = v._project;
        this._sourceId = v._sourceId;
        this._version = v._version;
    }

    public boolean shouldValidate(IResource resource, boolean isManual, boolean isBuild) {
        if (isManual && !this._manualValidation) {
            return false;
        }
        if (isBuild && !this._buildValidation) {
            return false;
        }
        return this.shouldValidate(resource);
    }

    public boolean shouldValidate(IResource resource, ValType valType) {
        if (valType == ValType.Manual && !this._manualValidation) {
            return false;
        }
        if (valType == ValType.Build && !this._buildValidation) {
            return false;
        }
        return this.shouldValidate(resource);
    }

    public boolean shouldValidateProject(IProject project, ValType type) {
        return this.shouldValidateProject(project, type == ValType.Manual, type == ValType.Build);
    }

    public boolean shouldValidateProject(IProject project, boolean isManual, boolean isBuild) {
        if (isManual && !this._manualValidation) {
            return false;
        }
        if (isBuild && !this._buildValidation) {
            return false;
        }
        if (project == null || !project.isOpen()) {
            return false;
        }
        return this.shouldValidateProject(project);
    }

    public abstract ValidationResult validate(IResource var1, int var2, ValOperation var3, IProgressMonitor var4);

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
    }

    void add(MessageSeveritySetting message) {
        if (this._messageSettings == null) {
            this._messageSettings = new HashMap<String, MessageSeveritySetting>(10);
        }
        this._messageSettings.put(message.getId(), message);
        this.bumpChangeCountMessages();
    }

    public IValidator asIValidator() {
        return null;
    }

    protected abstract boolean shouldValidate(IResource var1);

    protected abstract boolean shouldValidateProject(IProject var1);

    public abstract String getId();

    public MessageSeveritySetting getMessage(String id) {
        return this.getMessageSettings().get(id);
    }

    public Map<String, MessageSeveritySetting> getMessageSettings() {
        Map<String, MessageSeveritySetting> settings = this._messageSettings;
        if (settings == null) {
            settings = new HashMap<String, MessageSeveritySetting>(10);
            this.init(settings);
            if (ValManager.getDefault().mustUseGlobalValidators(this.getProject())) {
                ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
                gp.loadMessages(this, settings);
            } else {
                ValPrefManagerProject vp = new ValPrefManagerProject(this.getProject());
                vp.loadMessages(this, settings);
            }
            this._messageSettings = settings;
        }
        return settings;
    }

    public int hashCodeForConfig() {
        int h = 0;
        if (this._buildValidation) {
            h += 101;
        }
        if (this._delegatingId != null) {
            h += this._delegatingId.hashCode();
        }
        if (this._manualValidation) {
            h += 201;
        }
        if (this._messageSettings != null) {
            for (MessageSeveritySetting ms : this._messageSettings.values()) {
                h += ms.hashCode();
            }
        }
        if (this._sourceId != null) {
            h += this._sourceId.hashCode();
        }
        return h += this._version;
    }

    private void init(Map<String, MessageSeveritySetting> settings) {
        for (MessageSeveritySetting ms : ValidatorExtensionReader.getDefault().addMessages(this)) {
            settings.put(ms.getId(), ms);
        }
    }

    public abstract String getName();

    public IProject getProject() {
        return this._project;
    }

    public abstract String getValidatorClassname();

    public boolean isManualValidation() {
        return this._manualValidation;
    }

    public void setManualValidation(boolean manualValidation) {
        this.setManualValidation2(manualValidation);
    }

    protected final void setManualValidation2(boolean manualValidation) {
        if (this._manualValidation != manualValidation) {
            this.bumpChangeCountGlobal();
            this._manualValidation = manualValidation;
        }
    }

    public boolean isBuildValidation() {
        return this._buildValidation;
    }

    public boolean isChanged() {
        return this._changeCountGlobal > 0 || this._changeCountMessages > 0;
    }

    abstract boolean isLoaded();

    public void setBuildValidation(boolean buildValidation) {
        this.setBuildValidation2(buildValidation);
    }

    protected final void setBuildValidation2(boolean buildValidation) {
        if (this._buildValidation != buildValidation) {
            this.bumpChangeCountGlobal();
            this._buildValidation = buildValidation;
        }
    }

    public String getDelegatingId() {
        return this._delegatingId;
    }

    public void setDelegatingId(String delegating) {
        if (!Misc.same(this._delegatingId, delegating)) {
            this._delegatingId = delegating;
            this.bumpChangeCountGlobal();
        }
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        if (this._version != version) {
            this._version = version;
            this.bumpChangeCountGlobal();
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getSourceId() {
        return this._sourceId;
    }

    public void setSourceId(String sourceId) {
        if (!Misc.same(this._sourceId, sourceId)) {
            this._sourceId = sourceId;
            this.bumpChangeCountGlobal();
        }
    }

    public void become(Validator validator) {
        this._buildValidation = validator._buildValidation;
        this._delegatingId = validator._delegatingId;
        this._manualValidation = validator._manualValidation;
        this._markerId = validator._markerId;
        this._messageSettings = validator._messageSettings;
        this._project = validator._project;
        this._sourceId = validator._sourceId;
        this._version = validator._version;
        this._changeCountGlobal = validator._changeCountGlobal;
        this._changeCountMessages = validator._changeCountMessages;
    }

    void setMessages(Map<String, MessageSeveritySetting> map) {
        this._messageSettings = map;
        this.bumpChangeCountMessages();
    }

    public int getChangeCountGlobal() {
        return this._changeCountGlobal;
    }

    public int getChangeCountMessages() {
        return this._changeCountMessages;
    }

    public void bumpChangeCountMessages() {
        ++this._changeCountMessages;
    }

    public void resetChangeCounters() {
        this._changeCountGlobal = 0;
        this._changeCountMessages = 0;
    }

    public void bumpChangeCountGlobal() {
        ++this._changeCountGlobal;
    }

    public boolean sameConfig(Validator validator) {
        if (validator == null) {
            return false;
        }
        return this.hashCodeForConfig() == validator.hashCodeForConfig();
    }

    public String getMarkerId() {
        return this._markerId;
    }

    public void setMarkerId(String markerId) {
        this._markerId = markerId;
        if (markerId != null) {
            MarkerManager.getDefault().getMarkers().add(markerId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        Extension,
        Global,
        Project;

    }

    public static class V1
    extends Validator {
        private ValidatorMetaData _vmd;

        public V1(ValidatorMetaData vmd, ValidationConfiguration config) {
            this._vmd = vmd;
            if (config != null) {
                this.setBuildValidation(config.isBuildEnabled(vmd));
                this.setManualValidation(config.isManualEnabled(vmd));
            }
            this.setDelegatingId(ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(this._vmd.getValidatorUniqueName()));
            if (this._vmd.getMarkerIds() != null && this._vmd.getMarkerIds().length > 0) {
                this.setMarkerId(this._vmd.getMarkerIds()[0]);
            }
            this.resetChangeCounters();
        }

        public IValidator asIValidator() {
            IValidator v = null;
            try {
                v = this._vmd.getValidator();
            }
            catch (InstantiationException e) {
                ValidationPlugin.getPlugin().handleException(e);
                return null;
            }
            return v;
        }

        public V1 asV1Validator() {
            return this;
        }

        public void become(Validator val) {
            super.become(val);
            V1 v1 = val.asV1Validator();
            if (v1 == null) {
                throw new IllegalArgumentException("Internal error, the incoming validator must be a v1 validator");
            }
            this._vmd = v1._vmd;
        }

        public Validator copy() {
            V1Copy v = new V1Copy(this._vmd, null);
            v.copyLocal(this);
            return v;
        }

        public String getName() {
            return this._vmd.getValidatorDisplayName();
        }

        public ValidatorMetaData getVmd() {
            return this._vmd;
        }

        public String getValidatorClassname() {
            String name = "";
            try {
                name = this._vmd.getValidator().getClass().getName();
            }
            catch (Exception exception) {}
            return name;
        }

        public String getId() {
            return this._vmd.getValidatorUniqueName();
        }

        boolean isLoaded() {
            return this._vmd.isActive();
        }

        public void setBuildValidation(boolean buildValidation) {
            super.setBuildValidation(buildValidation);
            this._vmd.setBuildValidation(buildValidation);
        }

        public void setManualValidation(boolean manualValidation) {
            super.setManualValidation(manualValidation);
            this._vmd.setManualValidation(manualValidation);
        }

        protected boolean shouldValidate(IResource resource) {
            return this._vmd.isApplicableTo(resource);
        }

        protected boolean shouldValidateProject(IProject project) {
            return true;
        }

        public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ValidationResult vr = new ValidationResult();
            IValidator v = this.asIValidator();
            if (v == null) {
                return null;
            }
            try {
                IProject project = resource.getProject();
                SummaryReporter reporter = new SummaryReporter(project, monitor);
                IWorkbenchContext helper = this._vmd.getHelper(project);
                if (helper instanceof WorkbenchContext) {
                    WorkbenchContext wc = (WorkbenchContext)helper;
                    LinkedList<String> files = new LinkedList<String>();
                    files.add(wc.getPortableName(resource));
                    wc.setValidationFileURIs(files);
                }
                ValidatorLauncher.getLauncher().start(helper, v, reporter);
                vr.incrementError(reporter.getSeverityHigh());
                vr.incrementWarning(reporter.getSeverityNormal());
                vr.incrementInfo(reporter.getSeverityLow());
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            return vr;
        }

        public static class V1Copy
        extends V1 {
            public V1Copy(ValidatorMetaData vmd, ValidationConfiguration vc) {
                super(vmd, vc);
            }

            public void setManualValidation(boolean bool) {
                this.setManualValidation2(bool);
            }

            public void setBuildValidation(boolean bool) {
                this.setBuildValidation2(bool);
            }

            public void become(Validator val) {
                super.become(val);
                super.setBuildValidation(val.isBuildValidation());
                super.setManualValidation(val.isManualValidation());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class V2
    extends Validator
    implements IAdaptable {
        private AbstractValidator _validator;
        private List<FilterGroup> _groups = new LinkedList<FilterGroup>();
        private FilterGroup[] _groupsArray;
        private String _id;
        private String _name;
        private IConfigurationElement _validatorConfigElement;
        private String _validatorClassName;
        private AbstractValidator _delegated;
        protected transient int _changeCountGroups;
        private Level _level;

        V2(IConfigurationElement configElement, IProject project) {
            assert (configElement != null);
            this._validatorConfigElement = configElement;
            this._validatorClassName = configElement.getAttribute("class");
            this._project = project;
            this.init();
        }

        private V2(IProject project, String validatorClassName, AbstractValidator validator) {
            assert (validator != null);
            this._project = project;
            this._validatorClassName = validatorClassName;
            this._validator = validator;
            this.init();
        }

        private void init() {
            try {
                String id = ConfigurationManager.getManager().getConfiguration(this._project).getDelegateForTarget(this._validatorClassName);
                if (id == null) {
                    id = ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(this._validatorClassName);
                }
                this.setDelegatingId(id);
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            this.resetChangeCounters();
        }

        public synchronized void add(FilterGroup fg) {
            this._groupsArray = null;
            this._groups.add(fg);
            this.bumpChangeCountGroups();
        }

        @Override
        public IValidator asIValidator() {
            AbstractValidator av = this.getDelegatedValidator();
            if (av instanceof IValidator) {
                return (IValidator)((Object)av);
            }
            return super.asIValidator();
        }

        @Override
        public V2 asV2Validator() {
            return this;
        }

        @Override
        public void clean(IProject project, IProgressMonitor monitor) {
            this.getDelegatedValidator().clean(project, ValOperationManager.getDefault().getOperation().getState(), monitor);
        }

        @Override
        public Validator copy() {
            V2 v = null;
            v = this._validatorConfigElement != null ? new V2(this._validatorConfigElement, this._project) : new V2(this._project, this._validatorClassName, this._validator);
            v.copyLocal(this);
            FilterGroup[] groups = this.getGroups();
            v._groupsArray = new FilterGroup[groups.length];
            int i = 0;
            while (i < groups.length) {
                v._groupsArray[i] = groups[i].copy();
                v._groups.add(v._groupsArray[i]);
                ++i;
            }
            v._id = this._id;
            v._name = this._name;
            return v;
        }

        public int getChangeCountGroups() {
            return this._changeCountGroups;
        }

        public void bumpChangeCountGroups() {
            ++this._changeCountGroups;
        }

        public Level getLevel() {
            return this._level;
        }

        public void setLevel(Level level) {
            assert (this._level == null);
            this._level = level;
        }

        public AbstractValidator getDelegatedValidator() {
            AbstractValidator delegated = this._delegated;
            if (delegated != null) {
                return delegated;
            }
            if (this.getDelegatingId() == null) {
                return this.getValidator();
            }
            try {
                ValidatorDelegateDescriptor vdd = ValidatorDelegatesRegistry.getInstance().getDescriptor(this.getValidatorClassname(), this.getDelegatingId());
                if (vdd == null) {
                    return this.getValidator();
                }
                delegated = vdd.getValidator2();
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
                delegated = new NullValidator();
            }
            delegated.setParent(this);
            this._delegated = delegated;
            return delegated;
        }

        @Override
        public String getId() {
            return this._id;
        }

        public synchronized FilterGroup[] getGroups() {
            FilterGroup[] groups = this._groupsArray;
            if (groups == null) {
                groups = new FilterGroup[this._groups.size()];
                this._groups.toArray(groups);
                this._groupsArray = groups;
            }
            return groups;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public AbstractValidator getValidator() {
            if (this._validator == null) {
                try {
                    this._validator = (AbstractValidator)this._validatorConfigElement.createExecutableExtension("class");
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    IContributor contrib = this._validatorConfigElement.getContributor();
                    String message = NLS.bind((String)ValMessages.ErrConfig, (Object)contrib.getName());
                    ValidationPlugin.getPlugin().logMessage(4, message);
                    this._validator = new NullValidator();
                }
                this._validator.setParent(this);
                this._validatorConfigElement = null;
            }
            return this._validator;
        }

        @Override
        public String getValidatorClassname() {
            return this._validatorClassName;
        }

        @Override
        public int hashCodeForConfig() {
            int h = super.hashCodeForConfig();
            if (this._id != null) {
                h += this._id.hashCode();
            }
            if (this._groups != null) {
                for (FilterGroup fg : this._groups) {
                    h += fg.hashCodeForConfig();
                }
            }
            return h;
        }

        @Override
        public boolean isChanged() {
            if (this._changeCountGroups > 0) {
                return true;
            }
            return super.isChanged();
        }

        @Override
        boolean isLoaded() {
            return this._validator != null;
        }

        @Override
        protected boolean shouldValidate(IResource resource) {
            FilterGroup[] groups = this.getGroups();
            IProject project = resource.getProject();
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                if (!group.shouldValidate(project, resource)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public void setDelegatingId(String delegating) {
            super.setDelegatingId(delegating);
            this._delegated = null;
        }

        public synchronized void setGroups(List<FilterGroup> groups) {
            this._groups = groups;
            this._groupsArray = null;
            this.bumpChangeCountGroups();
        }

        public void setId(String id) {
            if (!Misc.same(this._id, id)) {
                this._id = id;
                this.bumpChangeCountGlobal();
            }
        }

        public void setName(String name) {
            if (!Misc.same(this._name, name)) {
                this._name = name;
                this.bumpChangeCountGlobal();
            }
        }

        @Override
        public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor) {
            ValidationResult vr = null;
            if (operation == null) {
                operation = new ValOperation();
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                vr = this.getDelegatedValidator().validate(resource, kind, operation.getState(), monitor);
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            if (vr != null) {
                ValidatorMessage[] msgs;
                IResource[] validated;
                if (vr.getValidationException() != null) {
                    ValidationPlugin.getPlugin().handleException(vr.getValidationException());
                }
                this.updateResults(vr);
                if (vr.getDependsOn() != null) {
                    ValidationFramework.getDefault().getDependencyIndex().set(this.getId(), resource, vr.getDependsOn());
                }
                if ((validated = vr.getValidated()) != null) {
                    int i = 0;
                    while (i < validated.length) {
                        operation.addValidated(this.getId(), validated[i]);
                        ++i;
                    }
                }
                if (this.sanityTest((msgs = vr.getMessages()).length, resource)) {
                    MarkerManager mm = MarkerManager.getDefault();
                    ValidatorMessage[] validatorMessageArray = msgs;
                    int n = msgs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ValidatorMessage m = validatorMessageArray[n2];
                        mm.createMarker(m, this.getId());
                        ++n2;
                    }
                } else {
                    this.setBuildValidation(false);
                    this.setManualValidation(false);
                }
            }
            return vr;
        }

        private boolean sanityTest(int numberofMessages, IResource resource) {
            if (numberofMessages < 201) {
                return true;
            }
            String resName = "";
            if (resource != null) {
                resName = resource.getName();
            }
            String message = NLS.bind((String)ValMessages.ConfigError, (Object[])new Object[]{this.getName(), this.getId(), String.valueOf(numberofMessages), resName});
            ValidationPlugin.getPlugin().logMessage(4, message);
            return false;
        }

        private void updateResults(ValidationResult vr) {
            ReporterHelper rh = vr.getReporterHelper();
            if (rh == null) {
                return;
            }
            for (IMessage message : rh.getMessages()) {
                HashMap attributes;
                Object target = message.getTargetObject();
                if (target == null) continue;
                IResource res = null;
                if (target instanceof IResource) {
                    res = (IResource)target;
                }
                if (res == null && (target = message.getAttribute("TargetResource")) != null && target instanceof IResource) {
                    res = (IResource)target;
                }
                if (res == null) continue;
                ValidatorMessage vm = ValidatorMessage.create(message.getText(), res);
                if (this.getMarkerId() != null) {
                    vm.setType(this.getMarkerId());
                }
                vr.add(vm);
                int markerSeverity = 0;
                int sev = message.getSeverity();
                if ((sev & 1) != 0) {
                    markerSeverity = 2;
                } else if ((sev & 2) != 0) {
                    markerSeverity = 1;
                }
                vm.setAttribute("severity", markerSeverity);
                vm.setAttribute("lineNumber", message.getLineNumber());
                int offset = message.getOffset();
                if (offset != -1) {
                    vm.setAttribute("charStart", offset);
                    int len = message.getLength();
                    if (len != -1) {
                        vm.setAttribute("charStart", offset);
                        vm.setAttribute("charEnd", offset + len);
                    }
                }
                if ((attributes = message.getAttributes()) == null) continue;
                for (Map.Entry me : attributes.entrySet()) {
                    String key = (String)me.getKey();
                    vm.setAttribute(key, me.getValue());
                }
            }
        }

        @Override
        public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
            this.getDelegatedValidator().validationStarting(project, state, monitor);
        }

        @Override
        public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
            this.getDelegatedValidator().validationFinishing(project, state, monitor);
        }

        public Object getAdapter(Class adapter) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public synchronized void remove(FilterGroup group) {
            this._groups.remove(group);
            this._groupsArray = null;
            this.bumpChangeCountGroups();
        }

        @Override
        public void resetChangeCounters() {
            super.resetChangeCounters();
            this._changeCountGroups = 0;
        }

        @Override
        protected boolean shouldValidateProject(IProject project) {
            FilterGroup[] groups;
            FilterGroup[] filterGroupArray = groups = this.getGroups();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                if (!group.shouldValidate(project, null)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public void become(Validator val) {
            super.become(val);
            V2 v2 = val.asV2Validator();
            if (v2 == null) {
                throw new IllegalArgumentException(ValMessages.Error20);
            }
            this._changeCountGroups = v2._changeCountGroups;
            this._delegated = v2._delegated;
            this._groups = v2._groups;
            this._groupsArray = v2._groupsArray;
            this._id = v2._id;
            this._name = v2._name;
            this._validator = v2._validator;
            this._validatorConfigElement = v2._validatorConfigElement;
            this._validatorClassName = v2._validatorClassName;
        }
    }
}

