/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.DependentResource;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyIndex
implements IDependencyIndex,
ISaveParticipant {
    private Map<IPath, Map<IResource, Depends>> _dependsMap;
    private Map<IProject, List<Depends>> _projectMap;
    private boolean _dirty;
    private static IResource[] EmptyResources = new IResource[0];
    private static final int CurrentVersion = 1;

    @Override
    public synchronized void add(String id, IResource dependent, IResource dependsOn) {
        this.init();
        IPath dependsOnPath = dependsOn.getFullPath();
        this.add(id, dependent, dependsOnPath);
    }

    private void add(String id, IResource dependent, IPath dependsOn) {
        Depends d;
        Map<IResource, Depends> depends = this._dependsMap.get(dependsOn);
        if (depends == null) {
            depends = new HashMap<IResource, Depends>(5);
            this._dependsMap.put(dependsOn, depends);
        }
        if ((d = depends.get(dependent)) == null) {
            d = new Depends();
            depends.put(dependent, d);
        }
        if (d.hasValidator(id)) {
            return;
        }
        d.add(id);
        this._dirty = true;
        List<Depends> list = this._projectMap.get(dependent.getProject());
        if (list == null) {
            list = new LinkedList<Depends>();
            this._projectMap.put(dependent.getProject(), list);
        }
        list.add(d);
    }

    private void init() {
        block12: {
            if (this._dependsMap != null) {
                return;
            }
            File f = this.getIndexLocation();
            if (!f.exists()) {
                this._dependsMap = new HashMap<IPath, Map<IResource, Depends>>(100);
                this._projectMap = new HashMap<IProject, List<Depends>>(50);
            } else {
                DataInputStream in = null;
                try {
                    try {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        in = new DataInputStream(new FileInputStream(f));
                        int version = in.readInt();
                        if (version != 1) {
                            String msg = NLS.bind((String)ValMessages.ErrDependencyVersion, (Object)1);
                            throw new IllegalStateException(msg);
                        }
                        int numDependsOn = in.readInt();
                        this._dependsMap = new HashMap<IPath, Map<IResource, Depends>>(numDependsOn + 100);
                        this._projectMap = new HashMap<IProject, List<Depends>>(50);
                        int i = 0;
                        while (i < numDependsOn) {
                            String v = in.readUTF();
                            IPath dependsOn = Path.fromPortableString((String)v);
                            int numDependents = in.readInt();
                            int j = 0;
                            while (j < numDependents) {
                                v = in.readUTF();
                                IResource dependent = root.findMember(v);
                                int numVal = in.readInt();
                                int k = 0;
                                while (k < numVal) {
                                    String id = in.readUTF();
                                    this.add(id, dependent, dependsOn);
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        ValidationPlugin.getPlugin().handleException(e);
                        Misc.close(in);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Misc.close(in);
                    throw throwable;
                }
                Misc.close(in);
            }
        }
    }

    @Override
    public synchronized void clear(IProject project) {
        this.init();
        List<Depends> list = this._projectMap.get(project);
        if (list == null) {
            return;
        }
        this._dirty = true;
        for (Depends d : list) {
            d.delete();
        }
    }

    @Override
    public synchronized IResource[] get(String id, IResource dependsOn) {
        this.init();
        Map<IResource, Depends> map = this._dependsMap.get(dependsOn.getFullPath());
        if (map == null) {
            return EmptyResources;
        }
        LinkedList<IResource> list = new LinkedList<IResource>();
        for (Map.Entry<IResource, Depends> me : map.entrySet()) {
            if (!me.getValue().hasValidator(id)) continue;
            list.add(me.getKey());
        }
        if (list.size() == 0) {
            return EmptyResources;
        }
        IResource[] resources = new IResource[list.size()];
        list.toArray(resources);
        return resources;
    }

    @Override
    public synchronized List<DependentResource> get(IResource dependsOn) {
        this.init();
        LinkedList<DependentResource> list = new LinkedList<DependentResource>();
        Map<IResource, Depends> map = this._dependsMap.get(dependsOn.getFullPath());
        ValManager vm = ValManager.getDefault();
        if (map != null) {
            for (Map.Entry<IResource, Depends> me : map.entrySet()) {
                for (String id : me.getValue().getValidatorsEnabled()) {
                    IResource res;
                    Validator v = vm.getValidator(id, (res = me.getKey()).getProject());
                    if (v == null) continue;
                    list.add(new DependentResource(res, v));
                }
            }
        }
        return list;
    }

    @Override
    public synchronized void set(String id, IResource dependent, IResource[] dependsOn) {
        IResource[] iResourceArray = dependsOn;
        int n = dependsOn.length;
        int n2 = 0;
        while (n2 < n) {
            IResource d = iResourceArray[n2];
            this.add(id, dependent, d);
            ++n2;
        }
    }

    @Override
    public boolean isDependedOn(IResource resource) {
        this.init();
        return this._dependsMap.containsKey(resource.getFullPath());
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        block9: {
            if (!this._dirty) {
                return;
            }
            this._dirty = false;
            DataOutputStream out = null;
            try {
                try {
                    File f = this.getIndexLocation();
                    out = new DataOutputStream(new FileOutputStream(f));
                    out.writeInt(1);
                    out.writeInt(this._dependsMap.size());
                    for (Map.Entry<IPath, Map<IResource, Depends>> me : this._dependsMap.entrySet()) {
                        IPath key = me.getKey();
                        out.writeUTF(key.toString());
                        Map<IResource, Depends> map = me.getValue();
                        out.writeInt(map.size());
                        for (Map.Entry<IResource, Depends> me2 : map.entrySet()) {
                            int vc = me2.getValue().validatorCount();
                            if (vc == 0) continue;
                            IResource key2 = me2.getKey();
                            out.writeUTF(key2.getFullPath().toString());
                            Map map3 = me2.getValue().getValidators();
                            out.writeInt(vc);
                            for (Map.Entry me3 : map3.entrySet()) {
                                if (!((Boolean)me3.getValue()).booleanValue()) continue;
                                out.writeUTF((String)me3.getKey());
                            }
                        }
                    }
                }
                catch (IOException e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    Misc.close(out);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Misc.close(out);
                throw throwable;
            }
            Misc.close(out);
        }
    }

    private File getIndexLocation() {
        IPath path = ValidationPlugin.getPlugin().getStateLocation().append("dep.index");
        return path.toFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Depends {
        private Map<String, Boolean> _validators = new HashMap<String, Boolean>(5);

        private Depends() {
        }

        private Map<String, Boolean> getValidators() {
            return this._validators;
        }

        private List<String> getValidatorsEnabled() {
            LinkedList<String> list = new LinkedList<String>();
            for (Map.Entry<String, Boolean> me : this._validators.entrySet()) {
                if (!me.getValue().booleanValue()) continue;
                list.add(me.getKey());
            }
            return list;
        }

        private void delete() {
            this._validators.clear();
        }

        private void add(String id) {
            this._validators.put(id, Boolean.TRUE);
        }

        private boolean hasValidator(String id) {
            Boolean v = this._validators.get(id);
            if (v == null) {
                return false;
            }
            return v;
        }

        private int validatorCount() {
            int count = 0;
            for (Boolean b : this._validators.values()) {
                if (!b.booleanValue()) continue;
                ++count;
            }
            return count;
        }
    }
}

