/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class Tracing {
    private static DateFormat _df = new SimpleDateFormat("HH:mm:ss.SSSS");
    private static boolean _forceLogging;
    private static Boolean _traceMatches;
    private static Boolean _traceV1;

    public static boolean isLogging() {
        return _forceLogging || ValidationPlugin.getPlugin().isDebugging();
    }

    public static boolean isTraceMatches() {
        if (_traceMatches == null) {
            _traceMatches = Misc.debugOptionAsBoolean("org.eclipse.wst.validation/matches");
        }
        return _traceMatches;
    }

    public static boolean isTraceV1() {
        if (_traceV1 == null) {
            _traceV1 = Misc.debugOptionAsBoolean("org.eclipse.wst.validation/v1");
        }
        return _traceV1;
    }

    public static void log(String line) {
        if (Tracing.isLogging()) {
            Tracing.write(line);
        }
    }

    public static void log(String ... parts) {
        if (Tracing.isLogging()) {
            StringBuffer b = new StringBuffer(200);
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                b.append(p);
                ++n2;
            }
            Tracing.write(b.toString());
        }
    }

    public static void write(String line) {
        System.err.println(Tracing.timestampIt(line));
    }

    public static String timestampIt(String line) {
        Date date = new Date();
        long thread = Thread.currentThread().getId();
        return String.valueOf(_df.format(date)) + " " + thread + " " + line;
    }

    public static void log(StringBuffer b) {
        Tracing.log(b.toString());
        b.setLength(0);
    }

    public static void setForceLogging(boolean forceLogging) {
        _forceLogging = forceLogging;
    }
}

