/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.validation.DependentResource;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.DisabledResourceManager;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.ResourceUnavailableError;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValBuilderJob
extends WorkspaceJob
implements IResourceDeltaVisitor,
IResourceVisitor {
    private IProject _project;
    private IResourceDelta _delta;
    private ValOperation _operation;
    private int _buildKind;
    private IProgressMonitor _monitor;
    private static final int InterestedFlags = 0x103100;

    public ValBuilderJob(IProject project, IResourceDelta delta, int buildKind, ValOperation operation) {
        super(ValMessages.JobName);
        this._project = project;
        this._delta = delta;
        this._buildKind = buildKind;
        this._operation = operation;
    }

    public boolean belongsTo(Object family) {
        if (family == ResourcesPlugin.FAMILY_MANUAL_BUILD) {
            return true;
        }
        if (family == ValidationBuilder.FAMILY_VALIDATION_JOB) {
            return true;
        }
        return super.belongsTo(family);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        Tracing.log("ValBuilderJob-01: Starting");
        this._monitor = monitor;
        try {
            if (this._delta == null) {
                this.fullBuild();
            } else {
                this.deltaBuild();
            }
        }
        catch (ProjectUnavailableError e) {
            ValidationPlugin.getPlugin().handleProjectUnavailableError(e);
        }
        catch (ResourceUnavailableError e) {
            ValidationPlugin.getPlugin().handleResourceUnavailableError(e);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        Tracing.log("ValBuilderJob-02: Finished");
        return Status.OK_STATUS;
    }

    private void deltaBuild() throws CoreException {
        this._delta.accept((IResourceDeltaVisitor)this);
    }

    private void fullBuild() throws CoreException {
        this._project.accept((IResourceVisitor)this);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IDependencyIndex index;
        IResource resource = delta.getResource();
        if (DisabledResourceManager.getDefault().isDisabled(resource)) {
            MarkerManager.getDefault().deleteMarkers(resource, this._operation.getStarted(), 2);
            return false;
        }
        int kind = delta.getKind();
        if ((delta.getFlags() & 0x103100) == 0) {
            return true;
        }
        if ((kind & 5) != 0) {
            ValManager.getDefault().validate(this._project, resource, delta.getKind(), ValType.Build, this._buildKind, this._operation, this._monitor);
        }
        if ((index = ValidationFramework.getDefault().getDependencyIndex()).isDependedOn(resource)) {
            MarkerManager mm = MarkerManager.getDefault();
            for (DependentResource dr : index.get(resource)) {
                if (!dr.getValidator().shouldValidate(dr.getResource(), ValType.Build)) continue;
                mm.clearMarker(dr.getResource(), dr.getValidator());
                this._operation.getState().put("org.eclipse.wst.validation.Trigger", resource);
                ValManager.getDefault().validate(dr.getValidator(), this._operation, dr.getResource(), 0, this._monitor);
            }
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        block4: {
            try {
                if (!DisabledResourceManager.getDefault().isDisabled(resource)) break block4;
                MarkerManager.getDefault().deleteMarkers(resource, this._operation.getStarted(), 2);
                return false;
            }
            catch (ResourceUnavailableError e) {
                if (Tracing.isLogging()) {
                    Tracing.log("ValBuilderJob-02: " + e.toString());
                }
                return false;
            }
        }
        ValManager.getDefault().validate(this._project, resource, 0, ValType.Build, this._buildKind, this._operation, this._monitor);
        return true;
    }
}

