/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.validation.IPerformanceMonitor;
import org.eclipse.wst.validation.PerformanceCounters;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.ExtensionValidators;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.IProjectChangeListener;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValProperty;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValManager
implements IValChangedListener,
IFacetedProjectListener,
IProjectChangeListener {
    private static ValManager _me;
    private Map<IProject, ProjectPreferences> _projectPreferences = Collections.synchronizedMap(new HashMap(50));
    private GlobalPreferences _globalPreferences;
    private int _configNumber;
    private ValidatorIdManager _idManager = new ValidatorIdManager();
    private ValidatorProjectManager _projectManager = new ValidatorProjectManager();
    private static final QualifiedName StatusBuild;
    private static final QualifiedName StatusManual;

    static {
        StatusBuild = new QualifiedName("org.eclipse.wst.validation", "sb");
        StatusManual = new QualifiedName("org.eclipse.wst.validation", "sm");
    }

    public static synchronized ValManager getDefault() {
        if (_me == null) {
            _me = new ValManager();
        }
        return _me;
    }

    private ValManager() {
        ValPrefManagerGlobal.getDefault().addListener(this);
        ValPrefManagerProject.addListener(this);
        FacetedProjectFramework.addListener((IFacetedProjectListener)this, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_MODIFIED});
        EventManager.getManager().addProjectChangeListener(this);
    }

    public void dispose() {
        ValPrefManagerGlobal.getDefault().removeListener(this);
        ValPrefManagerProject.removeListener(this);
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this);
        EventManager.getManager().removeProjectChangeListener(this);
    }

    public Validator[] getValidators() {
        return this.getValidators(null);
    }

    public Validator[] getValidatorsCopy() {
        Validator[] orig = this.getValidators();
        Validator[] copy = new Validator[orig.length];
        int i = 0;
        while (i < orig.length) {
            copy[i] = orig[i].copy();
            ++i;
        }
        return copy;
    }

    public Validator[] getValidators(IProject project) throws ProjectUnavailableError {
        return this.getValidators(project, true);
    }

    public synchronized Validator[] getValidators(IProject project, boolean respectOverrideSettings) throws ProjectUnavailableError {
        Map<String, Validator> v2Vals = this.getV2Validators(project);
        TreeSet<Validator> sorted = new TreeSet<Validator>();
        for (Validator v : v2Vals.values()) {
            sorted.add(v);
        }
        try {
            ValidationConfiguration vc = ConfigurationManager.getManager().getConfiguration(project);
            ValidatorMetaData[] validatorMetaDataArray = vc.getValidators();
            int n = validatorMetaDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidatorMetaData vmd = validatorMetaDataArray[n2];
                Validator v = Validator.create(vmd, vc, project);
                sorted.add(v);
                ++n2;
            }
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        Validator[] vals = new Validator[sorted.size()];
        sorted.toArray(vals);
        return vals;
    }

    private Map<String, Validator> getV2Validators(IProject project) {
        Map<String, Validator> extVals = ExtensionValidators.instance().getMapV2Copy();
        try {
            List<Validator> vals = ValPrefManagerGlobal.getDefault().getValidators();
            for (Validator v : vals) {
                extVals.put(v.getId(), v);
            }
            if (!this.mustUseGlobalValidators(project)) {
                ValPrefManagerProject vpm = new ValPrefManagerProject(project);
                vals = vpm.getValidators(extVals);
                for (Validator v : vals) {
                    extVals.put(v.getId(), v);
                }
            }
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        return extVals;
    }

    public boolean mustUseGlobalValidators(IProject project) {
        if (project == null) {
            return true;
        }
        if (!this.getGlobalPreferences().getOverride()) {
            return true;
        }
        ProjectPreferences pp = this.getProjectPreferences2(project);
        if (pp == null) {
            ValPrefManagerProject vpm = new ValPrefManagerProject(project);
            pp = new ProjectPreferences(project);
            vpm.loadProjectPreferencesShallow(pp);
        }
        return !pp.getOverride();
    }

    public Validator getValidator(String id, IProject project) {
        Validator[] vals;
        Validator[] validatorArray = vals = this.getValidators(project);
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.getId().equals(id)) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public Validator getValidatorWithId(String id, IProject project) {
        Validator[] vals;
        Validator[] validatorArray = vals = this.getValidators(project);
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.getId().equals(id)) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasValidators(IResource resource, boolean isManual, boolean isBuild) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            return ValManager.getDefault().getValidators(project).length > 0;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            HasValidatorVisitor v = new HasValidatorVisitor(isManual, isBuild);
            return v.hasValidator(folder);
        }
        Validator[] validatorArray = ValManager.getDefault().getValidators(resource.getProject());
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (val.shouldValidate(resource, isManual, isBuild)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDisabled(IProject project) {
        GlobalPreferences gp = this.getGlobalPreferences();
        if (!gp.getOverride() || project == null) {
            return gp.getDisableAllValidation();
        }
        ProjectPreferences pp = this.getProjectPreferences2(project);
        if (pp == null) {
            return gp.getDisableAllValidation();
        }
        return pp.getSuspend();
    }

    public static Validator[] getDefaultValidators() throws InvocationTargetException {
        Map<String, Validator> extVals = ExtensionValidators.instance().getMapV2();
        TreeSet<Validator> sorted = new TreeSet<Validator>();
        for (Validator v : extVals.values()) {
            sorted.add(v);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        GlobalConfiguration gc = new GlobalConfiguration(root);
        gc.resetToDefault();
        ValidatorMetaData[] validatorMetaDataArray = gc.getValidators();
        int n = validatorMetaDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            Validator v = Validator.create(vmd, gc, null);
            v.setBuildValidation(vmd.isBuildValidation());
            v.setManualValidation(vmd.isManualValidation());
            sorted.add(v);
            ++n2;
        }
        Validator[] val = new Validator[sorted.size()];
        sorted.toArray(val);
        return val;
    }

    public static Validator[] getDefaultValidators(IProject project) throws InvocationTargetException {
        Map<String, Validator> extVals = ExtensionValidators.instance().getMap(project);
        Validator[] val = new Validator[extVals.size()];
        extVals.values().toArray(val);
        return val;
    }

    private void configHasChanged() {
        ++this._configNumber;
        this._projectManager.reset();
    }

    public synchronized GlobalPreferences getGlobalPreferences() {
        GlobalPreferences gp = this._globalPreferences;
        if (gp == null) {
            ValPrefManagerGlobal vpm = ValPrefManagerGlobal.getDefault();
            gp = new GlobalPreferences();
            vpm.loadGlobalPreferences(gp);
            this._globalPreferences = gp;
        }
        return gp;
    }

    public ProjectPreferences getProjectPreferences(IProject project) {
        ProjectPreferences pp = this.getProjectPreferences2(project);
        if (pp != null) {
            return pp;
        }
        Map<String, Validator> extVals = ExtensionValidators.instance().getMapV2Copy();
        try {
            List<Validator> vals = ValPrefManagerGlobal.getDefault().getValidators();
            for (Validator v : vals) {
                extVals.put(v.getId(), v);
            }
            pp = this.getProjectPreferences(project, extVals);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        return pp;
    }

    private ProjectPreferences getProjectPreferences(IProject project, Map<String, Validator> baseValidators) throws BackingStoreException {
        if (this._projectPreferences.containsKey(project)) {
            return this._projectPreferences.get(project);
        }
        ValPrefManagerProject vpm = new ValPrefManagerProject(project);
        ProjectPreferences pp = new ProjectPreferences(project);
        vpm.loadProjectPreferences(pp, baseValidators);
        this._projectPreferences.put(project, pp);
        return pp;
    }

    private ProjectPreferences getProjectPreferences2(IProject project) {
        if (this._projectPreferences.containsKey(project)) {
            return this._projectPreferences.get(project);
        }
        return null;
    }

    public void validate(IProject project, final IResource resource, final int kind, ValType valType, int buildKind, ValOperation operation, IProgressMonitor monitor) {
        MarkerManager.getDefault().deleteMarkers(resource, operation.getStarted(), 0);
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType vt, ValOperation operation, IProgressMonitor monitor) {
                Validator.V1 v1 = validator.asV1Validator();
                if (vt == ValType.Build && v1 != null) {
                    return;
                }
                ValManager.this.validate(validator, operation, resource, kind, monitor);
            }
        };
        this.accept(visitor, project, resource, valType, operation, monitor);
    }

    public void validate(Validator validator, ValOperation operation, IResource resource, int kind, IProgressMonitor monitor) {
        if (operation.isValidated(validator.getId(), resource)) {
            return;
        }
        long time = 0L;
        long cpuTime = -1L;
        String msg1 = NLS.bind((String)ValMessages.LogValStart, (Object)validator.getName(), (Object)resource.getName());
        monitor.subTask(msg1);
        IPerformanceMonitor pm = ValidationFramework.getDefault().getPerformanceMonitor();
        if (pm.isCollecting()) {
            time = System.currentTimeMillis();
            cpuTime = Misc.getCPUTime();
        }
        ValidationResult vr = validator.validate(resource, kind, operation, monitor);
        if (pm.isCollecting()) {
            if (cpuTime != -1L) {
                cpuTime = Misc.getCPUTime() - cpuTime;
            }
            int num = 0;
            if (vr != null) {
                num = vr.getNumberOfValidatedResources();
            }
            PerformanceCounters pc = new PerformanceCounters(validator.getId(), validator.getName(), resource.getName(), num, System.currentTimeMillis() - time, cpuTime);
            pm.add(pc);
        }
        if (ValidationPlugin.getPlugin().isDebugging() && !pm.isCollecting()) {
            String msg = time != 0L ? NLS.bind((String)ValMessages.LogValEndTime, (Object[])new Object[]{validator.getName(), validator.getId(), resource, Misc.getTimeMS(System.currentTimeMillis() - time)}) : NLS.bind((String)ValMessages.LogValEnd, (Object)validator.getName(), (Object)resource);
            Tracing.log("ValManager-01: " + msg);
        }
        if (vr != null) {
            operation.getResult().mergeResults(vr);
            if (vr.getSuspendValidation() != null) {
                operation.suspendValidation(vr.getSuspendValidation(), validator);
            }
        }
    }

    public void accept(IValidatorVisitor visitor, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
        if (this.isDisabled(project)) {
            return;
        }
        Validator[] validatorArray = this.getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (this._projectManager.shouldValidate(val, project, valType) && !operation.isSuspended(val, project)) {
                try {
                    visitor.visit(val, project, valType, operation, monitor);
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
            ++n2;
        }
    }

    public void accept(IValidatorVisitor visitor, IProject project, IResource resource, ValType valType, ValOperation operation, IProgressMonitor monitor) {
        if (this.isDisabled(project)) {
            return;
        }
        ValProperty vp = this.getValProperty(resource, valType, this._configNumber);
        if (vp != null) {
            BitSet bs = vp.getConfigSet();
            Validator[] validatorArray = this.getValidators(project);
            int n = validatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Validator val = validatorArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                if (bs.get(this._idManager.getIndex(val.getId()))) {
                    try {
                        visitor.visit(val, project, valType, operation, monitor);
                    }
                    catch (Exception e) {
                        ValidationPlugin.getPlugin().handleException(e);
                    }
                }
                ++n2;
            }
            return;
        }
        vp = new ValProperty();
        vp.setConfigNumber(this._configNumber);
        Validator[] validatorArray = this.getValidators(project);
        int n = validatorArray.length;
        int n3 = 0;
        while (n3 < n) {
            Validator val = validatorArray[n3];
            if (monitor.isCanceled()) {
                return;
            }
            if (this._projectManager.shouldValidate(val, project, valType) && !operation.isSuspended(val, project) && val.shouldValidate(resource, valType)) {
                vp.getConfigSet().set(this._idManager.getIndex(val.getId()));
                try {
                    visitor.visit(val, project, valType, operation, monitor);
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
            ++n3;
        }
        this.putValProperty(vp, resource, valType);
    }

    private ValProperty getValProperty(IResource resource, ValType valType, int configNumber) {
        ValProperty vp = null;
        try {
            if (valType == ValType.Build) {
                vp = (ValProperty)resource.getSessionProperty(StatusBuild);
            } else if (valType == ValType.Manual) {
                vp = (ValProperty)resource.getSessionProperty(StatusManual);
            }
        }
        catch (CoreException coreException) {}
        if (vp == null) {
            return null;
        }
        if (vp.getConfigNumber() != this._configNumber) {
            return null;
        }
        return vp;
    }

    public void projectChanged(IProject project) {
        this._projectManager.change(project);
    }

    public void projectRemoved(IProject project) {
        this._projectManager.remove(project);
    }

    private void putValProperty(ValProperty vp, IResource resource, ValType valType) {
        try {
            if (valType == ValType.Build) {
                resource.setSessionProperty(StatusBuild, (Object)vp);
            } else if (valType == ValType.Manual) {
                resource.setSessionProperty(StatusManual, (Object)vp);
            }
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    void clean(IProject project, ValOperation operation, IProgressMonitor monitor) {
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.clean(project, monitor);
            }
        };
        this.accept(visitor, project, ValType.Build, operation, monitor);
    }

    public void clean(IProject project, IProgressMonitor monitor) {
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.clean(project, monitor);
            }
        };
        ValidationFramework.getDefault().getDependencyIndex().clear(project);
        ValOperation operation = new ValOperation();
        this.accept(visitor, project, ValType.Build, operation, monitor);
    }

    @Override
    public void validatorsForProjectChanged(IProject project, boolean validationSettingChanged) {
        if (validationSettingChanged) {
            if (project != null) {
                this._projectPreferences.remove(project);
            }
            this.configHasChanged();
        }
    }

    public void handleEvent(IFacetedProjectEvent event) {
        this.projectChanged(event.getProject().getProject());
    }

    @Override
    public void projectChanged(IProject project, int type) {
        switch (type) {
            case 2: 
            case 4: {
                this.projectRemoved(project);
                break;
            }
            case 1: 
            case 8: {
                this.projectChanged(project);
            }
        }
    }

    private class HasValidatorVisitor
    implements IResourceVisitor {
        private boolean _hasValidator;
        private boolean _isManual;
        private boolean _isBuild;

        public HasValidatorVisitor(boolean isManual, boolean isBuild) {
            this._isManual = isManual;
            this._isBuild = isBuild;
        }

        public boolean hasValidator(IFolder folder) {
            try {
                folder.accept((IResourceVisitor)this);
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            return this._hasValidator;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFolder) {
                return true;
            }
            if (ValManager.this.hasValidators(resource, this._isManual, this._isBuild)) {
                this._hasValidator = true;
                return false;
            }
            return true;
        }
    }

    private static class ValidatorIdManager {
        private HashMap<String, Integer> _map = new HashMap(100);
        private HashMap<Integer, String> _reverseMap = new HashMap(100);
        private int _next;

        private ValidatorIdManager() {
        }

        public int getIndex(String id) {
            Integer i = this._map.get(id);
            if (i != null) {
                return i;
            }
            i = this._next++;
            this._map.put(id, i);
            this._reverseMap.put(i, id);
            return i;
        }

        public String getId(Integer index) {
            return this._reverseMap.get(index);
        }

        public void reset() {
            this._map.clear();
            this._reverseMap.clear();
            this._next = 0;
        }

        public String[] getIds(BitSet bs) {
            LinkedList<String> list = new LinkedList<String>();
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                String id = this.getId(i);
                if (id != null) {
                    list.add(id);
                }
                i = bs.nextSetBit(i + 1);
            }
            String[] s = new String[list.size()];
            return list.toArray(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidatorProjectManager {
        private Map<String, Set<IProject>> _manual = new HashMap<String, Set<IProject>>(50);
        private Map<String, Set<IProject>> _build = new HashMap<String, Set<IProject>>(50);

        private ValidatorProjectManager() {
        }

        public synchronized boolean shouldValidate(Validator validator, IProject project, ValType type) {
            if (type == ValType.Build) {
                return this.shouldValidate(validator, project, type, this._build);
            }
            if (type == ValType.Manual) {
                return this.shouldValidate(validator, project, type, this._manual);
            }
            return false;
        }

        public synchronized void change(IProject project) {
            this.change(project, this._build, ValType.Build);
            this.change(project, this._manual, ValType.Manual);
        }

        private void change(IProject project, Map<String, Set<IProject>> map, ValType type) {
            Validator[] validatorArray = ValManager.getDefault().getValidators(project);
            int n = validatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean oldSetting;
                Validator validator = validatorArray[n2];
                boolean newSetting = validator.shouldValidateProject(project, type);
                if (newSetting != (oldSetting = this.shouldValidate(validator, project, type, map))) {
                    if (newSetting) {
                        map.get(validator.getId()).add(project);
                    } else {
                        map.get(validator.getId()).remove(project);
                    }
                }
                ++n2;
            }
        }

        public synchronized void remove(IProject project) {
            this.remove(project, this._build);
            this.remove(project, this._manual);
        }

        private void remove(IProject project, Map<String, Set<IProject>> map) {
            for (Set<IProject> projects : map.values()) {
                projects.remove(project);
            }
        }

        private boolean shouldValidate(Validator validator, IProject project, ValType type, Map<String, Set<IProject>> map) {
            String id = validator.getId();
            if (!map.containsKey(id)) {
                this.loadMap(validator, type, map);
            }
            Set<IProject> projects = map.get(id);
            if (project == null) {
                return projects.size() > 0;
            }
            return projects.contains(project);
        }

        private void loadMap(Validator validator, ValType type, Map<String, Set<IProject>> map) {
            IProject[] projects;
            HashSet<IProject> set = new HashSet<IProject>(40);
            map.put(validator.getId(), set);
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (validator.shouldValidateProject(p, type)) {
                    set.add(p);
                }
                ++n2;
            }
        }

        public synchronized void reset() {
            this._build.clear();
            this._manual.clear();
        }
    }
}

