/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorExtensionReader {
    private static ValidatorExtensionReader _me;

    public static ValidatorExtensionReader getDefault() {
        if (_me == null) {
            _me = new ValidatorExtensionReader();
        }
        return _me;
    }

    private ValidatorExtensionReader() {
    }

    List<Validator> process() {
        LinkedList<Validator> list = new LinkedList<Validator>();
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            return list;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement validator = iConfigurationElementArray[n4];
                Validator v = this.processValidator(validator, ext.getUniqueIdentifier(), ext.getLabel(), null);
                if (v != null) {
                    list.add(v);
                }
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    private Validator processValidator(IConfigurationElement validator, String id, String label, IProject project) {
        Validator.V2 v = null;
        try {
            v = Validator.create(validator, project).asV2Validator();
            v.setLevel(Validator.Level.Extension);
            v.setId(id);
            v.setName(label);
            v.setBuildValidation(this.getAttribute(validator, "build", true));
            v.setManualValidation(this.getAttribute(validator, "manual", true));
            v.setMarkerId(validator.getAttribute("markerId"));
            v.setVersion(this.getAttribute(validator, "version", 1));
            v.setSourceId(validator.getAttribute("sourceid"));
            IConfigurationElement[] children = validator.getChildren();
            int i = 0;
            while (i < children.length) {
                this.processValidatorChildren(v, children[i]);
                ++i;
            }
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            IContributor contrib = validator.getContributor();
            String message = NLS.bind((String)ValMessages.ErrConfig, (Object)contrib.getName());
            ValidationPlugin.getPlugin().logMessage(4, message);
        }
        return v;
    }

    public List<MessageSeveritySetting> addMessages(Validator v) {
        LinkedList<MessageSeveritySetting> list = new LinkedList<MessageSeveritySetting>();
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            return list;
        }
        IExtension ext = extensionPoint.getExtension(v.getId());
        if (ext == null) {
            return list;
        }
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = elem.getChildren("messageCategory");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray2[n4];
                list.add(this.processMessage(ce));
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    private IExtensionPoint getExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getExtensionPoint("org.eclipse.wst.validation", "validatorV2");
    }

    private MessageSeveritySetting processMessage(IConfigurationElement ce) {
        String s = ce.getAttribute("severity");
        MessageSeveritySetting.Severity sev = null;
        if ("error".equals(s)) {
            sev = MessageSeveritySetting.Severity.Error;
        } else if ("warning".equals(s)) {
            sev = MessageSeveritySetting.Severity.Warning;
        } else if ("ignore".equals(s)) {
            sev = MessageSeveritySetting.Severity.Ignore;
        }
        return new MessageSeveritySetting(ce.getAttribute("id"), ce.getAttribute("label"), sev);
    }

    private void processValidatorChildren(Validator.V2 v, IConfigurationElement group) {
        FilterGroup fg = FilterGroup.create(group.getName());
        if (fg == null) {
            return;
        }
        IConfigurationElement[] rules = group.getChildren("rules");
        int i = 0;
        while (i < rules.length) {
            IConfigurationElement[] r = rules[i].getChildren();
            int j = 0;
            while (j < r.length) {
                this.processRule(fg, r[j]);
                ++j;
            }
            ++i;
        }
        v.add(fg);
    }

    private void processRule(FilterGroup fg, IConfigurationElement rule) {
        FilterRule fr = FilterRule.create(rule.getName());
        if (fr == null) {
            throw new IllegalStateException(ValMessages.ErrFilterRule);
        }
        fr.setData(rule);
        fg.add(fr);
    }

    Validator[] migrate(Validator[] validators, IProject project) {
        int count = 0;
        HashMap<String, Validator> map = new HashMap<String, Validator>(validators.length);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            map.put(v.getId(), v);
            ++n2;
        }
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        n = 0;
        while (n < n3) {
            IExtension ext = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n4 = iConfigurationElementArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Validator old;
                IConfigurationElement validator = iConfigurationElementArray[n5];
                Validator v = this.processValidator(validator, ext.getUniqueIdentifier(), ext.getLabel(), project);
                if (v != null && ((old = (Validator)map.get(v.getId())) == null || old.getVersion() < v.getVersion())) {
                    map.put(v.getId(), v);
                    ++count;
                }
                ++n5;
            }
            ++n;
        }
        if (count > 0) {
            Validator[] vals = new Validator[map.size()];
            map.values().toArray(vals);
            return vals;
        }
        return null;
    }

    private boolean getAttribute(IConfigurationElement element, String name, boolean dft) {
        String v = element.getAttribute(name);
        if (v == null) {
            return dft;
        }
        if ("true".equalsIgnoreCase(v)) {
            return true;
        }
        if ("false".equalsIgnoreCase(v)) {
            return false;
        }
        return dft;
    }

    private int getAttribute(IConfigurationElement element, String name, int dft) {
        String v = element.getAttribute(name);
        if (v == null) {
            return dft;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            return dft;
        }
    }
}

