/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.validation.internal.IProjectValidationHelper;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorFilter;
import org.eclipse.wst.validation.internal.ValidatorNameFilter;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationHelperRegistryReader;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorMetaData {
    private ValidatorFilter[] _filters;
    private ValidatorNameFilter[] _projectNatureFilters;
    private String[] _facetFilters;
    private IValidator _validator;
    private IWorkbenchContext _helper;
    private String _validatorDisplayName;
    private String _validatorUniqueName;
    private String[] _aggregatedValidators;
    private String[] _contentTypeIds = null;
    private String[] _validatorNames;
    private String _pluginId;
    private boolean _supportsIncremental = true;
    private boolean _supportsFullBuild = true;
    private boolean _isEnabledByDefault = true;
    private MigrationMetaData _migrationMetaData;
    private int _ruleGroup = 1;
    private boolean _async = false;
    private boolean _dependentValidator = false;
    private String[] _markerIds;
    private String _helperClassName;
    private IConfigurationElement _helperClassElement;
    private IConfigurationElement _validatorClassElement;
    private boolean _cannotLoad;
    private boolean _manualValidation = true;
    private boolean _buildValidation = true;
    private Map<IValidatorJob, IWorkbenchContext> _helpers = Collections.synchronizedMap(new HashMap());
    private Expression _enablementExpression;

    ValidatorMetaData() {
    }

    void addAggregatedValidatorNames(String[] val) {
        this._aggregatedValidators = val;
    }

    void addFilters(ValidatorFilter[] filters) {
        this._filters = filters;
    }

    void addProjectNatureFilters(ValidatorNameFilter[] filters) {
        this._projectNatureFilters = filters;
    }

    protected void addFacetFilters(String[] filters) {
        this._facetFilters = filters;
    }

    protected String[] getFacetFilters() {
        return this._facetFilters;
    }

    public List<String> getNameFilters() {
        ArrayList<String> nameFilters = new ArrayList<String>();
        if (this._filters != null && this._filters.length > 0) {
            ValidatorFilter[] validatorFilterArray = this._filters;
            int n = this._filters.length;
            int n2 = 0;
            while (n2 < n) {
                ValidatorFilter filter = validatorFilterArray[n2];
                ValidatorNameFilter nameFilter = filter.get_nameFilter();
                if (nameFilter != null) {
                    nameFilters.add(nameFilter.getNameFilter());
                }
                ++n2;
            }
        }
        return nameFilters;
    }

    public String[] getValidatorNames() {
        if (this._validatorNames == null) {
            int aLength = this._aggregatedValidators == null ? 0 : this._aggregatedValidators.length;
            this._validatorNames = new String[aLength + 1];
            this._validatorNames[0] = this.getValidatorUniqueName();
            if (this._aggregatedValidators != null) {
                System.arraycopy(this._aggregatedValidators, 0, this._validatorNames, 1, aLength);
            }
        }
        return this._validatorNames;
    }

    public String[] getAggregatedValidatorNames() {
        return this._aggregatedValidators;
    }

    public ValidatorFilter[] getFilters() {
        return this._filters;
    }

    public boolean isActive() {
        if (this._helperClassElement != null) {
            return false;
        }
        if (this._validatorClassElement != null) {
            return false;
        }
        Bundle bundle = Platform.getBundle((String)this._pluginId);
        if (bundle != null) {
            return bundle.getState() == 32;
        }
        return false;
    }

    public IWorkbenchContext getHelper(IProject project) throws InstantiationException {
        if (this._helper == null) {
            this._helper = ValidationRegistryReader.createHelper(this._helperClassElement, this._helperClassName);
            if (this._helper == null) {
                this._helper = new WorkbenchContext();
            }
        }
        if (this._helper.getProject() == null || !this._helper.getProject().equals((Object)project)) {
            this._helper.setProject(project);
        }
        return this._helper;
    }

    private void setCannotLoad() {
        this._cannotLoad = true;
    }

    public boolean cannotLoad() {
        return this._cannotLoad;
    }

    public MigrationMetaData getMigrationMetaData() {
        return this._migrationMetaData;
    }

    public int getRuleGroup() {
        return this._ruleGroup;
    }

    ValidatorNameFilter[] getProjectNatureFilters() {
        return this._projectNatureFilters;
    }

    public IValidator getValidator() throws InstantiationException {
        if (this._validator == null) {
            this._validator = ValidationRegistryReader.createValidator(this._validatorClassElement, this.getValidatorUniqueName());
            if (this._validator == null) {
                this.setCannotLoad();
                throw new InstantiationException(ResourceHandler.getExternalizedMessage("VBF_EXC_DISABLEV", new String[]{this.getValidatorUniqueName()}));
            }
        }
        return this._validator;
    }

    public String getValidatorDisplayName() {
        return this._validatorDisplayName;
    }

    public String getValidatorUniqueName() {
        return this._validatorUniqueName;
    }

    public boolean isApplicableTo(IResource resource) {
        return this.isApplicableTo(resource, 7);
    }

    public boolean isApplicableTo(IResource resource, int resourceDelta) {
        if (this._filters == null) {
            return true;
        }
        return this.isApplicableTo(resource, resourceDelta, this._filters);
    }

    boolean isApplicableTo(IResource resource, int resourceDelta, ValidatorFilter[] filters) {
        if (this.checkIfValidSourceFile(resource)) {
            int i = 0;
            while (i < filters.length) {
                ValidatorFilter filter = filters[i];
                if (filter.isApplicableType(resource) && filter.isApplicableName(resource) && filter.isApplicableAction(resourceDelta)) {
                    return true;
                }
                ++i;
            }
        }
        if (this.getContentTypeIds() != null) {
            IContentDescription description = null;
            try {
                if (resource.getType() == 1 && resource.exists()) {
                    description = ((IFile)resource).getContentDescription();
                }
            }
            catch (CoreException coreException) {}
            if (description == null) {
                return false;
            }
            if (this.isApplicableContentType(description)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIfValidSourceFile(IResource file) {
        if (file.getType() == 1) {
            IProjectValidationHelper helper = ValidationHelperRegistryReader.getInstance().getValidationHelper();
            IProject project = file.getProject();
            if (helper == null || project == null) {
                return true;
            }
            IContainer[] outputContainers = helper.getOutputContainers(project);
            IContainer[] sourceContainers = helper.getSourceContainers(project);
            int i = 0;
            while (i < outputContainers.length) {
                int j;
                String outputPath = outputContainers[i].getProjectRelativePath().makeAbsolute().toString();
                String filePath = file.getProjectRelativePath().makeAbsolute().toString();
                if (filePath.startsWith(outputPath) && (j = 0) < sourceContainers.length) {
                    return outputContainers[i].equals((Object)sourceContainers[j]);
                }
                ++i;
            }
        }
        return true;
    }

    ValidatorNameFilter findProjectNature(String projId) {
        if (projId == null) {
            return null;
        }
        if (this._projectNatureFilters == null) {
            return null;
        }
        int i = 0;
        while (i < this._projectNatureFilters.length) {
            ValidatorNameFilter filter = this._projectNatureFilters[i];
            String projectNatureID = filter.getNameFilter();
            if (projId.equals(projectNatureID)) {
                return filter;
            }
            ++i;
        }
        return null;
    }

    public boolean isConfiguredOnProject(IProject project) {
        return ValidationRegistryReader.getReader().isConfiguredOnProject(this, project);
    }

    public boolean isEnabledByDefault() {
        return this._isEnabledByDefault;
    }

    public boolean isIncremental() {
        return this._supportsIncremental;
    }

    public boolean isFullBuild() {
        return this._supportsFullBuild;
    }

    public boolean isAsync() {
        return this._async;
    }

    void setHelperClass(IConfigurationElement element, String helperClassName) {
        this._helperClassElement = element;
        this._helperClassName = helperClassName;
    }

    void setEnabledByDefault(boolean enabledByDefault) {
        this._isEnabledByDefault = enabledByDefault;
    }

    void setIncremental(boolean isIncremental) {
        this._supportsIncremental = isIncremental;
    }

    void setFullBuild(boolean fullBuild) {
        this._supportsFullBuild = fullBuild;
    }

    void setAsync(boolean isAsync) {
        this._async = isAsync;
    }

    void setMigrationMetaData(MigrationMetaData mmd) {
        this._migrationMetaData = mmd;
    }

    void setRuleGroup(int ruleGroup) {
        this._ruleGroup = ruleGroup;
    }

    void setValidatorClass(IConfigurationElement element) {
        this._validatorClassElement = element;
    }

    void setValidatorDisplayName(String validatorName) {
        this._validatorDisplayName = validatorName;
    }

    void setValidatorUniqueName(String validatorUniqueName) {
        this._validatorUniqueName = validatorUniqueName;
    }

    void setPluginId(String validatorPluginId) {
        this._pluginId = validatorPluginId;
    }

    public String toString() {
        return this.getValidatorUniqueName();
    }

    public void addDependentValidator(boolean b) {
        this._dependentValidator = b;
    }

    public boolean isDependentValidator() {
        return this._dependentValidator;
    }

    public String[] getMarkerIds() {
        return this._markerIds;
    }

    public void setMarkerIds(String[] markerId) {
        this._markerIds = markerId;
    }

    public boolean isBuildValidation() {
        return this._buildValidation;
    }

    public void setBuildValidation(boolean buildValidation) {
        this._buildValidation = buildValidation;
    }

    public boolean isManualValidation() {
        return this._manualValidation;
    }

    public void setManualValidation(boolean manualValidation) {
        this._manualValidation = manualValidation;
    }

    public boolean isDelegating() {
        String targetID = this.getValidatorUniqueName();
        return ValidatorDelegatesRegistry.getInstance().hasDelegates(targetID);
    }

    public IValidator createValidator() throws InstantiationException {
        return ValidationRegistryReader.createValidator(this._validatorClassElement, this.getValidatorUniqueName());
    }

    public IWorkbenchContext createHelper(IProject project) throws InstantiationException {
        IWorkbenchContext helper = ValidationRegistryReader.createHelper(this._helperClassElement, this._helperClassName);
        if (helper == null) {
            helper = new WorkbenchContext();
        }
        helper.setProject(project);
        return helper;
    }

    public void addHelper(IValidatorJob validator, IWorkbenchContext helper) {
        this._helpers.put(validator, helper);
    }

    public void removeHelper(IValidatorJob validator) {
        this._helpers.remove(validator);
    }

    private IWorkbenchContext getHelper(IValidatorJob validator) {
        return this._helpers.get(validator);
    }

    public IWorkbenchContext getHelper(IProject project, IValidator validator) {
        if (validator instanceof IValidatorJob) {
            IWorkbenchContext helper = this.getHelper((IValidatorJob)validator);
            if (helper == null) {
                try {
                    helper = this.getHelper(project);
                    return helper;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return helper;
        }
        try {
            IWorkbenchContext helper = this.getHelper(project);
            return helper;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Expression getEnablementExpresion() {
        return this._enablementExpression;
    }

    public void setEnablementElement(Expression enablementElement) {
        this._enablementExpression = enablementElement;
    }

    public String[] getContentTypeIds() {
        return this._contentTypeIds;
    }

    public void setContentTypeIds(String[] contentTypeIds) {
        this._contentTypeIds = contentTypeIds;
    }

    private boolean isApplicableContentType(IContentDescription desc) {
        IContentType ct = desc.getContentType();
        String[] applicableContentTypes = this.getContentTypeIds();
        if (applicableContentTypes != null) {
            int i = 0;
            while (i < applicableContentTypes.length) {
                if (applicableContentTypes[i].equals(ct.getId())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public class MigrationMetaData {
        private Set _ids = null;

        public void addId(String oldId, String newId) {
            if (oldId == null) {
                return;
            }
            if (newId == null) {
                return;
            }
            String[] ids = new String[]{oldId, newId};
            this.getIds().add(ids);
        }

        public Set getIds() {
            if (this._ids == null) {
                this._ids = new HashSet();
            }
            return this._ids;
        }
    }
}

