/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis2.consumption.ui.widgets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.data.DataModel;
import org.eclipse.jst.ws.axis2.consumption.core.messages.Axis2ConsumptionUIMessages;
import org.eclipse.jst.ws.axis2.consumption.core.utils.WSDLPropertyReader;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.utils.ClassLoadingUtil;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class Axis2ProxyWidget
extends SimpleWidgetDataContributor {
    DataModel model;
    IStatus status = Status.OK_STATUS;
    private Button genProxyCheckbox_;
    private Button syncAndAsyncRadioButton;
    private Button syncOnlyRadioButton;
    private Button asyncOnlyRadioButton;
    private Combo databindingTypeCombo;
    private Combo portNameCombo;
    private Combo serviceNameCombo;
    private Text packageText;
    private Table namespace2packageTable = null;
    private Button generateAllCheckBoxButton;
    private Button testCaseCheckBoxButton;
    private WSDLPropertyReader reader;
    private List serviceQNameList = null;
    Axis2EmitterContext context;

    public Axis2ProxyWidget(DataModel model) {
        this.model = model;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        UIUtils uiUtils = new UIUtils("org.eclipse.jst.ws.axis2.ui");
        Composite topComp = uiUtils.createComposite(parent, 2);
        this.serviceNameCombo = uiUtils.createCombo(topComp, Axis2ConsumptionUIMessages.LABEL_SERVICE_NAME_CAPTION, null, null, 8);
        this.serviceNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setServiceName(Axis2ProxyWidget.this.serviceNameCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.portNameCombo = uiUtils.createCombo(topComp, Axis2ConsumptionUIMessages.LABEL_PORTNAME, null, null, 8);
        this.portNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setPortName(Axis2ProxyWidget.this.portNameCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.databindingTypeCombo = uiUtils.createCombo(topComp, Axis2ConsumptionUIMessages.LABEL_DATABINDING_CAPTION, null, null, 8);
        this.fillDatabinderCombo();
        this.databindingTypeCombo.select(0);
        this.databindingTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setDatabindingType(Axis2ProxyWidget.this.databindingTypeCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.packageText = uiUtils.createText(topComp, Axis2ConsumptionUIMessages.LABEL_PACKEGE_NAME, null, null, 2048);
        this.packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2ProxyWidget.this.model.setPackageText(Axis2ProxyWidget.this.packageText.getText());
            }
        });
        Group clientTypeGroup = uiUtils.createGroup(parent, Axis2ConsumptionUIMessages.LABEL_CLIENT_SIDE, null, null);
        this.syncAndAsyncRadioButton = uiUtils.createRadioButton((Composite)clientTypeGroup, Axis2ConsumptionUIMessages.LABEL_SYNC_AND_ASYNC, null, null);
        this.syncAndAsyncRadioButton.setSelection(!this.context.isAsync() && !this.context.isSync() ? true : this.context.isAsync() && this.context.isSync());
        this.syncAndAsyncRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setSync(!Axis2ProxyWidget.this.syncAndAsyncRadioButton.getSelection());
                Axis2ProxyWidget.this.model.setASync(!Axis2ProxyWidget.this.syncAndAsyncRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.syncOnlyRadioButton = uiUtils.createRadioButton((Composite)clientTypeGroup, Axis2ConsumptionUIMessages.LABEL_SYNC, null, null);
        this.syncOnlyRadioButton.setSelection(this.context.isSync() && !this.context.isAsync());
        this.syncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setSync(Axis2ProxyWidget.this.syncOnlyRadioButton.getSelection());
                Axis2ProxyWidget.this.model.setASync(!Axis2ProxyWidget.this.syncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.asyncOnlyRadioButton = uiUtils.createRadioButton((Composite)clientTypeGroup, Axis2ConsumptionUIMessages.LABEL_ASYNC, null, null);
        this.asyncOnlyRadioButton.setSelection(this.context.isAsync() && !this.context.isSync());
        this.asyncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setASync(Axis2ProxyWidget.this.asyncOnlyRadioButton.getSelection());
                Axis2ProxyWidget.this.model.setSync(!Axis2ProxyWidget.this.asyncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.model.setSync(this.context.isSync());
        this.model.setASync(this.context.isAsync());
        Composite checkBoxes = uiUtils.createComposite(parent, 1);
        this.testCaseCheckBoxButton = uiUtils.createCheckbox(checkBoxes, Axis2ConsumptionUIMessages.LABEL_GENERATE_TESTCASE_CAPTION, null, null);
        this.testCaseCheckBoxButton.setSelection(this.context.isClientTestCase());
        this.model.setTestCaseCheck(this.context.isClientTestCase());
        this.testCaseCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setTestCaseCheck(Axis2ProxyWidget.this.testCaseCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.generateAllCheckBoxButton = uiUtils.createCheckbox(checkBoxes, Axis2ConsumptionUIMessages.LABEL_GENERATE_ALL, null, null);
        this.generateAllCheckBoxButton.setSelection(this.context.isClientGenerateAll());
        this.generateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setGenerateAllCheck(Axis2ProxyWidget.this.generateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 256);
        this.namespace2packageTable = new Table(parent, 67584);
        this.namespace2packageTable.setLinesVisible(true);
        this.namespace2packageTable.setHeaderVisible(true);
        this.namespace2packageTable.setEnabled(true);
        this.declareColumn(this.namespace2packageTable, 350, Axis2ConsumptionUIMessages.LABEL_NAMESPACE);
        this.declareColumn(this.namespace2packageTable, 200, Axis2ConsumptionUIMessages.LABEL_PACKAGE);
        this.namespace2packageTable.setVisible(true);
        final TableEditor editor = new TableEditor(this.namespace2packageTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.namespace2packageTable.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = Axis2ProxyWidget.this.namespace2packageTable.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = Axis2ProxyWidget.this.namespace2packageTable.getTopIndex();
                while (index < Axis2ProxyWidget.this.namespace2packageTable.getItemCount()) {
                    boolean visible = false;
                    TableItem item = Axis2ProxyWidget.this.namespace2packageTable.getItem(index);
                    Rectangle rect = item.getBounds(1);
                    if (rect.contains(pt)) {
                        Axis2ProxyWidget.this.editCell(item, editor);
                        return;
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
        this.namespace2packageTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Axis2ProxyWidget.this.namespace2packageTable.getSelectionIndex() == -1) {
                    Axis2ProxyWidget.this.namespace2packageTable.setSelection(0);
                }
            }
        });
        this.namespace2packageTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 32) {
                    return;
                }
                TableItem[] item = Axis2ProxyWidget.this.namespace2packageTable.getSelection();
                if (item.length != 1) {
                    return;
                }
                Axis2ProxyWidget.this.editCell(item[0], editor);
            }
        });
        this.populateParamsFromWSDL();
        this.populateModel();
        return this;
    }

    private void editCell(final TableItem item, TableEditor editor) {
        final Text textEdit = new Text((Composite)this.namespace2packageTable, 0);
        textEdit.setText(item.getText(1));
        textEdit.selectAll();
        textEdit.setFocus();
        textEdit.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                item.setText(1, textEdit.getText());
                textEdit.dispose();
            }
        });
        textEdit.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 4: {
                        item.setText(1, textEdit.getText());
                    }
                    case 2: {
                        textEdit.dispose();
                        e.doit = false;
                    }
                }
            }
        });
        textEdit.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 32) {
                    item.setText(1, textEdit.getText());
                    textEdit.dispose();
                }
            }
        });
        textEdit.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Axis2ProxyWidget.this.model.setNamespaseToPackageMapping(Axis2ProxyWidget.this.getNs2PkgMapping());
            }
        });
        editor.setEditor((Control)textEdit, item, 1);
    }

    private void declareColumn(Table table, int width, String colName) {
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(width);
        column.setText(colName);
    }

    public String getNs2PkgMapping() {
        String returnList = "";
        TableItem[] items = this.namespace2packageTable.getItems();
        int i = 0;
        while (i < items.length) {
            String packageValue = items[i].getText(1);
            if (packageValue != null && !"".equals(packageValue)) {
                returnList = String.valueOf(returnList) + ("".equals(returnList) ? "" : ",") + items[i].getText(0) + "=" + packageValue;
            }
            ++i;
        }
        return "".equals(returnList) ? null : returnList;
    }

    public boolean isGenProxy() {
        return true;
    }

    public void setGenerateProxy(Boolean genProxy) {
        this.genProxyCheckbox_.setSelection(genProxy.booleanValue());
    }

    private void fillDatabinderCombo() {
        this.databindingTypeCombo.add("ADB");
        this.databindingTypeCombo.add("NONE");
        this.databindingTypeCombo.select(0);
    }

    private void populateModel() {
        this.model.setServiceName(this.serviceNameCombo.getText());
        this.model.setPortName(this.portNameCombo.getText());
        this.model.setPackageText(this.packageText.getText());
        this.model.setDatabindingType(this.databindingTypeCombo.getText());
        if (this.syncAndAsyncRadioButton.getSelection()) {
            this.model.setASync(!this.syncAndAsyncRadioButton.getSelection());
            this.model.setSync(!this.syncAndAsyncRadioButton.getSelection());
        }
        this.model.setGenerateAllCheck(this.generateAllCheckBoxButton.getSelection());
        this.model.setTestCaseCheck(this.testCaseCheckBoxButton.getSelection());
        this.model.setNamespaseToPackageMapping(this.getNs2PkgMapping());
    }

    public IStatus getStatus() {
        IStatus result = null;
        return result;
    }

    private void populatePackageName() {
        this.packageText.setText(this.reader.packageFromTargetNamespace());
    }

    public void populateParamsFromWSDL() {
        if (this.reader == null) {
            this.reader = new WSDLPropertyReader();
        }
        try {
            String lname = this.model.getWsdlURI();
            if (!"".equals(lname.trim())) {
                this.reader.readWSDL(this.model.getWebProjectName(), lname);
                this.serviceQNameList = this.reader.getServiceList();
                if (!this.serviceQNameList.isEmpty()) {
                    this.serviceNameCombo.removeAll();
                    int i = 0;
                    while (i < this.serviceQNameList.size()) {
                        Object serviceQnameInstance = this.serviceQNameList.get(0);
                        Class QNameClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"javax.xml.namespace.QName");
                        Method GetLocalPartMethod = QNameClass.getMethod("getLocalPart", null);
                        Object resultLocalPart = GetLocalPartMethod.invoke(serviceQnameInstance, null);
                        this.serviceNameCombo.add(resultLocalPart.toString());
                        ++i;
                    }
                    this.serviceNameCombo.select(0);
                    this.loadPortNames();
                } else {
                    if (this.serviceNameCombo != null) {
                        this.serviceNameCombo.removeAll();
                    }
                    if (this.portNameCombo != null) {
                        this.portNameCombo.removeAll();
                    }
                }
                this.populatePackageName();
                this.loadNamespaces(this.reader.getDefinitionNamespaceMap());
            }
        }
        catch (Exception e) {
            this.status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2ConsumptionUIMessages.ERROR_INVALID_WSDL_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    private void loadNamespaces(Map namespaceMap) {
        Iterator namespaces = namespaceMap.values().iterator();
        this.namespace2packageTable.removeAll();
        TableItem[] items = new TableItem[namespaceMap.size()];
        int i = 0;
        while (namespaces.hasNext()) {
            items[i] = new TableItem(this.namespace2packageTable, 0);
            String namespace = (String)namespaces.next();
            items[i].setText(0, namespace);
            items[i].setText(1, this.getPackageFromNamespace(namespace));
            ++i;
        }
        this.namespace2packageTable.setVisible(true);
    }

    private void loadPortNames() {
        List ports;
        int selectionIndex = this.serviceNameCombo.getSelectionIndex();
        if (selectionIndex != -1 && !(ports = this.reader.getPortNameList(this.serviceQNameList.get(selectionIndex))).isEmpty()) {
            this.portNameCombo.removeAll();
            int i = 0;
            while (i < ports.size()) {
                this.portNameCombo.add(ports.get(i).toString());
                ++i;
            }
            this.portNameCombo.select(0);
        }
    }

    public String getPackageFromNamespace(String namespace) {
        Object stringReturn = null;
        try {
            Class URLProcessorClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.util.URLProcessor");
            Method makePackageNameMethod = URLProcessorClass.getMethod("makePackageName", String.class);
            stringReturn = makePackageNameMethod.invoke(null, namespace);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (String)stringReturn;
    }
}

