/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.jst.server.preview.adapter.internal.Trace;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewServerBehaviour;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.osgi.framework.Bundle;

public class PreviewLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final String[] REQUIRED_BUNDLE_IDS = new String[]{"org.apache.commons.logging", "org.apache.commons.el", "javax.servlet", "javax.servlet.jsp", "org.apache.jasper", "org.mortbay.jetty", "org.eclipse.wst.server.preview"};
    private static final String MAIN_CLASS = "org.eclipse.wst.server.preview.internal.PreviewStarter";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IVMInstall vm;
        IVMRunner runner;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace((byte)3, "Launch configuration could not find server");
            return;
        }
        if (server.shouldPublish() && ServerCore.isAutoPublishing()) {
            server.publish(1, monitor);
        }
        PreviewServerBehaviour previewServer = (PreviewServerBehaviour)((Object)server.loadAdapter(PreviewServerBehaviour.class, null));
        int size = REQUIRED_BUNDLE_IDS.length;
        String[] jars = new String[size];
        int i = 0;
        while (i < size) {
            Bundle b = Platform.getBundle((String)REQUIRED_BUNDLE_IDS[i]);
            IPath path = null;
            if (b != null) {
                path = PreviewRuntime.getJarredPluginPath(b);
            }
            if (path == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.preview.adapter", "Could not find required bundle " + REQUIRED_BUNDLE_IDS[i]));
            }
            jars[i] = path.toOSString();
            ++i;
        }
        if (new File(String.valueOf(jars[6]) + "bin").exists()) {
            jars[6] = String.valueOf(jars[6]) + "bin";
        }
        if ((runner = (vm = this.verifyVMInstall(configuration)).getVMRunner(mode)) == null) {
            runner = vm.getVMRunner("run");
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = "\"" + previewServer.getTempDirectory().append("preview.xml").toOSString() + "\"";
        String vmArgs = this.getVMArguments(configuration);
        String[] envp = this.getEnvironment(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath2 = this.getClasspath(configuration);
        String[] classpath = new String[classpath2.length + REQUIRED_BUNDLE_IDS.length];
        System.arraycopy(jars, 0, classpath, 0, REQUIRED_BUNDLE_IDS.length);
        System.arraycopy(classpath2, 0, classpath, REQUIRED_BUNDLE_IDS.length, classpath2.length);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(MAIN_CLASS, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        previewServer.setupLaunch(launch, mode, monitor);
        if ("profile".equals(mode)) {
            ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vm, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
        }
        try {
            runner.run(runConfig, launch, monitor);
            previewServer.addProcessListener(launch.getProcesses()[0]);
        }
        catch (Exception exception) {}
    }
}

