/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HTMLAttributeValidator
extends PrimeValidator {
    private static final int REGION_NAME = 1;
    private static final int REGION_VALUE = 2;
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    static /* synthetic */ Class class$0;

    private Segment getErrorSegment(IDOMNode errorNode, int regionType) {
        IDOMElement ownerElement;
        ITextRegion rgn = null;
        switch (regionType) {
            case 1: {
                rgn = errorNode.getNameRegion();
                break;
            }
            case 2: {
                rgn = errorNode.getValueRegion();
                break;
            }
        }
        if (rgn != null && errorNode instanceof IDOMAttr && (ownerElement = (IDOMElement)((IDOMAttr)errorNode).getOwnerElement()) != null) {
            int regionStartOffset = ownerElement.getFirstStructuredDocumentRegion().getStartOffset(rgn);
            int regionLength = rgn.getLength();
            return new Segment(regionStartOffset, regionLength);
        }
        return new Segment(errorNode.getStartOffset(), 0);
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.html.core.internal.validate.HTMLAttributeValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        Element target = (Element)node;
        if (CMUtil.isForeign(target)) {
            return;
        }
        CMElementDeclaration edec = CMUtil.getDeclaration(target);
        if (edec == null) {
            return;
        }
        Object declarations = edec.getAttributes();
        CMNamedNodeMapImpl allAttributes = new CMNamedNodeMapImpl((CMNamedNodeMap)declarations){
            private Map caseInsensitive;

            private Map getCaseInsensitiveMap() {
                if (this.caseInsensitive == null) {
                    this.caseInsensitive = new HashMap();
                }
                return this.caseInsensitive;
            }

            public CMNode getNamedItem(String name) {
                CMNode node = super.getNamedItem(name);
                if (node == null) {
                    node = (CMNode)this.getCaseInsensitiveMap().get(name.toLowerCase(Locale.US));
                }
                return node;
            }

            public void put(CMNode cmNode) {
                super.put(cmNode);
                this.getCaseInsensitiveMap().put(cmNode.getNodeName().toLowerCase(Locale.US), cmNode);
            }
        };
        List nodes = ModelQueryUtil.getModelQuery((Document)target.getOwnerDocument()).getAvailableContent((Element)node, edec, 1);
        int k = 0;
        while (k < nodes.size()) {
            CMNode cmnode = (CMNode)nodes.get(k);
            if (cmnode.getNodeType() == 2) {
                allAttributes.put(cmnode);
            }
            ++k;
        }
        declarations = allAttributes;
        NamedNodeMap attrs = target.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            block18: {
                Segment seg;
                Attr a;
                int state;
                int rgnType;
                block20: {
                    String source;
                    CMAttributeDeclaration adec;
                    boolean isXMLAttr;
                    block22: {
                        String desired;
                        block21: {
                            block19: {
                                IDOMAttr xmlattr;
                                rgnType = 1;
                                state = 0;
                                a = (Attr)attrs.item(i);
                                isXMLAttr = a instanceof IDOMAttr;
                                if (isXMLAttr && !(xmlattr = (IDOMAttr)a).isGlobalAttr()) break block18;
                                adec = (CMAttributeDeclaration)declarations.getNamedItem(a.getName());
                                if (adec != null) break block19;
                                if (!this.hasNestedRegion(((IDOMNode)a).getNameRegion())) {
                                    rgnType = 1;
                                    state = 11;
                                }
                                break block20;
                            }
                            if (!CMUtil.isHTML(edec) || CMUtil.isXHTML(edec)) break block21;
                            if (!CMUtil.isBooleanAttr(adec) || !((IDOMAttr)a).hasNameOnly()) break block22;
                            break block18;
                        }
                        String actual = a.getName();
                        if (!actual.equals(desired = adec.getAttrName())) {
                            rgnType = 1;
                            state = 103;
                        }
                    }
                    if (state == 0) {
                        CMDataType attrType = adec.getAttrType();
                        String actualValue = a.getValue();
                        if (attrType.getImpliedValueKind() == 2) {
                            String validValue = attrType.getImpliedValue();
                            if (!actualValue.equals(validValue)) {
                                rgnType = 2;
                                state = 12;
                            }
                        } else {
                            String[] candidates = attrType.getEnumeratedValues();
                            if (candidates != null && candidates.length > 0) {
                                boolean found = false;
                                int index = 0;
                                while (index < candidates.length) {
                                    String candidate = candidates[index];
                                    if (actualValue.equalsIgnoreCase(candidate)) {
                                        found = true;
                                        if (!CMUtil.isCaseSensitive(edec) || actualValue.equals(candidate)) break;
                                        rgnType = 2;
                                        state = 13;
                                        break;
                                    }
                                    ++index;
                                }
                                if (!found && !this.hasNestedRegion(((IDOMNode)a).getValueRegion())) {
                                    rgnType = 2;
                                    state = 12;
                                }
                            }
                        }
                    }
                    if (state == 0 && isXMLAttr && (source = ((IDOMAttr)a).getValueRegionText()) != null) {
                        char firstChar = source.charAt(0);
                        char lastChar = source.charAt(source.length() - 1);
                        if ((this.isQuote(firstChar) || this.isQuote(lastChar)) && lastChar != firstChar) {
                            rgnType = 2;
                            state = 113;
                        }
                    }
                }
                if (state != 0 && (seg = this.getErrorSegment((IDOMNode)a, rgnType)) != null) {
                    this.reporter.report((ErrorInfo)new ErrorInfoImpl(state, seg, a));
                }
            }
            ++i;
        }
    }

    private boolean hasNestedRegion(ITextRegion container) {
        if (!(container instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)container).getRegions();
        return regions != null;
    }

    private boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }
}

