/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.FMUtil;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLElementContentValidator
extends PrimeValidator {
    static /* synthetic */ Class class$0;

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.html.core.internal.validate.HTMLElementContentValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        Element target = (Element)node;
        if (CMUtil.isForeign(target)) {
            return;
        }
        this.validateContent(target, target.getChildNodes());
    }

    private void validateContent(Element parent, NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null) {
                this.validateNode(parent, child);
            }
            ++i;
        }
    }

    private void validateNode(Element target, Node child) {
        Segment errorSeg;
        int contentType = 0;
        CMElementDeclaration edec = CMUtil.getDeclaration(target);
        if (edec != null) {
            contentType = edec.getContentType();
        }
        int error = 0;
        int segType = 1;
        switch (child.getNodeType()) {
            case 1: {
                Element childElem = (Element)child;
                if (CMUtil.isForeign(childElem)) {
                    return;
                }
                CMElementDeclaration ced = CMUtil.getDeclaration((Element)child);
                if (ced == null || CMUtil.isSSI(ced) || !CMUtil.isHTML(ced)) {
                    return;
                }
                switch (contentType) {
                    case 0: {
                        return;
                    }
                    case 2: 
                    case 3: {
                        if (ced == null) {
                            return;
                        }
                        if (CMUtil.isValidChild(edec, ced)) {
                            return;
                        }
                        if (!CMUtil.isXHTML(edec) && CMUtil.isValidInclusion(ced, target)) {
                            return;
                        }
                        error = 1001;
                        break;
                    }
                    default: {
                        error = 1001;
                    }
                }
                segType = 2;
                break;
            }
            case 3: {
                switch (contentType) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return;
                    }
                    case 1: 
                    case 2: {
                        if (((IDOMText)child).isElementContentWhitespace()) {
                            return;
                        }
                        error = 1001;
                        break;
                    }
                    default: {
                        error = 1001;
                    }
                }
                segType = 1;
                break;
            }
            case 7: 
            case 8: {
                if (contentType != 1) {
                    return;
                }
                error = 1001;
                segType = 1;
                break;
            }
            default: {
                error = 1001;
                segType = 1;
            }
        }
        if (error != 0 && (errorSeg = FMUtil.getSegment((IDOMNode)child, segType)) != null) {
            this.reporter.report((ErrorInfo)new ErrorInfoImpl(error, errorSeg, child));
        }
    }
}

