/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.component;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.Decorator;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ResolverUtil;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.ui.internal.component.ComponentDetailTableProvider;
import org.eclipse.jst.jsf.ui.internal.component.ComponentTreeViewProvider;
import org.eclipse.jst.jsf.ui.internal.component.DTJSFViewModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ComponentTreeView
extends PageBookView {
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage("Nothing to display");
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        ComponentPage page = new ComponentPage(this.getDocumentFromPart(part));
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    private IDocument getDocumentFromPart(IWorkbenchPart part) {
        return (IDocument)part.getAdapter(IDocument.class);
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        DesignTimeApplicationManager manager;
        IFile file;
        IDocument document = this.getDocumentFromPart(part);
        if (document != null && (file = ResolverUtil.getFileForDocument((IDocument)document)) != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null) {
            return manager.hasDTFacesContext(file);
        }
        return false;
    }

    private static class ComponentPage
    extends Page {
        private TreeViewer _treeViewer;
        private final IDocument _document;
        private TableViewer _detailsViewer;
        private Composite _splitThePane;

        public ComponentPage(IDocument document) {
            this._document = document;
        }

        public void createControl(Composite parent) {
            GridData gridData = new GridData(4, 4, true, true);
            this._splitThePane = new Composite(parent, 0);
            this._splitThePane.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(2, true);
            this._splitThePane.setLayout((Layout)layout);
            this._treeViewer = new TreeViewer(this._splitThePane, 2818);
            this._treeViewer.getTree().setLayoutData((Object)gridData);
            this._treeViewer.setContentProvider((IContentProvider)new ComponentTreeViewProvider());
            this._treeViewer.setLabelProvider((IBaseLabelProvider)new TreeViewLabelProvider());
            this._treeViewer.setSorter((ViewerSorter)new ComponentTreeSorter());
            final DTJSFViewModel model = new DTJSFViewModel((IStructuredDocument)this._document);
            model.init(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ComponentPage.this._treeViewer.setInput((Object)model);
                        }
                    });
                }
            });
            this._detailsViewer = new TableViewer(this._splitThePane, 2818);
            this._detailsViewer.getTable().setLayoutData((Object)gridData);
            TableColumn column = new TableColumn(this._detailsViewer.getTable(), 0);
            column.setWidth(100);
            column = new TableColumn(this._detailsViewer.getTable(), 0);
            column.setWidth(100);
            this._detailsViewer.setContentProvider((IContentProvider)new ComponentDetailTableProvider());
            this._detailsViewer.setLabelProvider((IBaseLabelProvider)new ComponentDetailLabelProvider());
            this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection != null && selection.size() > 0) {
                        ComponentPage.this._detailsViewer.setInput(selection.getFirstElement());
                    }
                }
            });
        }

        public Control getControl() {
            return this._splitThePane;
        }

        public void setFocus() {
        }

        static class ComponentDetailLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            ComponentDetailLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String columnText = this.getText(element);
                if (element instanceof ComponentDetailTableProvider.ComponentProperty) {
                    switch (columnIndex) {
                        case 0: {
                            columnText = ((ComponentDetailTableProvider.ComponentProperty)element).getName();
                            break;
                        }
                        case 1: {
                            Object val = ((ComponentDetailTableProvider.ComponentProperty)element).getValue();
                            columnText = val != null ? val.toString() : "null";
                        }
                    }
                }
                return columnText;
            }
        }

        static class TreeViewLabelProvider
        extends LabelProvider {
            TreeViewLabelProvider() {
            }

            public String getText(Object obj) {
                return obj.toString();
            }

            public Image getImage(Object obj) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
        }
    }

    private static class ComponentTreeSorter
    extends ViewerSorter {
        private ComponentTreeSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return 0;
        }

        public int category(Object element) {
            if (element instanceof Decorator) {
                return 0;
            }
            return 1;
        }
    }
}

