/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.component;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class DTJSFViewModel {
    private final IStructuredDocument _document;
    private final IProject _project;
    private final IFile _file;
    private DTUIViewRoot _treeRoot;
    private final IStructuredDocumentContext _context;

    public DTJSFViewModel(IStructuredDocument document) {
        this._document = document;
        this._context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._document, -1);
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this._context);
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this._project = resolver.getProject();
        this._file = (IFile)resolver.getResource();
        if (this._project == null || this._file == null) {
            throw new IllegalArgumentException();
        }
    }

    public final IStructuredDocument getDocument() {
        return this._document;
    }

    public void init(Runnable runnable) {
        DTFacesContext facesContext;
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._project);
        if (manager != null && (facesContext = manager.getFacesContext(this._file)) != null) {
            this._treeRoot = facesContext.getViewRoot();
            this._treeRoot.refresh(runnable);
        }
    }

    public DTUIViewRoot getRoot() {
        return this._treeRoot;
    }
}

